@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin

import com.pulumi.alicloud.cfg.AggregateCompliancePackArgs.builder
import com.pulumi.alicloud.cfg.kotlin.inputs.AggregateCompliancePackConfigRuleArgs
import com.pulumi.alicloud.cfg.kotlin.inputs.AggregateCompliancePackConfigRuleArgsBuilder
import com.pulumi.alicloud.cfg.kotlin.inputs.AggregateCompliancePackConfigRuleIdArgs
import com.pulumi.alicloud.cfg.kotlin.inputs.AggregateCompliancePackConfigRuleIdArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Config Aggregate Compliance Pack resource.
 * For information about Cloud Config Aggregate Compliance Pack and how to use it, see [What is Aggregate Compliance Pack](https://www.alibabacloud.com/help/en/cloud-config/latest/api-config-2020-09-07-createaggregatecompliancepack).
 * > **NOTE:** Available since v1.124.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform_example";
 * const default = alicloud.resourcemanager.getAccounts({
 *     status: "CreateSuccess",
 * });
 * const defaultAggregator = new alicloud.cfg.Aggregator("default", {
 *     aggregatorAccounts: [{
 *         accountId: _default.then(_default => _default.accounts?.[0]?.accountId),
 *         accountName: _default.then(_default => _default.accounts?.[0]?.displayName),
 *         accountType: "ResourceDirectory",
 *     }],
 *     aggregatorName: name,
 *     description: name,
 *     aggregatorType: "CUSTOM",
 * });
 * const defaultAggregateConfigRule = new alicloud.cfg.AggregateConfigRule("default", {
 *     aggregateConfigRuleName: "contains-tag",
 *     aggregatorId: defaultAggregator.id,
 *     configRuleTriggerTypes: "ConfigurationItemChangeNotification",
 *     sourceOwner: "ALIYUN",
 *     sourceIdentifier: "contains-tag",
 *     description: name,
 *     riskLevel: 1,
 *     resourceTypesScopes: ["ACS::ECS::Instance"],
 *     inputParameters: {
 *         key: "example",
 *         value: "example",
 *     },
 * });
 * const defaultAggregateCompliancePack = new alicloud.cfg.AggregateCompliancePack("default", {
 *     aggregateCompliancePackName: name,
 *     aggregatorId: defaultAggregator.id,
 *     description: name,
 *     riskLevel: 1,
 *     configRuleIds: [{
 *         configRuleId: defaultAggregateConfigRule.configRuleId,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform_example"
 * default = alicloud.resourcemanager.get_accounts(status="CreateSuccess")
 * default_aggregator = alicloud.cfg.Aggregator("default",
 *     aggregator_accounts=[{
 *         "account_id": default.accounts[0].account_id,
 *         "account_name": default.accounts[0].display_name,
 *         "account_type": "ResourceDirectory",
 *     }],
 *     aggregator_name=name,
 *     description=name,
 *     aggregator_type="CUSTOM")
 * default_aggregate_config_rule = alicloud.cfg.AggregateConfigRule("default",
 *     aggregate_config_rule_name="contains-tag",
 *     aggregator_id=default_aggregator.id,
 *     config_rule_trigger_types="ConfigurationItemChangeNotification",
 *     source_owner="ALIYUN",
 *     source_identifier="contains-tag",
 *     description=name,
 *     risk_level=1,
 *     resource_types_scopes=["ACS::ECS::Instance"],
 *     input_parameters={
 *         "key": "example",
 *         "value": "example",
 *     })
 * default_aggregate_compliance_pack = alicloud.cfg.AggregateCompliancePack("default",
 *     aggregate_compliance_pack_name=name,
 *     aggregator_id=default_aggregator.id,
 *     description=name,
 *     risk_level=1,
 *     config_rule_ids=[{
 *         "config_rule_id": default_aggregate_config_rule.config_rule_id,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform_example";
 *     var @default = AliCloud.ResourceManager.GetAccounts.Invoke(new()
 *     {
 *         Status = "CreateSuccess",
 *     });
 *     var defaultAggregator = new AliCloud.Cfg.Aggregator("default", new()
 *     {
 *         AggregatorAccounts = new[]
 *         {
 *             new AliCloud.Cfg.Inputs.AggregatorAggregatorAccountArgs
 *             {
 *                 AccountId = @default.Apply(@default => @default.Apply(getAccountsResult => getAccountsResult.Accounts[0]?.AccountId)),
 *                 AccountName = @default.Apply(@default => @default.Apply(getAccountsResult => getAccountsResult.Accounts[0]?.DisplayName)),
 *                 AccountType = "ResourceDirectory",
 *             },
 *         },
 *         AggregatorName = name,
 *         Description = name,
 *         AggregatorType = "CUSTOM",
 *     });
 *     var defaultAggregateConfigRule = new AliCloud.Cfg.AggregateConfigRule("default", new()
 *     {
 *         AggregateConfigRuleName = "contains-tag",
 *         AggregatorId = defaultAggregator.Id,
 *         ConfigRuleTriggerTypes = "ConfigurationItemChangeNotification",
 *         SourceOwner = "ALIYUN",
 *         SourceIdentifier = "contains-tag",
 *         Description = name,
 *         RiskLevel = 1,
 *         ResourceTypesScopes = new[]
 *         {
 *             "ACS::ECS::Instance",
 *         },
 *         InputParameters =
 *         {
 *             { "key", "example" },
 *             { "value", "example" },
 *         },
 *     });
 *     var defaultAggregateCompliancePack = new AliCloud.Cfg.AggregateCompliancePack("default", new()
 *     {
 *         AggregateCompliancePackName = name,
 *         AggregatorId = defaultAggregator.Id,
 *         Description = name,
 *         RiskLevel = 1,
 *         ConfigRuleIds = new[]
 *         {
 *             new AliCloud.Cfg.Inputs.AggregateCompliancePackConfigRuleIdArgs
 *             {
 *                 ConfigRuleId = defaultAggregateConfigRule.ConfigRuleId,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cfg"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := resourcemanager.GetAccounts(ctx, &resourcemanager.GetAccountsArgs{
 * 			Status: pulumi.StringRef("CreateSuccess"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultAggregator, err := cfg.NewAggregator(ctx, "default", &cfg.AggregatorArgs{
 * 			AggregatorAccounts: cfg.AggregatorAggregatorAccountArray{
 * 				&cfg.AggregatorAggregatorAccountArgs{
 * 					AccountId:   pulumi.String(_default.Accounts[0].AccountId),
 * 					AccountName: pulumi.String(_default.Accounts[0].DisplayName),
 * 					AccountType: pulumi.String("ResourceDirectory"),
 * 				},
 * 			},
 * 			AggregatorName: pulumi.String(name),
 * 			Description:    pulumi.String(name),
 * 			AggregatorType: pulumi.String("CUSTOM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultAggregateConfigRule, err := cfg.NewAggregateConfigRule(ctx, "default", &cfg.AggregateConfigRuleArgs{
 * 			AggregateConfigRuleName: pulumi.String("contains-tag"),
 * 			AggregatorId:            defaultAggregator.ID(),
 * 			ConfigRuleTriggerTypes:  pulumi.String("ConfigurationItemChangeNotification"),
 * 			SourceOwner:             pulumi.String("ALIYUN"),
 * 			SourceIdentifier:        pulumi.String("contains-tag"),
 * 			Description:             pulumi.String(name),
 * 			RiskLevel:               pulumi.Int(1),
 * 			ResourceTypesScopes: pulumi.StringArray{
 * 				pulumi.String("ACS::ECS::Instance"),
 * 			},
 * 			InputParameters: pulumi.StringMap{
 * 				"key":   pulumi.String("example"),
 * 				"value": pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cfg.NewAggregateCompliancePack(ctx, "default", &cfg.AggregateCompliancePackArgs{
 * 			AggregateCompliancePackName: pulumi.String(name),
 * 			AggregatorId:                defaultAggregator.ID(),
 * 			Description:                 pulumi.String(name),
 * 			RiskLevel:                   pulumi.Int(1),
 * 			ConfigRuleIds: cfg.AggregateCompliancePackConfigRuleIdArray{
 * 				&cfg.AggregateCompliancePackConfigRuleIdArgs{
 * 					ConfigRuleId: defaultAggregateConfigRule.ConfigRuleId,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetAccountsArgs;
 * import com.pulumi.alicloud.cfg.Aggregator;
 * import com.pulumi.alicloud.cfg.AggregatorArgs;
 * import com.pulumi.alicloud.cfg.inputs.AggregatorAggregatorAccountArgs;
 * import com.pulumi.alicloud.cfg.AggregateConfigRule;
 * import com.pulumi.alicloud.cfg.AggregateConfigRuleArgs;
 * import com.pulumi.alicloud.cfg.AggregateCompliancePack;
 * import com.pulumi.alicloud.cfg.AggregateCompliancePackArgs;
 * import com.pulumi.alicloud.cfg.inputs.AggregateCompliancePackConfigRuleIdArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform_example");
 *         final var default = ResourcemanagerFunctions.getAccounts(GetAccountsArgs.builder()
 *             .status("CreateSuccess")
 *             .build());
 *         var defaultAggregator = new Aggregator("defaultAggregator", AggregatorArgs.builder()
 *             .aggregatorAccounts(AggregatorAggregatorAccountArgs.builder()
 *                 .accountId(default_.accounts()[0].accountId())
 *                 .accountName(default_.accounts()[0].displayName())
 *                 .accountType("ResourceDirectory")
 *                 .build())
 *             .aggregatorName(name)
 *             .description(name)
 *             .aggregatorType("CUSTOM")
 *             .build());
 *         var defaultAggregateConfigRule = new AggregateConfigRule("defaultAggregateConfigRule", AggregateConfigRuleArgs.builder()
 *             .aggregateConfigRuleName("contains-tag")
 *             .aggregatorId(defaultAggregator.id())
 *             .configRuleTriggerTypes("ConfigurationItemChangeNotification")
 *             .sourceOwner("ALIYUN")
 *             .sourceIdentifier("contains-tag")
 *             .description(name)
 *             .riskLevel(1)
 *             .resourceTypesScopes("ACS::ECS::Instance")
 *             .inputParameters(Map.ofEntries(
 *                 Map.entry("key", "example"),
 *                 Map.entry("value", "example")
 *             ))
 *             .build());
 *         var defaultAggregateCompliancePack = new AggregateCompliancePack("defaultAggregateCompliancePack", AggregateCompliancePackArgs.builder()
 *             .aggregateCompliancePackName(name)
 *             .aggregatorId(defaultAggregator.id())
 *             .description(name)
 *             .riskLevel(1)
 *             .configRuleIds(AggregateCompliancePackConfigRuleIdArgs.builder()
 *                 .configRuleId(defaultAggregateConfigRule.configRuleId())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform_example
 * resources:
 *   defaultAggregator:
 *     type: alicloud:cfg:Aggregator
 *     name: default
 *     properties:
 *       aggregatorAccounts:
 *         - accountId: ${default.accounts[0].accountId}
 *           accountName: ${default.accounts[0].displayName}
 *           accountType: ResourceDirectory
 *       aggregatorName: ${name}
 *       description: ${name}
 *       aggregatorType: CUSTOM
 *   defaultAggregateConfigRule:
 *     type: alicloud:cfg:AggregateConfigRule
 *     name: default
 *     properties:
 *       aggregateConfigRuleName: contains-tag
 *       aggregatorId: ${defaultAggregator.id}
 *       configRuleTriggerTypes: ConfigurationItemChangeNotification
 *       sourceOwner: ALIYUN
 *       sourceIdentifier: contains-tag
 *       description: ${name}
 *       riskLevel: 1
 *       resourceTypesScopes:
 *         - ACS::ECS::Instance
 *       inputParameters:
 *         key: example
 *         value: example
 *   defaultAggregateCompliancePack:
 *     type: alicloud:cfg:AggregateCompliancePack
 *     name: default
 *     properties:
 *       aggregateCompliancePackName: ${name}
 *       aggregatorId: ${defaultAggregator.id}
 *       description: ${name}
 *       riskLevel: 1
 *       configRuleIds:
 *         - configRuleId: ${defaultAggregateConfigRule.configRuleId}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getAccounts
 *       Arguments:
 *         status: CreateSuccess
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Config Aggregate Compliance Pack can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cfg/aggregateCompliancePack:AggregateCompliancePack example <aggregator_id>:<aggregator_compliance_pack_id>
 * ```
 * @property aggregateCompliancePackName The name of compliance package name. **NOTE:** From version 1.145.0, `aggregate_compliance_pack_name` can be modified.
 * @property aggregatorId The ID of aggregator.
 * @property compliancePackTemplateId The Template ID of compliance package.
 * @property configRuleIds A list of Config Rule IDs. See `config_rule_ids` below.
 * @property configRules A list of Config Rules. See `config_rules` below. **NOTE:** Field `config_rules` has been deprecated from provider version 1.141.0. New field `config_rule_ids` instead.
 * @property description The description of compliance package.
 * @property riskLevel The Risk Level. Valid values:
 */
public data class AggregateCompliancePackArgs(
    public val aggregateCompliancePackName: Output<String>? = null,
    public val aggregatorId: Output<String>? = null,
    public val compliancePackTemplateId: Output<String>? = null,
    public val configRuleIds: Output<List<AggregateCompliancePackConfigRuleIdArgs>>? = null,
    @Deprecated(
        message = """
  Field `config_rules` has been deprecated from provider version 1.141.0. New field
      `config_rule_ids` instead.
  """,
    )
    public val configRules: Output<List<AggregateCompliancePackConfigRuleArgs>>? = null,
    public val description: Output<String>? = null,
    public val riskLevel: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cfg.AggregateCompliancePackArgs> {
    override fun toJava(): com.pulumi.alicloud.cfg.AggregateCompliancePackArgs =
        com.pulumi.alicloud.cfg.AggregateCompliancePackArgs.builder()
            .aggregateCompliancePackName(aggregateCompliancePackName?.applyValue({ args0 -> args0 }))
            .aggregatorId(aggregatorId?.applyValue({ args0 -> args0 }))
            .compliancePackTemplateId(compliancePackTemplateId?.applyValue({ args0 -> args0 }))
            .configRuleIds(
                configRuleIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .configRules(
                configRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .riskLevel(riskLevel?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AggregateCompliancePackArgs].
 */
@PulumiTagMarker
public class AggregateCompliancePackArgsBuilder internal constructor() {
    private var aggregateCompliancePackName: Output<String>? = null

    private var aggregatorId: Output<String>? = null

    private var compliancePackTemplateId: Output<String>? = null

    private var configRuleIds: Output<List<AggregateCompliancePackConfigRuleIdArgs>>? = null

    private var configRules: Output<List<AggregateCompliancePackConfigRuleArgs>>? = null

    private var description: Output<String>? = null

    private var riskLevel: Output<Int>? = null

    /**
     * @param value The name of compliance package name. **NOTE:** From version 1.145.0, `aggregate_compliance_pack_name` can be modified.
     */
    @JvmName("muoofjdnndakboqv")
    public suspend fun aggregateCompliancePackName(`value`: Output<String>) {
        this.aggregateCompliancePackName = value
    }

    /**
     * @param value The ID of aggregator.
     */
    @JvmName("ailcgncgmpihnemb")
    public suspend fun aggregatorId(`value`: Output<String>) {
        this.aggregatorId = value
    }

    /**
     * @param value The Template ID of compliance package.
     */
    @JvmName("dusamjcfomcmiecn")
    public suspend fun compliancePackTemplateId(`value`: Output<String>) {
        this.compliancePackTemplateId = value
    }

    /**
     * @param value A list of Config Rule IDs. See `config_rule_ids` below.
     */
    @JvmName("avvkshgdlafoqihm")
    public suspend fun configRuleIds(`value`: Output<List<AggregateCompliancePackConfigRuleIdArgs>>) {
        this.configRuleIds = value
    }

    @JvmName("owshxcouiyqxmyrl")
    public suspend fun configRuleIds(vararg values: Output<AggregateCompliancePackConfigRuleIdArgs>) {
        this.configRuleIds = Output.all(values.asList())
    }

    /**
     * @param values A list of Config Rule IDs. See `config_rule_ids` below.
     */
    @JvmName("ovdqolrsackaednn")
    public suspend fun configRuleIds(values: List<Output<AggregateCompliancePackConfigRuleIdArgs>>) {
        this.configRuleIds = Output.all(values)
    }

    /**
     * @param value A list of Config Rules. See `config_rules` below. **NOTE:** Field `config_rules` has been deprecated from provider version 1.141.0. New field `config_rule_ids` instead.
     */
    @Deprecated(
        message = """
  Field `config_rules` has been deprecated from provider version 1.141.0. New field
      `config_rule_ids` instead.
  """,
    )
    @JvmName("vmgfjdbojthlwmhq")
    public suspend fun configRules(`value`: Output<List<AggregateCompliancePackConfigRuleArgs>>) {
        this.configRules = value
    }

    @JvmName("pemofenuxysggqbs")
    public suspend fun configRules(vararg values: Output<AggregateCompliancePackConfigRuleArgs>) {
        this.configRules = Output.all(values.asList())
    }

    /**
     * @param values A list of Config Rules. See `config_rules` below. **NOTE:** Field `config_rules` has been deprecated from provider version 1.141.0. New field `config_rule_ids` instead.
     */
    @Deprecated(
        message = """
  Field `config_rules` has been deprecated from provider version 1.141.0. New field
      `config_rule_ids` instead.
  """,
    )
    @JvmName("sehtxihpoitypcpw")
    public suspend fun configRules(values: List<Output<AggregateCompliancePackConfigRuleArgs>>) {
        this.configRules = Output.all(values)
    }

    /**
     * @param value The description of compliance package.
     */
    @JvmName("edllgrtbgknplvqa")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The Risk Level. Valid values:
     */
    @JvmName("dilaxddfsgqrrxqg")
    public suspend fun riskLevel(`value`: Output<Int>) {
        this.riskLevel = value
    }

    /**
     * @param value The name of compliance package name. **NOTE:** From version 1.145.0, `aggregate_compliance_pack_name` can be modified.
     */
    @JvmName("ptygnwcratbbcwgp")
    public suspend fun aggregateCompliancePackName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aggregateCompliancePackName = mapped
    }

    /**
     * @param value The ID of aggregator.
     */
    @JvmName("ewgpglasvvcethut")
    public suspend fun aggregatorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aggregatorId = mapped
    }

    /**
     * @param value The Template ID of compliance package.
     */
    @JvmName("khcbkgsebkcabmbk")
    public suspend fun compliancePackTemplateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compliancePackTemplateId = mapped
    }

    /**
     * @param value A list of Config Rule IDs. See `config_rule_ids` below.
     */
    @JvmName("uapudldocvcvleul")
    public suspend fun configRuleIds(`value`: List<AggregateCompliancePackConfigRuleIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configRuleIds = mapped
    }

    /**
     * @param argument A list of Config Rule IDs. See `config_rule_ids` below.
     */
    @JvmName("wehgwmaahkoduokw")
    public suspend fun configRuleIds(argument: List<suspend AggregateCompliancePackConfigRuleIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AggregateCompliancePackConfigRuleIdArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.configRuleIds = mapped
    }

    /**
     * @param argument A list of Config Rule IDs. See `config_rule_ids` below.
     */
    @JvmName("qdftrarvrqogppqu")
    public suspend fun configRuleIds(vararg argument: suspend AggregateCompliancePackConfigRuleIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AggregateCompliancePackConfigRuleIdArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.configRuleIds = mapped
    }

    /**
     * @param argument A list of Config Rule IDs. See `config_rule_ids` below.
     */
    @JvmName("ysawimbuenvtjdcs")
    public suspend fun configRuleIds(argument: suspend AggregateCompliancePackConfigRuleIdArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AggregateCompliancePackConfigRuleIdArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.configRuleIds = mapped
    }

    /**
     * @param values A list of Config Rule IDs. See `config_rule_ids` below.
     */
    @JvmName("jtejqcxgxxtlnraf")
    public suspend fun configRuleIds(vararg values: AggregateCompliancePackConfigRuleIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configRuleIds = mapped
    }

    /**
     * @param value A list of Config Rules. See `config_rules` below. **NOTE:** Field `config_rules` has been deprecated from provider version 1.141.0. New field `config_rule_ids` instead.
     */
    @Deprecated(
        message = """
  Field `config_rules` has been deprecated from provider version 1.141.0. New field
      `config_rule_ids` instead.
  """,
    )
    @JvmName("mdremnfefmekmhvx")
    public suspend fun configRules(`value`: List<AggregateCompliancePackConfigRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configRules = mapped
    }

    /**
     * @param argument A list of Config Rules. See `config_rules` below. **NOTE:** Field `config_rules` has been deprecated from provider version 1.141.0. New field `config_rule_ids` instead.
     */
    @Deprecated(
        message = """
  Field `config_rules` has been deprecated from provider version 1.141.0. New field
      `config_rule_ids` instead.
  """,
    )
    @JvmName("hhpiwmnliqqeqxyy")
    public suspend fun configRules(argument: List<suspend AggregateCompliancePackConfigRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AggregateCompliancePackConfigRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.configRules = mapped
    }

    /**
     * @param argument A list of Config Rules. See `config_rules` below. **NOTE:** Field `config_rules` has been deprecated from provider version 1.141.0. New field `config_rule_ids` instead.
     */
    @Deprecated(
        message = """
  Field `config_rules` has been deprecated from provider version 1.141.0. New field
      `config_rule_ids` instead.
  """,
    )
    @JvmName("aeyypwowjgxyssxa")
    public suspend fun configRules(vararg argument: suspend AggregateCompliancePackConfigRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AggregateCompliancePackConfigRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.configRules = mapped
    }

    /**
     * @param argument A list of Config Rules. See `config_rules` below. **NOTE:** Field `config_rules` has been deprecated from provider version 1.141.0. New field `config_rule_ids` instead.
     */
    @Deprecated(
        message = """
  Field `config_rules` has been deprecated from provider version 1.141.0. New field
      `config_rule_ids` instead.
  """,
    )
    @JvmName("ibvfsfrcjkjdlusk")
    public suspend fun configRules(argument: suspend AggregateCompliancePackConfigRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AggregateCompliancePackConfigRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.configRules = mapped
    }

    /**
     * @param values A list of Config Rules. See `config_rules` below. **NOTE:** Field `config_rules` has been deprecated from provider version 1.141.0. New field `config_rule_ids` instead.
     */
    @Deprecated(
        message = """
  Field `config_rules` has been deprecated from provider version 1.141.0. New field
      `config_rule_ids` instead.
  """,
    )
    @JvmName("iglsmqkrbdykucus")
    public suspend fun configRules(vararg values: AggregateCompliancePackConfigRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configRules = mapped
    }

    /**
     * @param value The description of compliance package.
     */
    @JvmName("xgwmxsoocrgtglws")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The Risk Level. Valid values:
     */
    @JvmName("oaaogtvfxscyhafd")
    public suspend fun riskLevel(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.riskLevel = mapped
    }

    internal fun build(): AggregateCompliancePackArgs = AggregateCompliancePackArgs(
        aggregateCompliancePackName = aggregateCompliancePackName,
        aggregatorId = aggregatorId,
        compliancePackTemplateId = compliancePackTemplateId,
        configRuleIds = configRuleIds,
        configRules = configRules,
        description = description,
        riskLevel = riskLevel,
    )
}
