@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [AggregateConfigRule].
 */
@PulumiTagMarker
public class AggregateConfigRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AggregateConfigRuleArgs = AggregateConfigRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AggregateConfigRuleArgsBuilder.() -> Unit) {
        val builder = AggregateConfigRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AggregateConfigRule {
        val builtJavaResource = com.pulumi.alicloud.cfg.AggregateConfigRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AggregateConfigRule(builtJavaResource)
    }
}

/**
 * Provides a Cloud Config Aggregate Config Rule resource.
 * For information about Cloud Config Aggregate Config Rule and how to use it, see [What is Aggregate Config Rule](https://www.alibabacloud.com/help/en/cloud-config/latest/api-config-2020-09-07-createaggregateconfigrule).
 * > **NOTE:** Available since v1.124.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.resourcemanager.getAccounts({
 *     status: "CreateSuccess",
 * });
 * const defaultAggregator = new alicloud.cfg.Aggregator("default", {
 *     aggregatorAccounts: [{
 *         accountId: _default.then(_default => _default.accounts?.[0]?.accountId),
 *         accountName: _default.then(_default => _default.accounts?.[0]?.displayName),
 *         accountType: "ResourceDirectory",
 *     }],
 *     aggregatorName: name,
 *     description: name,
 *     aggregatorType: "CUSTOM",
 * });
 * const defaultAggregateConfigRule = new alicloud.cfg.AggregateConfigRule("default", {
 *     aggregateConfigRuleName: "contains-tag",
 *     aggregatorId: defaultAggregator.id,
 *     configRuleTriggerTypes: "ConfigurationItemChangeNotification",
 *     sourceOwner: "ALIYUN",
 *     sourceIdentifier: "contains-tag",
 *     riskLevel: 1,
 *     resourceTypesScopes: ["ACS::ECS::Instance"],
 *     inputParameters: {
 *         key: "example",
 *         value: "example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.resourcemanager.get_accounts(status="CreateSuccess")
 * default_aggregator = alicloud.cfg.Aggregator("default",
 *     aggregator_accounts=[{
 *         "account_id": default.accounts[0].account_id,
 *         "account_name": default.accounts[0].display_name,
 *         "account_type": "ResourceDirectory",
 *     }],
 *     aggregator_name=name,
 *     description=name,
 *     aggregator_type="CUSTOM")
 * default_aggregate_config_rule = alicloud.cfg.AggregateConfigRule("default",
 *     aggregate_config_rule_name="contains-tag",
 *     aggregator_id=default_aggregator.id,
 *     config_rule_trigger_types="ConfigurationItemChangeNotification",
 *     source_owner="ALIYUN",
 *     source_identifier="contains-tag",
 *     risk_level=1,
 *     resource_types_scopes=["ACS::ECS::Instance"],
 *     input_parameters={
 *         "key": "example",
 *         "value": "example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.ResourceManager.GetAccounts.Invoke(new()
 *     {
 *         Status = "CreateSuccess",
 *     });
 *     var defaultAggregator = new AliCloud.Cfg.Aggregator("default", new()
 *     {
 *         AggregatorAccounts = new[]
 *         {
 *             new AliCloud.Cfg.Inputs.AggregatorAggregatorAccountArgs
 *             {
 *                 AccountId = @default.Apply(@default => @default.Apply(getAccountsResult => getAccountsResult.Accounts[0]?.AccountId)),
 *                 AccountName = @default.Apply(@default => @default.Apply(getAccountsResult => getAccountsResult.Accounts[0]?.DisplayName)),
 *                 AccountType = "ResourceDirectory",
 *             },
 *         },
 *         AggregatorName = name,
 *         Description = name,
 *         AggregatorType = "CUSTOM",
 *     });
 *     var defaultAggregateConfigRule = new AliCloud.Cfg.AggregateConfigRule("default", new()
 *     {
 *         AggregateConfigRuleName = "contains-tag",
 *         AggregatorId = defaultAggregator.Id,
 *         ConfigRuleTriggerTypes = "ConfigurationItemChangeNotification",
 *         SourceOwner = "ALIYUN",
 *         SourceIdentifier = "contains-tag",
 *         RiskLevel = 1,
 *         ResourceTypesScopes = new[]
 *         {
 *             "ACS::ECS::Instance",
 *         },
 *         InputParameters =
 *         {
 *             { "key", "example" },
 *             { "value", "example" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cfg"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := resourcemanager.GetAccounts(ctx, &resourcemanager.GetAccountsArgs{
 * 			Status: pulumi.StringRef("CreateSuccess"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultAggregator, err := cfg.NewAggregator(ctx, "default", &cfg.AggregatorArgs{
 * 			AggregatorAccounts: cfg.AggregatorAggregatorAccountArray{
 * 				&cfg.AggregatorAggregatorAccountArgs{
 * 					AccountId:   pulumi.String(_default.Accounts[0].AccountId),
 * 					AccountName: pulumi.String(_default.Accounts[0].DisplayName),
 * 					AccountType: pulumi.String("ResourceDirectory"),
 * 				},
 * 			},
 * 			AggregatorName: pulumi.String(name),
 * 			Description:    pulumi.String(name),
 * 			AggregatorType: pulumi.String("CUSTOM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cfg.NewAggregateConfigRule(ctx, "default", &cfg.AggregateConfigRuleArgs{
 * 			AggregateConfigRuleName: pulumi.String("contains-tag"),
 * 			AggregatorId:            defaultAggregator.ID(),
 * 			ConfigRuleTriggerTypes:  pulumi.String("ConfigurationItemChangeNotification"),
 * 			SourceOwner:             pulumi.String("ALIYUN"),
 * 			SourceIdentifier:        pulumi.String("contains-tag"),
 * 			RiskLevel:               pulumi.Int(1),
 * 			ResourceTypesScopes: pulumi.StringArray{
 * 				pulumi.String("ACS::ECS::Instance"),
 * 			},
 * 			InputParameters: pulumi.StringMap{
 * 				"key":   pulumi.String("example"),
 * 				"value": pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetAccountsArgs;
 * import com.pulumi.alicloud.cfg.Aggregator;
 * import com.pulumi.alicloud.cfg.AggregatorArgs;
 * import com.pulumi.alicloud.cfg.inputs.AggregatorAggregatorAccountArgs;
 * import com.pulumi.alicloud.cfg.AggregateConfigRule;
 * import com.pulumi.alicloud.cfg.AggregateConfigRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = ResourcemanagerFunctions.getAccounts(GetAccountsArgs.builder()
 *             .status("CreateSuccess")
 *             .build());
 *         var defaultAggregator = new Aggregator("defaultAggregator", AggregatorArgs.builder()
 *             .aggregatorAccounts(AggregatorAggregatorAccountArgs.builder()
 *                 .accountId(default_.accounts()[0].accountId())
 *                 .accountName(default_.accounts()[0].displayName())
 *                 .accountType("ResourceDirectory")
 *                 .build())
 *             .aggregatorName(name)
 *             .description(name)
 *             .aggregatorType("CUSTOM")
 *             .build());
 *         var defaultAggregateConfigRule = new AggregateConfigRule("defaultAggregateConfigRule", AggregateConfigRuleArgs.builder()
 *             .aggregateConfigRuleName("contains-tag")
 *             .aggregatorId(defaultAggregator.id())
 *             .configRuleTriggerTypes("ConfigurationItemChangeNotification")
 *             .sourceOwner("ALIYUN")
 *             .sourceIdentifier("contains-tag")
 *             .riskLevel(1)
 *             .resourceTypesScopes("ACS::ECS::Instance")
 *             .inputParameters(Map.ofEntries(
 *                 Map.entry("key", "example"),
 *                 Map.entry("value", "example")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultAggregator:
 *     type: alicloud:cfg:Aggregator
 *     name: default
 *     properties:
 *       aggregatorAccounts:
 *         - accountId: ${default.accounts[0].accountId}
 *           accountName: ${default.accounts[0].displayName}
 *           accountType: ResourceDirectory
 *       aggregatorName: ${name}
 *       description: ${name}
 *       aggregatorType: CUSTOM
 *   defaultAggregateConfigRule:
 *     type: alicloud:cfg:AggregateConfigRule
 *     name: default
 *     properties:
 *       aggregateConfigRuleName: contains-tag
 *       aggregatorId: ${defaultAggregator.id}
 *       configRuleTriggerTypes: ConfigurationItemChangeNotification
 *       sourceOwner: ALIYUN
 *       sourceIdentifier: contains-tag
 *       riskLevel: 1
 *       resourceTypesScopes:
 *         - ACS::ECS::Instance
 *       inputParameters:
 *         key: example
 *         value: example
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getAccounts
 *       Arguments:
 *         status: CreateSuccess
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Config Aggregate Config Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cfg/aggregateConfigRule:AggregateConfigRule example "<aggregator_id>:<config_rule_id>"
 * ```
 */
public class AggregateConfigRule internal constructor(
    override val javaResource: com.pulumi.alicloud.cfg.AggregateConfigRule,
) : KotlinCustomResource(javaResource, AggregateConfigRuleMapper) {
    /**
     * The name of the rule.
     */
    public val aggregateConfigRuleName: Output<String>
        get() = javaResource.aggregateConfigRuleName().applyValue({ args0 -> args0 })

    /**
     * The Aggregator Id.
     */
    public val aggregatorId: Output<String>
        get() = javaResource.aggregatorId().applyValue({ args0 -> args0 })

    /**
     * (Available since v1.141.0) The rule ID of Aggregate Config Rule.
     */
    public val configRuleId: Output<String>
        get() = javaResource.configRuleId().applyValue({ args0 -> args0 })

    /**
     * The trigger type of the rule. Valid values: `ConfigurationItemChangeNotification`: The rule is triggered upon configuration changes. `ScheduledNotification`: The rule is triggered as scheduled.
     */
    public val configRuleTriggerTypes: Output<String>
        get() = javaResource.configRuleTriggerTypes().applyValue({ args0 -> args0 })

    /**
     * The description of the rule.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The rule monitors excluded resource IDs, multiple of which are separated by commas, only applies to rules created based on managed rules, , custom rule this field is empty.
     */
    public val excludeResourceIdsScope: Output<String>?
        get() = javaResource.excludeResourceIdsScope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The settings map of the input parameters for the rule.
     */
    public val inputParameters: Output<Map<String, String>>?
        get() = javaResource.inputParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * The frequency of the compliance evaluations. Valid values:  `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, `TwentyFour_Hours`. System default value is `TwentyFour_Hours` and valid when the `config_rule_trigger_types` is `ScheduledNotification`.
     */
    public val maximumExecutionFrequency: Output<String>
        get() = javaResource.maximumExecutionFrequency().applyValue({ args0 -> args0 })

    /**
     * The rule monitors region IDs, separated by commas, only applies to rules created based on managed rules.
     */
    public val regionIdsScope: Output<String>?
        get() = javaResource.regionIdsScope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The rule monitors resource group IDs, separated by commas, only applies to rules created based on managed rules.
     */
    public val resourceGroupIdsScope: Output<String>?
        get() = javaResource.resourceGroupIdsScope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource types to be evaluated. [Alibaba Cloud services that support Cloud Config&#46;](https://www.alibabacloud.com/help/en/doc-detail/127411.htm)
     */
    public val resourceTypesScopes: Output<List<String>>
        get() = javaResource.resourceTypesScopes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The risk level of the resources that are not compliant with the rule. Valid values:  `1`: critical `2`: warning `3`: info.
     */
    public val riskLevel: Output<Int>
        get() = javaResource.riskLevel().applyValue({ args0 -> args0 })

    /**
     * The identifier of the rule. For a managed rule, the value is the identifier of the managed rule. For a custom rule, the value is the ARN of the custom rule. Using managed rules, refer to [List of Managed rules&#46;](https://www.alibabacloud.com/help/en/doc-detail/127404.htm)
     */
    public val sourceIdentifier: Output<String>
        get() = javaResource.sourceIdentifier().applyValue({ args0 -> args0 })

    /**
     * Specifies whether you or Alibaba Cloud owns and manages the rule. Valid values: `CUSTOM_FC`: The rule is a custom rule and you own the rule. `ALIYUN`: The rule is a managed rule and Alibaba Cloud owns the rule.
     */
    public val sourceOwner: Output<String>
        get() = javaResource.sourceOwner().applyValue({ args0 -> args0 })

    /**
     * The rule status. The valid values: `ACTIVE`, `INACTIVE`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The rule monitors the tag key, only applies to rules created based on managed rules.
     */
    public val tagKeyScope: Output<String>?
        get() = javaResource.tagKeyScope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The rule monitors the tag value, use with the `tag_key_scope` options. only applies to rules created based on managed rules.
     */
    public val tagValueScope: Output<String>?
        get() = javaResource.tagValueScope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object AggregateConfigRuleMapper : ResourceMapper<AggregateConfigRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cfg.AggregateConfigRule::class == javaResource::class

    override fun map(javaResource: Resource): AggregateConfigRule = AggregateConfigRule(
        javaResource
            as com.pulumi.alicloud.cfg.AggregateConfigRule,
    )
}

/**
 * @see [AggregateConfigRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AggregateConfigRule].
 */
public suspend fun aggregateConfigRule(
    name: String,
    block: suspend AggregateConfigRuleResourceBuilder.() -> Unit,
): AggregateConfigRule {
    val builder = AggregateConfigRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AggregateConfigRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun aggregateConfigRule(name: String): AggregateConfigRule {
    val builder = AggregateConfigRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
