@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin

import com.pulumi.alicloud.cfg.AggregateConfigRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Config Aggregate Config Rule resource.
 * For information about Cloud Config Aggregate Config Rule and how to use it, see [What is Aggregate Config Rule](https://www.alibabacloud.com/help/en/cloud-config/latest/api-config-2020-09-07-createaggregateconfigrule).
 * > **NOTE:** Available since v1.124.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.resourcemanager.getAccounts({
 *     status: "CreateSuccess",
 * });
 * const defaultAggregator = new alicloud.cfg.Aggregator("default", {
 *     aggregatorAccounts: [{
 *         accountId: _default.then(_default => _default.accounts?.[0]?.accountId),
 *         accountName: _default.then(_default => _default.accounts?.[0]?.displayName),
 *         accountType: "ResourceDirectory",
 *     }],
 *     aggregatorName: name,
 *     description: name,
 *     aggregatorType: "CUSTOM",
 * });
 * const defaultAggregateConfigRule = new alicloud.cfg.AggregateConfigRule("default", {
 *     aggregateConfigRuleName: "contains-tag",
 *     aggregatorId: defaultAggregator.id,
 *     configRuleTriggerTypes: "ConfigurationItemChangeNotification",
 *     sourceOwner: "ALIYUN",
 *     sourceIdentifier: "contains-tag",
 *     riskLevel: 1,
 *     resourceTypesScopes: ["ACS::ECS::Instance"],
 *     inputParameters: {
 *         key: "example",
 *         value: "example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.resourcemanager.get_accounts(status="CreateSuccess")
 * default_aggregator = alicloud.cfg.Aggregator("default",
 *     aggregator_accounts=[{
 *         "account_id": default.accounts[0].account_id,
 *         "account_name": default.accounts[0].display_name,
 *         "account_type": "ResourceDirectory",
 *     }],
 *     aggregator_name=name,
 *     description=name,
 *     aggregator_type="CUSTOM")
 * default_aggregate_config_rule = alicloud.cfg.AggregateConfigRule("default",
 *     aggregate_config_rule_name="contains-tag",
 *     aggregator_id=default_aggregator.id,
 *     config_rule_trigger_types="ConfigurationItemChangeNotification",
 *     source_owner="ALIYUN",
 *     source_identifier="contains-tag",
 *     risk_level=1,
 *     resource_types_scopes=["ACS::ECS::Instance"],
 *     input_parameters={
 *         "key": "example",
 *         "value": "example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.ResourceManager.GetAccounts.Invoke(new()
 *     {
 *         Status = "CreateSuccess",
 *     });
 *     var defaultAggregator = new AliCloud.Cfg.Aggregator("default", new()
 *     {
 *         AggregatorAccounts = new[]
 *         {
 *             new AliCloud.Cfg.Inputs.AggregatorAggregatorAccountArgs
 *             {
 *                 AccountId = @default.Apply(@default => @default.Apply(getAccountsResult => getAccountsResult.Accounts[0]?.AccountId)),
 *                 AccountName = @default.Apply(@default => @default.Apply(getAccountsResult => getAccountsResult.Accounts[0]?.DisplayName)),
 *                 AccountType = "ResourceDirectory",
 *             },
 *         },
 *         AggregatorName = name,
 *         Description = name,
 *         AggregatorType = "CUSTOM",
 *     });
 *     var defaultAggregateConfigRule = new AliCloud.Cfg.AggregateConfigRule("default", new()
 *     {
 *         AggregateConfigRuleName = "contains-tag",
 *         AggregatorId = defaultAggregator.Id,
 *         ConfigRuleTriggerTypes = "ConfigurationItemChangeNotification",
 *         SourceOwner = "ALIYUN",
 *         SourceIdentifier = "contains-tag",
 *         RiskLevel = 1,
 *         ResourceTypesScopes = new[]
 *         {
 *             "ACS::ECS::Instance",
 *         },
 *         InputParameters =
 *         {
 *             { "key", "example" },
 *             { "value", "example" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cfg"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := resourcemanager.GetAccounts(ctx, &resourcemanager.GetAccountsArgs{
 * 			Status: pulumi.StringRef("CreateSuccess"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultAggregator, err := cfg.NewAggregator(ctx, "default", &cfg.AggregatorArgs{
 * 			AggregatorAccounts: cfg.AggregatorAggregatorAccountArray{
 * 				&cfg.AggregatorAggregatorAccountArgs{
 * 					AccountId:   pulumi.String(_default.Accounts[0].AccountId),
 * 					AccountName: pulumi.String(_default.Accounts[0].DisplayName),
 * 					AccountType: pulumi.String("ResourceDirectory"),
 * 				},
 * 			},
 * 			AggregatorName: pulumi.String(name),
 * 			Description:    pulumi.String(name),
 * 			AggregatorType: pulumi.String("CUSTOM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cfg.NewAggregateConfigRule(ctx, "default", &cfg.AggregateConfigRuleArgs{
 * 			AggregateConfigRuleName: pulumi.String("contains-tag"),
 * 			AggregatorId:            defaultAggregator.ID(),
 * 			ConfigRuleTriggerTypes:  pulumi.String("ConfigurationItemChangeNotification"),
 * 			SourceOwner:             pulumi.String("ALIYUN"),
 * 			SourceIdentifier:        pulumi.String("contains-tag"),
 * 			RiskLevel:               pulumi.Int(1),
 * 			ResourceTypesScopes: pulumi.StringArray{
 * 				pulumi.String("ACS::ECS::Instance"),
 * 			},
 * 			InputParameters: pulumi.StringMap{
 * 				"key":   pulumi.String("example"),
 * 				"value": pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetAccountsArgs;
 * import com.pulumi.alicloud.cfg.Aggregator;
 * import com.pulumi.alicloud.cfg.AggregatorArgs;
 * import com.pulumi.alicloud.cfg.inputs.AggregatorAggregatorAccountArgs;
 * import com.pulumi.alicloud.cfg.AggregateConfigRule;
 * import com.pulumi.alicloud.cfg.AggregateConfigRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = ResourcemanagerFunctions.getAccounts(GetAccountsArgs.builder()
 *             .status("CreateSuccess")
 *             .build());
 *         var defaultAggregator = new Aggregator("defaultAggregator", AggregatorArgs.builder()
 *             .aggregatorAccounts(AggregatorAggregatorAccountArgs.builder()
 *                 .accountId(default_.accounts()[0].accountId())
 *                 .accountName(default_.accounts()[0].displayName())
 *                 .accountType("ResourceDirectory")
 *                 .build())
 *             .aggregatorName(name)
 *             .description(name)
 *             .aggregatorType("CUSTOM")
 *             .build());
 *         var defaultAggregateConfigRule = new AggregateConfigRule("defaultAggregateConfigRule", AggregateConfigRuleArgs.builder()
 *             .aggregateConfigRuleName("contains-tag")
 *             .aggregatorId(defaultAggregator.id())
 *             .configRuleTriggerTypes("ConfigurationItemChangeNotification")
 *             .sourceOwner("ALIYUN")
 *             .sourceIdentifier("contains-tag")
 *             .riskLevel(1)
 *             .resourceTypesScopes("ACS::ECS::Instance")
 *             .inputParameters(Map.ofEntries(
 *                 Map.entry("key", "example"),
 *                 Map.entry("value", "example")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultAggregator:
 *     type: alicloud:cfg:Aggregator
 *     name: default
 *     properties:
 *       aggregatorAccounts:
 *         - accountId: ${default.accounts[0].accountId}
 *           accountName: ${default.accounts[0].displayName}
 *           accountType: ResourceDirectory
 *       aggregatorName: ${name}
 *       description: ${name}
 *       aggregatorType: CUSTOM
 *   defaultAggregateConfigRule:
 *     type: alicloud:cfg:AggregateConfigRule
 *     name: default
 *     properties:
 *       aggregateConfigRuleName: contains-tag
 *       aggregatorId: ${defaultAggregator.id}
 *       configRuleTriggerTypes: ConfigurationItemChangeNotification
 *       sourceOwner: ALIYUN
 *       sourceIdentifier: contains-tag
 *       riskLevel: 1
 *       resourceTypesScopes:
 *         - ACS::ECS::Instance
 *       inputParameters:
 *         key: example
 *         value: example
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getAccounts
 *       Arguments:
 *         status: CreateSuccess
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Config Aggregate Config Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cfg/aggregateConfigRule:AggregateConfigRule example "<aggregator_id>:<config_rule_id>"
 * ```
 * @property aggregateConfigRuleName The name of the rule.
 * @property aggregatorId The Aggregator Id.
 * @property configRuleTriggerTypes The trigger type of the rule. Valid values: `ConfigurationItemChangeNotification`: The rule is triggered upon configuration changes. `ScheduledNotification`: The rule is triggered as scheduled.
 * @property description The description of the rule.
 * @property excludeResourceIdsScope The rule monitors excluded resource IDs, multiple of which are separated by commas, only applies to rules created based on managed rules, , custom rule this field is empty.
 * @property inputParameters The settings map of the input parameters for the rule.
 * @property maximumExecutionFrequency The frequency of the compliance evaluations. Valid values:  `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, `TwentyFour_Hours`. System default value is `TwentyFour_Hours` and valid when the `config_rule_trigger_types` is `ScheduledNotification`.
 * @property regionIdsScope The rule monitors region IDs, separated by commas, only applies to rules created based on managed rules.
 * @property resourceGroupIdsScope The rule monitors resource group IDs, separated by commas, only applies to rules created based on managed rules.
 * @property resourceTypesScopes Resource types to be evaluated. [Alibaba Cloud services that support Cloud Config&#46;](https://www.alibabacloud.com/help/en/doc-detail/127411.htm)
 * @property riskLevel The risk level of the resources that are not compliant with the rule. Valid values:  `1`: critical `2`: warning `3`: info.
 * @property sourceIdentifier The identifier of the rule. For a managed rule, the value is the identifier of the managed rule. For a custom rule, the value is the ARN of the custom rule. Using managed rules, refer to [List of Managed rules&#46;](https://www.alibabacloud.com/help/en/doc-detail/127404.htm)
 * @property sourceOwner Specifies whether you or Alibaba Cloud owns and manages the rule. Valid values: `CUSTOM_FC`: The rule is a custom rule and you own the rule. `ALIYUN`: The rule is a managed rule and Alibaba Cloud owns the rule.
 * @property status The rule status. The valid values: `ACTIVE`, `INACTIVE`.
 * @property tagKeyScope The rule monitors the tag key, only applies to rules created based on managed rules.
 * @property tagValueScope The rule monitors the tag value, use with the `tag_key_scope` options. only applies to rules created based on managed rules.
 */
public data class AggregateConfigRuleArgs(
    public val aggregateConfigRuleName: Output<String>? = null,
    public val aggregatorId: Output<String>? = null,
    public val configRuleTriggerTypes: Output<String>? = null,
    public val description: Output<String>? = null,
    public val excludeResourceIdsScope: Output<String>? = null,
    public val inputParameters: Output<Map<String, String>>? = null,
    public val maximumExecutionFrequency: Output<String>? = null,
    public val regionIdsScope: Output<String>? = null,
    public val resourceGroupIdsScope: Output<String>? = null,
    public val resourceTypesScopes: Output<List<String>>? = null,
    public val riskLevel: Output<Int>? = null,
    public val sourceIdentifier: Output<String>? = null,
    public val sourceOwner: Output<String>? = null,
    public val status: Output<String>? = null,
    public val tagKeyScope: Output<String>? = null,
    public val tagValueScope: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cfg.AggregateConfigRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.cfg.AggregateConfigRuleArgs =
        com.pulumi.alicloud.cfg.AggregateConfigRuleArgs.builder()
            .aggregateConfigRuleName(aggregateConfigRuleName?.applyValue({ args0 -> args0 }))
            .aggregatorId(aggregatorId?.applyValue({ args0 -> args0 }))
            .configRuleTriggerTypes(configRuleTriggerTypes?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .excludeResourceIdsScope(excludeResourceIdsScope?.applyValue({ args0 -> args0 }))
            .inputParameters(
                inputParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .maximumExecutionFrequency(maximumExecutionFrequency?.applyValue({ args0 -> args0 }))
            .regionIdsScope(regionIdsScope?.applyValue({ args0 -> args0 }))
            .resourceGroupIdsScope(resourceGroupIdsScope?.applyValue({ args0 -> args0 }))
            .resourceTypesScopes(resourceTypesScopes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .riskLevel(riskLevel?.applyValue({ args0 -> args0 }))
            .sourceIdentifier(sourceIdentifier?.applyValue({ args0 -> args0 }))
            .sourceOwner(sourceOwner?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .tagKeyScope(tagKeyScope?.applyValue({ args0 -> args0 }))
            .tagValueScope(tagValueScope?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AggregateConfigRuleArgs].
 */
@PulumiTagMarker
public class AggregateConfigRuleArgsBuilder internal constructor() {
    private var aggregateConfigRuleName: Output<String>? = null

    private var aggregatorId: Output<String>? = null

    private var configRuleTriggerTypes: Output<String>? = null

    private var description: Output<String>? = null

    private var excludeResourceIdsScope: Output<String>? = null

    private var inputParameters: Output<Map<String, String>>? = null

    private var maximumExecutionFrequency: Output<String>? = null

    private var regionIdsScope: Output<String>? = null

    private var resourceGroupIdsScope: Output<String>? = null

    private var resourceTypesScopes: Output<List<String>>? = null

    private var riskLevel: Output<Int>? = null

    private var sourceIdentifier: Output<String>? = null

    private var sourceOwner: Output<String>? = null

    private var status: Output<String>? = null

    private var tagKeyScope: Output<String>? = null

    private var tagValueScope: Output<String>? = null

    /**
     * @param value The name of the rule.
     */
    @JvmName("xirxurmposeboytx")
    public suspend fun aggregateConfigRuleName(`value`: Output<String>) {
        this.aggregateConfigRuleName = value
    }

    /**
     * @param value The Aggregator Id.
     */
    @JvmName("vfolsvbpuukjmtcx")
    public suspend fun aggregatorId(`value`: Output<String>) {
        this.aggregatorId = value
    }

    /**
     * @param value The trigger type of the rule. Valid values: `ConfigurationItemChangeNotification`: The rule is triggered upon configuration changes. `ScheduledNotification`: The rule is triggered as scheduled.
     */
    @JvmName("mihpqittbjfbrxan")
    public suspend fun configRuleTriggerTypes(`value`: Output<String>) {
        this.configRuleTriggerTypes = value
    }

    /**
     * @param value The description of the rule.
     */
    @JvmName("mrvxnpfowmflkrud")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The rule monitors excluded resource IDs, multiple of which are separated by commas, only applies to rules created based on managed rules, , custom rule this field is empty.
     */
    @JvmName("jkmoiljhbeefrvnt")
    public suspend fun excludeResourceIdsScope(`value`: Output<String>) {
        this.excludeResourceIdsScope = value
    }

    /**
     * @param value The settings map of the input parameters for the rule.
     */
    @JvmName("ylgkqvvddvvafdqg")
    public suspend fun inputParameters(`value`: Output<Map<String, String>>) {
        this.inputParameters = value
    }

    /**
     * @param value The frequency of the compliance evaluations. Valid values:  `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, `TwentyFour_Hours`. System default value is `TwentyFour_Hours` and valid when the `config_rule_trigger_types` is `ScheduledNotification`.
     */
    @JvmName("akuppqqdovecrywv")
    public suspend fun maximumExecutionFrequency(`value`: Output<String>) {
        this.maximumExecutionFrequency = value
    }

    /**
     * @param value The rule monitors region IDs, separated by commas, only applies to rules created based on managed rules.
     */
    @JvmName("ankqtbmbtqdllqnh")
    public suspend fun regionIdsScope(`value`: Output<String>) {
        this.regionIdsScope = value
    }

    /**
     * @param value The rule monitors resource group IDs, separated by commas, only applies to rules created based on managed rules.
     */
    @JvmName("delfklatsdjndtmu")
    public suspend fun resourceGroupIdsScope(`value`: Output<String>) {
        this.resourceGroupIdsScope = value
    }

    /**
     * @param value Resource types to be evaluated. [Alibaba Cloud services that support Cloud Config&#46;](https://www.alibabacloud.com/help/en/doc-detail/127411.htm)
     */
    @JvmName("fowfhacdyubbwbwc")
    public suspend fun resourceTypesScopes(`value`: Output<List<String>>) {
        this.resourceTypesScopes = value
    }

    @JvmName("rygschcfodlydpjf")
    public suspend fun resourceTypesScopes(vararg values: Output<String>) {
        this.resourceTypesScopes = Output.all(values.asList())
    }

    /**
     * @param values Resource types to be evaluated. [Alibaba Cloud services that support Cloud Config&#46;](https://www.alibabacloud.com/help/en/doc-detail/127411.htm)
     */
    @JvmName("goumwbawaxkunqcu")
    public suspend fun resourceTypesScopes(values: List<Output<String>>) {
        this.resourceTypesScopes = Output.all(values)
    }

    /**
     * @param value The risk level of the resources that are not compliant with the rule. Valid values:  `1`: critical `2`: warning `3`: info.
     */
    @JvmName("pcqvuefnoukuaprh")
    public suspend fun riskLevel(`value`: Output<Int>) {
        this.riskLevel = value
    }

    /**
     * @param value The identifier of the rule. For a managed rule, the value is the identifier of the managed rule. For a custom rule, the value is the ARN of the custom rule. Using managed rules, refer to [List of Managed rules&#46;](https://www.alibabacloud.com/help/en/doc-detail/127404.htm)
     */
    @JvmName("jpqakqsgyjjoclyx")
    public suspend fun sourceIdentifier(`value`: Output<String>) {
        this.sourceIdentifier = value
    }

    /**
     * @param value Specifies whether you or Alibaba Cloud owns and manages the rule. Valid values: `CUSTOM_FC`: The rule is a custom rule and you own the rule. `ALIYUN`: The rule is a managed rule and Alibaba Cloud owns the rule.
     */
    @JvmName("bgfqmfdjikrhxlwv")
    public suspend fun sourceOwner(`value`: Output<String>) {
        this.sourceOwner = value
    }

    /**
     * @param value The rule status. The valid values: `ACTIVE`, `INACTIVE`.
     */
    @JvmName("emhucstuwhaljail")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The rule monitors the tag key, only applies to rules created based on managed rules.
     */
    @JvmName("jmnwxavalpukpxqe")
    public suspend fun tagKeyScope(`value`: Output<String>) {
        this.tagKeyScope = value
    }

    /**
     * @param value The rule monitors the tag value, use with the `tag_key_scope` options. only applies to rules created based on managed rules.
     */
    @JvmName("koaenfqgdcyhwigy")
    public suspend fun tagValueScope(`value`: Output<String>) {
        this.tagValueScope = value
    }

    /**
     * @param value The name of the rule.
     */
    @JvmName("uvovvyguwlvoqnur")
    public suspend fun aggregateConfigRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aggregateConfigRuleName = mapped
    }

    /**
     * @param value The Aggregator Id.
     */
    @JvmName("cytyoiwjtwvmqrwt")
    public suspend fun aggregatorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aggregatorId = mapped
    }

    /**
     * @param value The trigger type of the rule. Valid values: `ConfigurationItemChangeNotification`: The rule is triggered upon configuration changes. `ScheduledNotification`: The rule is triggered as scheduled.
     */
    @JvmName("opspvxpjpkpwxnod")
    public suspend fun configRuleTriggerTypes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configRuleTriggerTypes = mapped
    }

    /**
     * @param value The description of the rule.
     */
    @JvmName("wpqtdgqtfigeujgp")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The rule monitors excluded resource IDs, multiple of which are separated by commas, only applies to rules created based on managed rules, , custom rule this field is empty.
     */
    @JvmName("klgjbdopiugdardh")
    public suspend fun excludeResourceIdsScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludeResourceIdsScope = mapped
    }

    /**
     * @param value The settings map of the input parameters for the rule.
     */
    @JvmName("mjrfahksqrkmqfim")
    public suspend fun inputParameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputParameters = mapped
    }

    /**
     * @param values The settings map of the input parameters for the rule.
     */
    @JvmName("ckikywdribhtwjoj")
    public fun inputParameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputParameters = mapped
    }

    /**
     * @param value The frequency of the compliance evaluations. Valid values:  `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, `TwentyFour_Hours`. System default value is `TwentyFour_Hours` and valid when the `config_rule_trigger_types` is `ScheduledNotification`.
     */
    @JvmName("isiivpkjwqpvgkoj")
    public suspend fun maximumExecutionFrequency(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumExecutionFrequency = mapped
    }

    /**
     * @param value The rule monitors region IDs, separated by commas, only applies to rules created based on managed rules.
     */
    @JvmName("fsirhtgifaexqroh")
    public suspend fun regionIdsScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionIdsScope = mapped
    }

    /**
     * @param value The rule monitors resource group IDs, separated by commas, only applies to rules created based on managed rules.
     */
    @JvmName("tcvvtldnqltcmson")
    public suspend fun resourceGroupIdsScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupIdsScope = mapped
    }

    /**
     * @param value Resource types to be evaluated. [Alibaba Cloud services that support Cloud Config&#46;](https://www.alibabacloud.com/help/en/doc-detail/127411.htm)
     */
    @JvmName("thuhtcdqdbvluvbo")
    public suspend fun resourceTypesScopes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTypesScopes = mapped
    }

    /**
     * @param values Resource types to be evaluated. [Alibaba Cloud services that support Cloud Config&#46;](https://www.alibabacloud.com/help/en/doc-detail/127411.htm)
     */
    @JvmName("odmkkjrnbvdhfved")
    public suspend fun resourceTypesScopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTypesScopes = mapped
    }

    /**
     * @param value The risk level of the resources that are not compliant with the rule. Valid values:  `1`: critical `2`: warning `3`: info.
     */
    @JvmName("kppsejdlmuarfeav")
    public suspend fun riskLevel(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.riskLevel = mapped
    }

    /**
     * @param value The identifier of the rule. For a managed rule, the value is the identifier of the managed rule. For a custom rule, the value is the ARN of the custom rule. Using managed rules, refer to [List of Managed rules&#46;](https://www.alibabacloud.com/help/en/doc-detail/127404.htm)
     */
    @JvmName("tipnejjloruxqdsh")
    public suspend fun sourceIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIdentifier = mapped
    }

    /**
     * @param value Specifies whether you or Alibaba Cloud owns and manages the rule. Valid values: `CUSTOM_FC`: The rule is a custom rule and you own the rule. `ALIYUN`: The rule is a managed rule and Alibaba Cloud owns the rule.
     */
    @JvmName("rgnuhingbayitlph")
    public suspend fun sourceOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceOwner = mapped
    }

    /**
     * @param value The rule status. The valid values: `ACTIVE`, `INACTIVE`.
     */
    @JvmName("esjbarkkqunoxbuv")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The rule monitors the tag key, only applies to rules created based on managed rules.
     */
    @JvmName("ityohlivjdyrlnpa")
    public suspend fun tagKeyScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagKeyScope = mapped
    }

    /**
     * @param value The rule monitors the tag value, use with the `tag_key_scope` options. only applies to rules created based on managed rules.
     */
    @JvmName("ynaktnognjkyssmh")
    public suspend fun tagValueScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagValueScope = mapped
    }

    internal fun build(): AggregateConfigRuleArgs = AggregateConfigRuleArgs(
        aggregateConfigRuleName = aggregateConfigRuleName,
        aggregatorId = aggregatorId,
        configRuleTriggerTypes = configRuleTriggerTypes,
        description = description,
        excludeResourceIdsScope = excludeResourceIdsScope,
        inputParameters = inputParameters,
        maximumExecutionFrequency = maximumExecutionFrequency,
        regionIdsScope = regionIdsScope,
        resourceGroupIdsScope = resourceGroupIdsScope,
        resourceTypesScopes = resourceTypesScopes,
        riskLevel = riskLevel,
        sourceIdentifier = sourceIdentifier,
        sourceOwner = sourceOwner,
        status = status,
        tagKeyScope = tagKeyScope,
        tagValueScope = tagValueScope,
    )
}
