@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AggregateDelivery].
 */
@PulumiTagMarker
public class AggregateDeliveryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AggregateDeliveryArgs = AggregateDeliveryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AggregateDeliveryArgsBuilder.() -> Unit) {
        val builder = AggregateDeliveryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AggregateDelivery {
        val builtJavaResource = com.pulumi.alicloud.cfg.AggregateDelivery(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AggregateDelivery(builtJavaResource)
    }
}

/**
 * Provides a Config Aggregate Delivery resource.
 * Delivery channel of aggregator.
 * For information about Config Aggregate Delivery and how to use it, see [What is Aggregate Delivery](https://www.alibabacloud.com/help/en/cloud-config/latest/api-config-2020-09-07-createaggregateconfigdeliverychannel).
 * > **NOTE:** Available since v1.172.0.
 * ## Import
 * Config Aggregate Delivery can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cfg/aggregateDelivery:AggregateDelivery example <aggregator_id>:<delivery_channel_id>
 * ```
 */
public class AggregateDelivery internal constructor(
    override val javaResource: com.pulumi.alicloud.cfg.AggregateDelivery,
) : KotlinCustomResource(javaResource, AggregateDeliveryMapper) {
    /**
     * Aggregator ID.
     */
    public val aggregatorId: Output<String>
        get() = javaResource.aggregatorId().applyValue({ args0 -> args0 })

    /**
     * Indicates whether the specified destination receives resource change logs. If the value of this parameter is true, Cloud Config delivers the resource change logs to OSS, Log Service, or MNS when the configurations of the resources change. Valid values:
     * - true: The specified destination receives resource change logs.
     * - false: The specified destination does not receive resource change logs.
     */
    public val configurationItemChangeNotification: Output<Boolean>?
        get() = javaResource.configurationItemChangeNotification().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * Indicates whether the specified destination receives scheduled resource snapshots. Cloud Config delivers scheduled resource snapshots at 04:00Z and 16:00Z to OSS, MNS, or Log Service every day. The time is displayed in UTC. Valid values:
     * - true: The specified destination receives scheduled resource snapshots.
     * - false: The specified destination does not receive scheduled resource snapshots.
     */
    public val configurationSnapshot: Output<Boolean>?
        get() = javaResource.configurationSnapshot().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The rule that is attached to the delivery channel.
     * This parameter is available when you deliver data of all types to MNS or deliver snapshots to Log Service.
     * If you specify the risk level or resource types for subscription events, this is as follows:
     * The lowest risk level of the events to which you want to subscribe is in the following format: {"filterType":"RuleRiskLevel","value":"1","multiple":false}, The value field indicates the risk level of the events to which you want to subscribe. Valid values: 1, 2, and 3. The value 1 indicates the high risk level, the value 2 indicates the medium risk level, and the value 3 indicates the low risk level.
     * The setting of the resource types of the events to which you want to subscribe is in the following format: {"filterType":"ResourceType","values":["ACS::ACK::Cluster","ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage"],"multiple":true}, The values field indicates the resource types of the events to which you want to subscribe. The value of the field is a JSON array.
     * Examples:[{"filterType":"ResourceType","values":["ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage","ACS::CDN::Domain","ACS::CEN::CenBandwidthPackage","ACS::CEN::CenInstance","ACS::CEN::Flowlog","ACS::DdosCoo::Instance"],"multiple":true}].
     */
    public val deliveryChannelCondition: Output<String>?
        get() = javaResource.deliveryChannelCondition().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the delivery method. This parameter is required when you modify a delivery method.
     */
    public val deliveryChannelId: Output<String>
        get() = javaResource.deliveryChannelId().applyValue({ args0 -> args0 })

    /**
     * The name of the delivery channel.
     */
    public val deliveryChannelName: Output<String>?
        get() = javaResource.deliveryChannelName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the delivery destination.
     * - If the value of the DeliveryChannelType parameter is OSS, the value of this parameter is the ARN of the destination OSS bucket.
     * - If the value of the DeliveryChannelType parameter is MNS, the value of this parameter is the ARN of the destination MNS topic.
     * - If the value of the DeliveryChannelType parameter is SLS, the value of this parameter is the ARN of the destination Log Service Logstore.
     */
    public val deliveryChannelTargetArn: Output<String>
        get() = javaResource.deliveryChannelTargetArn().applyValue({ args0 -> args0 })

    /**
     * The type of the delivery channel. Valid values:
     * - OSS: Object Storage Service (OSS)
     * - MNS: Message Service (MNS)
     * - SLS: Log Service
     */
    public val deliveryChannelType: Output<String>
        get() = javaResource.deliveryChannelType().applyValue({ args0 -> args0 })

    /**
     * The description of the delivery method.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether the specified destination receives resource non-compliance events. If the value of this parameter is true, Cloud Config delivers resource non-compliance events to Log Service or MNS when resources are evaluated as non-compliant. Valid values:
     * - true: The specified destination receives resource non-compliance events.
     * - false: The specified destination does not receive resource non-compliance events.
     */
    public val nonCompliantNotification: Output<Boolean>?
        get() = javaResource.nonCompliantNotification().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the OSS bucket to which the delivered data is transferred when the size of the data exceeds the specified upper limit of the delivery channel.
     */
    public val oversizedDataOssTargetArn: Output<String>?
        get() = javaResource.oversizedDataOssTargetArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the delivery method. Valid values:
     * - 0: The delivery method is disabled.
     * - 1: The delivery destination is enabled. This is the default value.
     */
    public val status: Output<Int>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object AggregateDeliveryMapper : ResourceMapper<AggregateDelivery> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cfg.AggregateDelivery::class == javaResource::class

    override fun map(javaResource: Resource): AggregateDelivery = AggregateDelivery(
        javaResource as
            com.pulumi.alicloud.cfg.AggregateDelivery,
    )
}

/**
 * @see [AggregateDelivery].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AggregateDelivery].
 */
public suspend fun aggregateDelivery(
    name: String,
    block: suspend AggregateDeliveryResourceBuilder.() -> Unit,
): AggregateDelivery {
    val builder = AggregateDeliveryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AggregateDelivery].
 * @param name The _unique_ name of the resulting resource.
 */
public fun aggregateDelivery(name: String): AggregateDelivery {
    val builder = AggregateDeliveryResourceBuilder()
    builder.name(name)
    return builder.build()
}
