@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin

import com.pulumi.alicloud.cfg.AggregateDeliveryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Config Aggregate Delivery resource.
 * Delivery channel of aggregator.
 * For information about Config Aggregate Delivery and how to use it, see [What is Aggregate Delivery](https://www.alibabacloud.com/help/en/cloud-config/latest/api-config-2020-09-07-createaggregateconfigdeliverychannel).
 * > **NOTE:** Available since v1.172.0.
 * ## Import
 * Config Aggregate Delivery can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cfg/aggregateDelivery:AggregateDelivery example <aggregator_id>:<delivery_channel_id>
 * ```
 * @property aggregatorId Aggregator ID.
 * @property configurationItemChangeNotification Indicates whether the specified destination receives resource change logs. If the value of this parameter is true, Cloud Config delivers the resource change logs to OSS, Log Service, or MNS when the configurations of the resources change. Valid values:
 * - true: The specified destination receives resource change logs.
 * - false: The specified destination does not receive resource change logs.
 * @property configurationSnapshot Indicates whether the specified destination receives scheduled resource snapshots. Cloud Config delivers scheduled resource snapshots at 04:00Z and 16:00Z to OSS, MNS, or Log Service every day. The time is displayed in UTC. Valid values:
 * - true: The specified destination receives scheduled resource snapshots.
 * - false: The specified destination does not receive scheduled resource snapshots.
 * @property deliveryChannelCondition The rule that is attached to the delivery channel.
 * This parameter is available when you deliver data of all types to MNS or deliver snapshots to Log Service.
 * If you specify the risk level or resource types for subscription events, this is as follows:
 * The lowest risk level of the events to which you want to subscribe is in the following format: {"filterType":"RuleRiskLevel","value":"1","multiple":false}, The value field indicates the risk level of the events to which you want to subscribe. Valid values: 1, 2, and 3. The value 1 indicates the high risk level, the value 2 indicates the medium risk level, and the value 3 indicates the low risk level.
 * The setting of the resource types of the events to which you want to subscribe is in the following format: {"filterType":"ResourceType","values":["ACS::ACK::Cluster","ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage"],"multiple":true}, The values field indicates the resource types of the events to which you want to subscribe. The value of the field is a JSON array.
 * Examples:[{"filterType":"ResourceType","values":["ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage","ACS::CDN::Domain","ACS::CEN::CenBandwidthPackage","ACS::CEN::CenInstance","ACS::CEN::Flowlog","ACS::DdosCoo::Instance"],"multiple":true}].
 * @property deliveryChannelName The name of the delivery channel.
 * @property deliveryChannelTargetArn The ARN of the delivery destination.
 * - If the value of the DeliveryChannelType parameter is OSS, the value of this parameter is the ARN of the destination OSS bucket.
 * - If the value of the DeliveryChannelType parameter is MNS, the value of this parameter is the ARN of the destination MNS topic.
 * - If the value of the DeliveryChannelType parameter is SLS, the value of this parameter is the ARN of the destination Log Service Logstore.
 * @property deliveryChannelType The type of the delivery channel. Valid values:
 * - OSS: Object Storage Service (OSS)
 * - MNS: Message Service (MNS)
 * - SLS: Log Service
 * @property description The description of the delivery method.
 * @property nonCompliantNotification Indicates whether the specified destination receives resource non-compliance events. If the value of this parameter is true, Cloud Config delivers resource non-compliance events to Log Service or MNS when resources are evaluated as non-compliant. Valid values:
 * - true: The specified destination receives resource non-compliance events.
 * - false: The specified destination does not receive resource non-compliance events.
 * @property oversizedDataOssTargetArn The ARN of the OSS bucket to which the delivered data is transferred when the size of the data exceeds the specified upper limit of the delivery channel.
 * @property status The status of the delivery method. Valid values:
 * - 0: The delivery method is disabled.
 * - 1: The delivery destination is enabled. This is the default value.
 */
public data class AggregateDeliveryArgs(
    public val aggregatorId: Output<String>? = null,
    public val configurationItemChangeNotification: Output<Boolean>? = null,
    public val configurationSnapshot: Output<Boolean>? = null,
    public val deliveryChannelCondition: Output<String>? = null,
    public val deliveryChannelName: Output<String>? = null,
    public val deliveryChannelTargetArn: Output<String>? = null,
    public val deliveryChannelType: Output<String>? = null,
    public val description: Output<String>? = null,
    public val nonCompliantNotification: Output<Boolean>? = null,
    public val oversizedDataOssTargetArn: Output<String>? = null,
    public val status: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cfg.AggregateDeliveryArgs> {
    override fun toJava(): com.pulumi.alicloud.cfg.AggregateDeliveryArgs =
        com.pulumi.alicloud.cfg.AggregateDeliveryArgs.builder()
            .aggregatorId(aggregatorId?.applyValue({ args0 -> args0 }))
            .configurationItemChangeNotification(
                configurationItemChangeNotification?.applyValue({ args0 ->
                    args0
                }),
            )
            .configurationSnapshot(configurationSnapshot?.applyValue({ args0 -> args0 }))
            .deliveryChannelCondition(deliveryChannelCondition?.applyValue({ args0 -> args0 }))
            .deliveryChannelName(deliveryChannelName?.applyValue({ args0 -> args0 }))
            .deliveryChannelTargetArn(deliveryChannelTargetArn?.applyValue({ args0 -> args0 }))
            .deliveryChannelType(deliveryChannelType?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .nonCompliantNotification(nonCompliantNotification?.applyValue({ args0 -> args0 }))
            .oversizedDataOssTargetArn(oversizedDataOssTargetArn?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AggregateDeliveryArgs].
 */
@PulumiTagMarker
public class AggregateDeliveryArgsBuilder internal constructor() {
    private var aggregatorId: Output<String>? = null

    private var configurationItemChangeNotification: Output<Boolean>? = null

    private var configurationSnapshot: Output<Boolean>? = null

    private var deliveryChannelCondition: Output<String>? = null

    private var deliveryChannelName: Output<String>? = null

    private var deliveryChannelTargetArn: Output<String>? = null

    private var deliveryChannelType: Output<String>? = null

    private var description: Output<String>? = null

    private var nonCompliantNotification: Output<Boolean>? = null

    private var oversizedDataOssTargetArn: Output<String>? = null

    private var status: Output<Int>? = null

    /**
     * @param value Aggregator ID.
     */
    @JvmName("pturilcgmmkhfdyo")
    public suspend fun aggregatorId(`value`: Output<String>) {
        this.aggregatorId = value
    }

    /**
     * @param value Indicates whether the specified destination receives resource change logs. If the value of this parameter is true, Cloud Config delivers the resource change logs to OSS, Log Service, or MNS when the configurations of the resources change. Valid values:
     * - true: The specified destination receives resource change logs.
     * - false: The specified destination does not receive resource change logs.
     */
    @JvmName("pspnjbfwqcvquluq")
    public suspend fun configurationItemChangeNotification(`value`: Output<Boolean>) {
        this.configurationItemChangeNotification = value
    }

    /**
     * @param value Indicates whether the specified destination receives scheduled resource snapshots. Cloud Config delivers scheduled resource snapshots at 04:00Z and 16:00Z to OSS, MNS, or Log Service every day. The time is displayed in UTC. Valid values:
     * - true: The specified destination receives scheduled resource snapshots.
     * - false: The specified destination does not receive scheduled resource snapshots.
     */
    @JvmName("eufgwwtngurlafev")
    public suspend fun configurationSnapshot(`value`: Output<Boolean>) {
        this.configurationSnapshot = value
    }

    /**
     * @param value The rule that is attached to the delivery channel.
     * This parameter is available when you deliver data of all types to MNS or deliver snapshots to Log Service.
     * If you specify the risk level or resource types for subscription events, this is as follows:
     * The lowest risk level of the events to which you want to subscribe is in the following format: {"filterType":"RuleRiskLevel","value":"1","multiple":false}, The value field indicates the risk level of the events to which you want to subscribe. Valid values: 1, 2, and 3. The value 1 indicates the high risk level, the value 2 indicates the medium risk level, and the value 3 indicates the low risk level.
     * The setting of the resource types of the events to which you want to subscribe is in the following format: {"filterType":"ResourceType","values":["ACS::ACK::Cluster","ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage"],"multiple":true}, The values field indicates the resource types of the events to which you want to subscribe. The value of the field is a JSON array.
     * Examples:[{"filterType":"ResourceType","values":["ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage","ACS::CDN::Domain","ACS::CEN::CenBandwidthPackage","ACS::CEN::CenInstance","ACS::CEN::Flowlog","ACS::DdosCoo::Instance"],"multiple":true}].
     */
    @JvmName("ruuixlewaytjdkds")
    public suspend fun deliveryChannelCondition(`value`: Output<String>) {
        this.deliveryChannelCondition = value
    }

    /**
     * @param value The name of the delivery channel.
     */
    @JvmName("jgfvlwpkssvdavqk")
    public suspend fun deliveryChannelName(`value`: Output<String>) {
        this.deliveryChannelName = value
    }

    /**
     * @param value The ARN of the delivery destination.
     * - If the value of the DeliveryChannelType parameter is OSS, the value of this parameter is the ARN of the destination OSS bucket.
     * - If the value of the DeliveryChannelType parameter is MNS, the value of this parameter is the ARN of the destination MNS topic.
     * - If the value of the DeliveryChannelType parameter is SLS, the value of this parameter is the ARN of the destination Log Service Logstore.
     */
    @JvmName("qibppdetxsblyuuc")
    public suspend fun deliveryChannelTargetArn(`value`: Output<String>) {
        this.deliveryChannelTargetArn = value
    }

    /**
     * @param value The type of the delivery channel. Valid values:
     * - OSS: Object Storage Service (OSS)
     * - MNS: Message Service (MNS)
     * - SLS: Log Service
     */
    @JvmName("koqhumcrfsphyqdr")
    public suspend fun deliveryChannelType(`value`: Output<String>) {
        this.deliveryChannelType = value
    }

    /**
     * @param value The description of the delivery method.
     */
    @JvmName("dcvhismxcojoohhu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Indicates whether the specified destination receives resource non-compliance events. If the value of this parameter is true, Cloud Config delivers resource non-compliance events to Log Service or MNS when resources are evaluated as non-compliant. Valid values:
     * - true: The specified destination receives resource non-compliance events.
     * - false: The specified destination does not receive resource non-compliance events.
     */
    @JvmName("inpuksdbbeforgnp")
    public suspend fun nonCompliantNotification(`value`: Output<Boolean>) {
        this.nonCompliantNotification = value
    }

    /**
     * @param value The ARN of the OSS bucket to which the delivered data is transferred when the size of the data exceeds the specified upper limit of the delivery channel.
     */
    @JvmName("scfioiagcubcxglk")
    public suspend fun oversizedDataOssTargetArn(`value`: Output<String>) {
        this.oversizedDataOssTargetArn = value
    }

    /**
     * @param value The status of the delivery method. Valid values:
     * - 0: The delivery method is disabled.
     * - 1: The delivery destination is enabled. This is the default value.
     */
    @JvmName("ofcitrahsgnrhjho")
    public suspend fun status(`value`: Output<Int>) {
        this.status = value
    }

    /**
     * @param value Aggregator ID.
     */
    @JvmName("vrdyexhuhdooecgh")
    public suspend fun aggregatorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aggregatorId = mapped
    }

    /**
     * @param value Indicates whether the specified destination receives resource change logs. If the value of this parameter is true, Cloud Config delivers the resource change logs to OSS, Log Service, or MNS when the configurations of the resources change. Valid values:
     * - true: The specified destination receives resource change logs.
     * - false: The specified destination does not receive resource change logs.
     */
    @JvmName("ycdhjbjntjqdfdbh")
    public suspend fun configurationItemChangeNotification(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationItemChangeNotification = mapped
    }

    /**
     * @param value Indicates whether the specified destination receives scheduled resource snapshots. Cloud Config delivers scheduled resource snapshots at 04:00Z and 16:00Z to OSS, MNS, or Log Service every day. The time is displayed in UTC. Valid values:
     * - true: The specified destination receives scheduled resource snapshots.
     * - false: The specified destination does not receive scheduled resource snapshots.
     */
    @JvmName("lltfmtwcnaeqjamm")
    public suspend fun configurationSnapshot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationSnapshot = mapped
    }

    /**
     * @param value The rule that is attached to the delivery channel.
     * This parameter is available when you deliver data of all types to MNS or deliver snapshots to Log Service.
     * If you specify the risk level or resource types for subscription events, this is as follows:
     * The lowest risk level of the events to which you want to subscribe is in the following format: {"filterType":"RuleRiskLevel","value":"1","multiple":false}, The value field indicates the risk level of the events to which you want to subscribe. Valid values: 1, 2, and 3. The value 1 indicates the high risk level, the value 2 indicates the medium risk level, and the value 3 indicates the low risk level.
     * The setting of the resource types of the events to which you want to subscribe is in the following format: {"filterType":"ResourceType","values":["ACS::ACK::Cluster","ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage"],"multiple":true}, The values field indicates the resource types of the events to which you want to subscribe. The value of the field is a JSON array.
     * Examples:[{"filterType":"ResourceType","values":["ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage","ACS::CDN::Domain","ACS::CEN::CenBandwidthPackage","ACS::CEN::CenInstance","ACS::CEN::Flowlog","ACS::DdosCoo::Instance"],"multiple":true}].
     */
    @JvmName("gqyqvbqvljflkhxd")
    public suspend fun deliveryChannelCondition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryChannelCondition = mapped
    }

    /**
     * @param value The name of the delivery channel.
     */
    @JvmName("bjfpfsncodvswalu")
    public suspend fun deliveryChannelName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryChannelName = mapped
    }

    /**
     * @param value The ARN of the delivery destination.
     * - If the value of the DeliveryChannelType parameter is OSS, the value of this parameter is the ARN of the destination OSS bucket.
     * - If the value of the DeliveryChannelType parameter is MNS, the value of this parameter is the ARN of the destination MNS topic.
     * - If the value of the DeliveryChannelType parameter is SLS, the value of this parameter is the ARN of the destination Log Service Logstore.
     */
    @JvmName("kidxgeyupleqqbck")
    public suspend fun deliveryChannelTargetArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryChannelTargetArn = mapped
    }

    /**
     * @param value The type of the delivery channel. Valid values:
     * - OSS: Object Storage Service (OSS)
     * - MNS: Message Service (MNS)
     * - SLS: Log Service
     */
    @JvmName("mnqtlhvxwiraqkwm")
    public suspend fun deliveryChannelType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryChannelType = mapped
    }

    /**
     * @param value The description of the delivery method.
     */
    @JvmName("dinweltkmtmwxtgo")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Indicates whether the specified destination receives resource non-compliance events. If the value of this parameter is true, Cloud Config delivers resource non-compliance events to Log Service or MNS when resources are evaluated as non-compliant. Valid values:
     * - true: The specified destination receives resource non-compliance events.
     * - false: The specified destination does not receive resource non-compliance events.
     */
    @JvmName("nqbukxqetdyfsfrw")
    public suspend fun nonCompliantNotification(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nonCompliantNotification = mapped
    }

    /**
     * @param value The ARN of the OSS bucket to which the delivered data is transferred when the size of the data exceeds the specified upper limit of the delivery channel.
     */
    @JvmName("gybugnhqbntrwlip")
    public suspend fun oversizedDataOssTargetArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oversizedDataOssTargetArn = mapped
    }

    /**
     * @param value The status of the delivery method. Valid values:
     * - 0: The delivery method is disabled.
     * - 1: The delivery destination is enabled. This is the default value.
     */
    @JvmName("sapavwuidhelryjs")
    public suspend fun status(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): AggregateDeliveryArgs = AggregateDeliveryArgs(
        aggregatorId = aggregatorId,
        configurationItemChangeNotification = configurationItemChangeNotification,
        configurationSnapshot = configurationSnapshot,
        deliveryChannelCondition = deliveryChannelCondition,
        deliveryChannelName = deliveryChannelName,
        deliveryChannelTargetArn = deliveryChannelTargetArn,
        deliveryChannelType = deliveryChannelType,
        description = description,
        nonCompliantNotification = nonCompliantNotification,
        oversizedDataOssTargetArn = oversizedDataOssTargetArn,
        status = status,
    )
}
