@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin

import com.pulumi.alicloud.cfg.kotlin.outputs.AggregatorAggregatorAccount
import com.pulumi.alicloud.cfg.kotlin.outputs.AggregatorAggregatorAccount.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Aggregator].
 */
@PulumiTagMarker
public class AggregatorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AggregatorArgs = AggregatorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AggregatorArgsBuilder.() -> Unit) {
        val builder = AggregatorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Aggregator {
        val builtJavaResource = com.pulumi.alicloud.cfg.Aggregator(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Aggregator(builtJavaResource)
    }
}

/**
 * Provides a Cloud Config Aggregator resource.
 * For information about Cloud Config Aggregate Config Rule and how to use it, see [What is Aggregator](https://www.alibabacloud.com/help/en/cloud-config/latest/api-config-2020-09-07-createaggregator).
 * > **NOTE:** Available since v1.124.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const default = alicloud.resourcemanager.getAccounts({
 *     status: "CreateSuccess",
 * });
 * const defaultAggregator = new alicloud.cfg.Aggregator("default", {
 *     aggregatorAccounts: [{
 *         accountId: _default.then(_default => _default.accounts?.[0]?.accountId),
 *         accountName: _default.then(_default => _default.accounts?.[0]?.displayName),
 *         accountType: "ResourceDirectory",
 *     }],
 *     aggregatorName: name,
 *     description: name,
 *     aggregatorType: "CUSTOM",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = alicloud.resourcemanager.get_accounts(status="CreateSuccess")
 * default_aggregator = alicloud.cfg.Aggregator("default",
 *     aggregator_accounts=[{
 *         "account_id": default.accounts[0].account_id,
 *         "account_name": default.accounts[0].display_name,
 *         "account_type": "ResourceDirectory",
 *     }],
 *     aggregator_name=name,
 *     description=name,
 *     aggregator_type="CUSTOM")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = AliCloud.ResourceManager.GetAccounts.Invoke(new()
 *     {
 *         Status = "CreateSuccess",
 *     });
 *     var defaultAggregator = new AliCloud.Cfg.Aggregator("default", new()
 *     {
 *         AggregatorAccounts = new[]
 *         {
 *             new AliCloud.Cfg.Inputs.AggregatorAggregatorAccountArgs
 *             {
 *                 AccountId = @default.Apply(@default => @default.Apply(getAccountsResult => getAccountsResult.Accounts[0]?.AccountId)),
 *                 AccountName = @default.Apply(@default => @default.Apply(getAccountsResult => getAccountsResult.Accounts[0]?.DisplayName)),
 *                 AccountType = "ResourceDirectory",
 *             },
 *         },
 *         AggregatorName = name,
 *         Description = name,
 *         AggregatorType = "CUSTOM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cfg"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := resourcemanager.GetAccounts(ctx, &resourcemanager.GetAccountsArgs{
 * 			Status: pulumi.StringRef("CreateSuccess"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cfg.NewAggregator(ctx, "default", &cfg.AggregatorArgs{
 * 			AggregatorAccounts: cfg.AggregatorAggregatorAccountArray{
 * 				&cfg.AggregatorAggregatorAccountArgs{
 * 					AccountId:   pulumi.String(_default.Accounts[0].AccountId),
 * 					AccountName: pulumi.String(_default.Accounts[0].DisplayName),
 * 					AccountType: pulumi.String("ResourceDirectory"),
 * 				},
 * 			},
 * 			AggregatorName: pulumi.String(name),
 * 			Description:    pulumi.String(name),
 * 			AggregatorType: pulumi.String("CUSTOM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetAccountsArgs;
 * import com.pulumi.alicloud.cfg.Aggregator;
 * import com.pulumi.alicloud.cfg.AggregatorArgs;
 * import com.pulumi.alicloud.cfg.inputs.AggregatorAggregatorAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         final var default = ResourcemanagerFunctions.getAccounts(GetAccountsArgs.builder()
 *             .status("CreateSuccess")
 *             .build());
 *         var defaultAggregator = new Aggregator("defaultAggregator", AggregatorArgs.builder()
 *             .aggregatorAccounts(AggregatorAggregatorAccountArgs.builder()
 *                 .accountId(default_.accounts()[0].accountId())
 *                 .accountName(default_.accounts()[0].displayName())
 *                 .accountType("ResourceDirectory")
 *                 .build())
 *             .aggregatorName(name)
 *             .description(name)
 *             .aggregatorType("CUSTOM")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   defaultAggregator:
 *     type: alicloud:cfg:Aggregator
 *     name: default
 *     properties:
 *       aggregatorAccounts:
 *         - accountId: ${default.accounts[0].accountId}
 *           accountName: ${default.accounts[0].displayName}
 *           accountType: ResourceDirectory
 *       aggregatorName: ${name}
 *       description: ${name}
 *       aggregatorType: CUSTOM
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getAccounts
 *       Arguments:
 *         status: CreateSuccess
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Config Aggregator can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cfg/aggregator:Aggregator example <id>
 * ```
 */
public class Aggregator internal constructor(
    override val javaResource: com.pulumi.alicloud.cfg.Aggregator,
) : KotlinCustomResource(javaResource, AggregatorMapper) {
    /**
     * The information of account in aggregator. If the aggregator_type is RD, it is optional and means add all members in the resource directory to the account group. See `aggregator_accounts` below.  **NOTE:** the field `aggregator_accounts` is not required from version 1.148.0.
     */
    public val aggregatorAccounts: Output<List<AggregatorAggregatorAccount>>
        get() = javaResource.aggregatorAccounts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * The name of aggregator.
     */
    public val aggregatorName: Output<String>
        get() = javaResource.aggregatorName().applyValue({ args0 -> args0 })

    /**
     * The type of aggregator. Valid values: `CUSTOM`, `RD`. The Default value: `CUSTOM`.
     * * `CUSTOM` - The custom account group.
     * * `RD` - The global account group.
     */
    public val aggregatorType: Output<String>
        get() = javaResource.aggregatorType().applyValue({ args0 -> args0 })

    /**
     * The description of aggregator.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The status of the resource. Valid values: `0`: creating `1`: normal `2`: deleting.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object AggregatorMapper : ResourceMapper<Aggregator> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cfg.Aggregator::class == javaResource::class

    override fun map(javaResource: Resource): Aggregator = Aggregator(
        javaResource as
            com.pulumi.alicloud.cfg.Aggregator,
    )
}

/**
 * @see [Aggregator].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Aggregator].
 */
public suspend fun aggregator(name: String, block: suspend AggregatorResourceBuilder.() -> Unit): Aggregator {
    val builder = AggregatorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Aggregator].
 * @param name The _unique_ name of the resulting resource.
 */
public fun aggregator(name: String): Aggregator {
    val builder = AggregatorResourceBuilder()
    builder.name(name)
    return builder.build()
}
