@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin

import com.pulumi.alicloud.cfg.CfgFunctions.getAggregateCompliancePacksPlain
import com.pulumi.alicloud.cfg.CfgFunctions.getAggregateConfigRulesPlain
import com.pulumi.alicloud.cfg.CfgFunctions.getAggregateDeliveriesPlain
import com.pulumi.alicloud.cfg.CfgFunctions.getAggregatorsPlain
import com.pulumi.alicloud.cfg.CfgFunctions.getCompliancePacksPlain
import com.pulumi.alicloud.cfg.CfgFunctions.getConfigurationRecordersPlain
import com.pulumi.alicloud.cfg.CfgFunctions.getDeliveriesPlain
import com.pulumi.alicloud.cfg.CfgFunctions.getDeliveryChannelsPlain
import com.pulumi.alicloud.cfg.CfgFunctions.getRulesPlain
import com.pulumi.alicloud.cfg.kotlin.inputs.GetAggregateCompliancePacksPlainArgs
import com.pulumi.alicloud.cfg.kotlin.inputs.GetAggregateCompliancePacksPlainArgsBuilder
import com.pulumi.alicloud.cfg.kotlin.inputs.GetAggregateConfigRulesPlainArgs
import com.pulumi.alicloud.cfg.kotlin.inputs.GetAggregateConfigRulesPlainArgsBuilder
import com.pulumi.alicloud.cfg.kotlin.inputs.GetAggregateDeliveriesPlainArgs
import com.pulumi.alicloud.cfg.kotlin.inputs.GetAggregateDeliveriesPlainArgsBuilder
import com.pulumi.alicloud.cfg.kotlin.inputs.GetAggregatorsPlainArgs
import com.pulumi.alicloud.cfg.kotlin.inputs.GetAggregatorsPlainArgsBuilder
import com.pulumi.alicloud.cfg.kotlin.inputs.GetCompliancePacksPlainArgs
import com.pulumi.alicloud.cfg.kotlin.inputs.GetCompliancePacksPlainArgsBuilder
import com.pulumi.alicloud.cfg.kotlin.inputs.GetConfigurationRecordersPlainArgs
import com.pulumi.alicloud.cfg.kotlin.inputs.GetConfigurationRecordersPlainArgsBuilder
import com.pulumi.alicloud.cfg.kotlin.inputs.GetDeliveriesPlainArgs
import com.pulumi.alicloud.cfg.kotlin.inputs.GetDeliveriesPlainArgsBuilder
import com.pulumi.alicloud.cfg.kotlin.inputs.GetDeliveryChannelsPlainArgs
import com.pulumi.alicloud.cfg.kotlin.inputs.GetDeliveryChannelsPlainArgsBuilder
import com.pulumi.alicloud.cfg.kotlin.inputs.GetRulesPlainArgs
import com.pulumi.alicloud.cfg.kotlin.inputs.GetRulesPlainArgsBuilder
import com.pulumi.alicloud.cfg.kotlin.outputs.GetAggregateCompliancePacksResult
import com.pulumi.alicloud.cfg.kotlin.outputs.GetAggregateConfigRulesResult
import com.pulumi.alicloud.cfg.kotlin.outputs.GetAggregateDeliveriesResult
import com.pulumi.alicloud.cfg.kotlin.outputs.GetAggregatorsResult
import com.pulumi.alicloud.cfg.kotlin.outputs.GetCompliancePacksResult
import com.pulumi.alicloud.cfg.kotlin.outputs.GetConfigurationRecordersResult
import com.pulumi.alicloud.cfg.kotlin.outputs.GetDeliveriesResult
import com.pulumi.alicloud.cfg.kotlin.outputs.GetDeliveryChannelsResult
import com.pulumi.alicloud.cfg.kotlin.outputs.GetRulesResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.cfg.kotlin.outputs.GetAggregateCompliancePacksResult.Companion.toKotlin as getAggregateCompliancePacksResultToKotlin
import com.pulumi.alicloud.cfg.kotlin.outputs.GetAggregateConfigRulesResult.Companion.toKotlin as getAggregateConfigRulesResultToKotlin
import com.pulumi.alicloud.cfg.kotlin.outputs.GetAggregateDeliveriesResult.Companion.toKotlin as getAggregateDeliveriesResultToKotlin
import com.pulumi.alicloud.cfg.kotlin.outputs.GetAggregatorsResult.Companion.toKotlin as getAggregatorsResultToKotlin
import com.pulumi.alicloud.cfg.kotlin.outputs.GetCompliancePacksResult.Companion.toKotlin as getCompliancePacksResultToKotlin
import com.pulumi.alicloud.cfg.kotlin.outputs.GetConfigurationRecordersResult.Companion.toKotlin as getConfigurationRecordersResultToKotlin
import com.pulumi.alicloud.cfg.kotlin.outputs.GetDeliveriesResult.Companion.toKotlin as getDeliveriesResultToKotlin
import com.pulumi.alicloud.cfg.kotlin.outputs.GetDeliveryChannelsResult.Companion.toKotlin as getDeliveryChannelsResultToKotlin
import com.pulumi.alicloud.cfg.kotlin.outputs.GetRulesResult.Companion.toKotlin as getRulesResultToKotlin

public object CfgFunctions {
    /**
     * This data source provides the Config Aggregate Compliance Packs of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.124.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.cfg.getAggregateCompliancePacks({
     *     aggregatorId: "ca-3a9b626622af001d****",
     *     ids: ["cp-152a626622af00bc****"],
     *     nameRegex: "the_resource_name",
     * });
     * export const firstConfigAggregateCompliancePackId = example.then(example => example.packs?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.cfg.get_aggregate_compliance_packs(aggregator_id="ca-3a9b626622af001d****",
     *     ids=["cp-152a626622af00bc****"],
     *     name_regex="the_resource_name")
     * pulumi.export("firstConfigAggregateCompliancePackId", example.packs[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Cfg.GetAggregateCompliancePacks.Invoke(new()
     *     {
     *         AggregatorId = "ca-3a9b626622af001d****",
     *         Ids = new[]
     *         {
     *             "cp-152a626622af00bc****",
     *         },
     *         NameRegex = "the_resource_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstConfigAggregateCompliancePackId"] = example&#46;Apply(getAggregateCompliancePacksResult => getAggregateCompliancePacksResult&#46;Packs[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cfg"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := cfg.GetAggregateCompliancePacks(ctx, &cfg.GetAggregateCompliancePacksArgs{
     * 			AggregatorId: "ca-3a9b626622af001d****",
     * 			Ids: []string{
     * 				"cp-152a626622af00bc****",
     * 			},
     * 			NameRegex: pulumi.StringRef("the_resource_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstConfigAggregateCompliancePackId", example.Packs[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cfg.CfgFunctions;
     * import com.pulumi.alicloud.cfg.inputs.GetAggregateCompliancePacksArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CfgFunctions.getAggregateCompliancePacks(GetAggregateCompliancePacksArgs.builder()
     *             .aggregatorId("ca-3a9b626622af001d****")
     *             .ids("cp-152a626622af00bc****")
     *             .nameRegex("the_resource_name")
     *             .build());
     *         ctx.export("firstConfigAggregateCompliancePackId", example.applyValue(getAggregateCompliancePacksResult -> getAggregateCompliancePacksResult.packs()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:cfg:getAggregateCompliancePacks
     *       Arguments:
     *         aggregatorId: ca-3a9b626622af001d****
     *         ids:
     *           - cp-152a626622af00bc****
     *         nameRegex: the_resource_name
     * outputs:
     *   firstConfigAggregateCompliancePackId: ${example.packs[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAggregateCompliancePacks.
     * @return A collection of values returned by getAggregateCompliancePacks.
     */
    public suspend fun getAggregateCompliancePacks(argument: GetAggregateCompliancePacksPlainArgs): GetAggregateCompliancePacksResult =
        getAggregateCompliancePacksResultToKotlin(getAggregateCompliancePacksPlain(argument.toJava()).await())

    /**
     * @see [getAggregateCompliancePacks].
     * @param aggregatorId The ID of aggregator.
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Aggregate Compliance Pack IDs.
     * @param nameRegex A regex string to filter results by Aggregate Compliance Pack name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the resource. Valid values `ACTIVE`, `CREATING`, `INACTIVE`.
     * @return A collection of values returned by getAggregateCompliancePacks.
     */
    public suspend fun getAggregateCompliancePacks(
        aggregatorId: String,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetAggregateCompliancePacksResult {
        val argument = GetAggregateCompliancePacksPlainArgs(
            aggregatorId = aggregatorId,
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getAggregateCompliancePacksResultToKotlin(getAggregateCompliancePacksPlain(argument.toJava()).await())
    }

    /**
     * @see [getAggregateCompliancePacks].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cfg&#46;kotlin&#46;inputs&#46;GetAggregateCompliancePacksPlainArgs].
     * @return A collection of values returned by getAggregateCompliancePacks.
     */
    public suspend fun getAggregateCompliancePacks(argument: suspend GetAggregateCompliancePacksPlainArgsBuilder.() -> Unit): GetAggregateCompliancePacksResult {
        val builder = GetAggregateCompliancePacksPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAggregateCompliancePacksResultToKotlin(getAggregateCompliancePacksPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Config Aggregate Config Rules of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.124.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.cfg.getAggregateConfigRules({
     *     aggregatorId: "ca-3a9b626622af001d****",
     *     ids: ["cr-5154626622af0034****"],
     *     nameRegex: "the_resource_name",
     * });
     * export const firstConfigAggregateConfigRuleId = example.then(example => example.rules?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.cfg.get_aggregate_config_rules(aggregator_id="ca-3a9b626622af001d****",
     *     ids=["cr-5154626622af0034****"],
     *     name_regex="the_resource_name")
     * pulumi.export("firstConfigAggregateConfigRuleId", example.rules[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Cfg.GetAggregateConfigRules.Invoke(new()
     *     {
     *         AggregatorId = "ca-3a9b626622af001d****",
     *         Ids = new[]
     *         {
     *             "cr-5154626622af0034****",
     *         },
     *         NameRegex = "the_resource_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstConfigAggregateConfigRuleId"] = example&#46;Apply(getAggregateConfigRulesResult => getAggregateConfigRulesResult&#46;Rules[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cfg"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := cfg.GetAggregateConfigRules(ctx, &cfg.GetAggregateConfigRulesArgs{
     * 			AggregatorId: "ca-3a9b626622af001d****",
     * 			Ids: []string{
     * 				"cr-5154626622af0034****",
     * 			},
     * 			NameRegex: pulumi.StringRef("the_resource_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstConfigAggregateConfigRuleId", example.Rules[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cfg.CfgFunctions;
     * import com.pulumi.alicloud.cfg.inputs.GetAggregateConfigRulesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CfgFunctions.getAggregateConfigRules(GetAggregateConfigRulesArgs.builder()
     *             .aggregatorId("ca-3a9b626622af001d****")
     *             .ids("cr-5154626622af0034****")
     *             .nameRegex("the_resource_name")
     *             .build());
     *         ctx.export("firstConfigAggregateConfigRuleId", example.applyValue(getAggregateConfigRulesResult -> getAggregateConfigRulesResult.rules()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:cfg:getAggregateConfigRules
     *       Arguments:
     *         aggregatorId: ca-3a9b626622af001d****
     *         ids:
     *           - cr-5154626622af0034****
     *         nameRegex: the_resource_name
     * outputs:
     *   firstConfigAggregateConfigRuleId: ${example.rules[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAggregateConfigRules.
     * @return A collection of values returned by getAggregateConfigRules.
     */
    public suspend fun getAggregateConfigRules(argument: GetAggregateConfigRulesPlainArgs): GetAggregateConfigRulesResult =
        getAggregateConfigRulesResultToKotlin(getAggregateConfigRulesPlain(argument.toJava()).await())

    /**
     * @see [getAggregateConfigRules].
     * @param aggregateConfigRuleName The config rule name.
     * @param aggregatorId The ID of aggregator.
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Aggregate Config Rule IDs.
     * @param nameRegex A regex string to filter results by Aggregate Config Rule name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param riskLevel Optional, ForceNew) The Risk Level. Valid values `1`: critical, `2`: warning, `3`: info.
     * @param status The state of the config rule, valid values: `ACTIVE`, `DELETING`, `EVALUATING` and `INACTIVE`.
     * @return A collection of values returned by getAggregateConfigRules.
     */
    public suspend fun getAggregateConfigRules(
        aggregateConfigRuleName: String? = null,
        aggregatorId: String,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        riskLevel: Int? = null,
        status: String? = null,
    ): GetAggregateConfigRulesResult {
        val argument = GetAggregateConfigRulesPlainArgs(
            aggregateConfigRuleName = aggregateConfigRuleName,
            aggregatorId = aggregatorId,
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            riskLevel = riskLevel,
            status = status,
        )
        return getAggregateConfigRulesResultToKotlin(getAggregateConfigRulesPlain(argument.toJava()).await())
    }

    /**
     * @see [getAggregateConfigRules].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cfg&#46;kotlin&#46;inputs&#46;GetAggregateConfigRulesPlainArgs].
     * @return A collection of values returned by getAggregateConfigRules.
     */
    public suspend fun getAggregateConfigRules(argument: suspend GetAggregateConfigRulesPlainArgsBuilder.() -> Unit): GetAggregateConfigRulesResult {
        val builder = GetAggregateConfigRulesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAggregateConfigRulesResultToKotlin(getAggregateConfigRulesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Config Aggregate Deliveries of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.172.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cfg.getAggregateDeliveries({
     *     aggregatorId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const configAggregateDeliveryId1 = ids.then(ids => ids.deliveries?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cfg.get_aggregate_deliveries(aggregator_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("configAggregateDeliveryId1", ids.deliveries[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Cfg.GetAggregateDeliveries.Invoke(new()
     *     {
     *         AggregatorId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["configAggregateDeliveryId1"] = ids&#46;Apply(getAggregateDeliveriesResult => getAggregateDeliveriesResult&#46;Deliveries[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cfg"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cfg.GetAggregateDeliveries(ctx, &cfg.GetAggregateDeliveriesArgs{
     * 			AggregatorId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("configAggregateDeliveryId1", ids.Deliveries[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cfg.CfgFunctions;
     * import com.pulumi.alicloud.cfg.inputs.GetAggregateDeliveriesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CfgFunctions.getAggregateDeliveries(GetAggregateDeliveriesArgs.builder()
     *             .aggregatorId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("configAggregateDeliveryId1", ids.applyValue(getAggregateDeliveriesResult -> getAggregateDeliveriesResult.deliveries()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cfg:getAggregateDeliveries
     *       Arguments:
     *         aggregatorId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     * outputs:
     *   configAggregateDeliveryId1: ${ids.deliveries[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAggregateDeliveries.
     * @return A collection of values returned by getAggregateDeliveries.
     */
    public suspend fun getAggregateDeliveries(argument: GetAggregateDeliveriesPlainArgs): GetAggregateDeliveriesResult =
        getAggregateDeliveriesResultToKotlin(getAggregateDeliveriesPlain(argument.toJava()).await())

    /**
     * @see [getAggregateDeliveries].
     * @param aggregatorId The ID of the Aggregator.
     * @param ids A list of Aggregate Delivery IDs.
     * @param nameRegex
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the delivery method. Valid values: `0`: The delivery method is disabled. `1`: The delivery destination is enabled.
     * @return A collection of values returned by getAggregateDeliveries.
     */
    public suspend fun getAggregateDeliveries(
        aggregatorId: String,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: Int? = null,
    ): GetAggregateDeliveriesResult {
        val argument = GetAggregateDeliveriesPlainArgs(
            aggregatorId = aggregatorId,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getAggregateDeliveriesResultToKotlin(getAggregateDeliveriesPlain(argument.toJava()).await())
    }

    /**
     * @see [getAggregateDeliveries].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cfg&#46;kotlin&#46;inputs&#46;GetAggregateDeliveriesPlainArgs].
     * @return A collection of values returned by getAggregateDeliveries.
     */
    public suspend fun getAggregateDeliveries(argument: suspend GetAggregateDeliveriesPlainArgsBuilder.() -> Unit): GetAggregateDeliveriesResult {
        val builder = GetAggregateDeliveriesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAggregateDeliveriesResultToKotlin(getAggregateDeliveriesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Config Aggregators of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.124.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.cfg.getAggregators({
     *     ids: ["ca-3ce2626622af0005****"],
     *     nameRegex: "the_resource_name",
     * });
     * export const firstConfigAggregatorId = example.then(example => example.aggregators?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.cfg.get_aggregators(ids=["ca-3ce2626622af0005****"],
     *     name_regex="the_resource_name")
     * pulumi.export("firstConfigAggregatorId", example.aggregators[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Cfg.GetAggregators.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "ca-3ce2626622af0005****",
     *         },
     *         NameRegex = "the_resource_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstConfigAggregatorId"] = example&#46;Apply(getAggregatorsResult => getAggregatorsResult&#46;Aggregators[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cfg"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := cfg.GetAggregators(ctx, &cfg.GetAggregatorsArgs{
     * 			Ids: []string{
     * 				"ca-3ce2626622af0005****",
     * 			},
     * 			NameRegex: pulumi.StringRef("the_resource_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstConfigAggregatorId", example.Aggregators[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cfg.CfgFunctions;
     * import com.pulumi.alicloud.cfg.inputs.GetAggregatorsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CfgFunctions.getAggregators(GetAggregatorsArgs.builder()
     *             .ids("ca-3ce2626622af0005****")
     *             .nameRegex("the_resource_name")
     *             .build());
     *         ctx.export("firstConfigAggregatorId", example.applyValue(getAggregatorsResult -> getAggregatorsResult.aggregators()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:cfg:getAggregators
     *       Arguments:
     *         ids:
     *           - ca-3ce2626622af0005****
     *         nameRegex: the_resource_name
     * outputs:
     *   firstConfigAggregatorId: ${example.aggregators[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAggregators.
     * @return A collection of values returned by getAggregators.
     */
    public suspend fun getAggregators(argument: GetAggregatorsPlainArgs): GetAggregatorsResult =
        getAggregatorsResultToKotlin(getAggregatorsPlain(argument.toJava()).await())

    /**
     * @see [getAggregators].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of aggregator ids.
     * @param nameRegex A regex string to filter results by aggregator name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the resource. Valid Values:  `0`: creating `1`: normal `2`: deleting.
     * @return A collection of values returned by getAggregators.
     */
    public suspend fun getAggregators(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetAggregatorsResult {
        val argument = GetAggregatorsPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getAggregatorsResultToKotlin(getAggregatorsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAggregators].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cfg&#46;kotlin&#46;inputs&#46;GetAggregatorsPlainArgs].
     * @return A collection of values returned by getAggregators.
     */
    public suspend fun getAggregators(argument: suspend GetAggregatorsPlainArgsBuilder.() -> Unit): GetAggregatorsResult {
        val builder = GetAggregatorsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAggregatorsResultToKotlin(getAggregatorsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Config Compliance Packs of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.124.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.cfg.getCompliancePacks({
     *     ids: ["cp-152a626622af00bc****"],
     *     nameRegex: "the_resource_name",
     * });
     * export const firstConfigCompliancePackId = example.then(example => example.packs?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.cfg.get_compliance_packs(ids=["cp-152a626622af00bc****"],
     *     name_regex="the_resource_name")
     * pulumi.export("firstConfigCompliancePackId", example.packs[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Cfg.GetCompliancePacks.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "cp-152a626622af00bc****",
     *         },
     *         NameRegex = "the_resource_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstConfigCompliancePackId"] = example&#46;Apply(getCompliancePacksResult => getCompliancePacksResult&#46;Packs[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cfg"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := cfg.GetCompliancePacks(ctx, &cfg.GetCompliancePacksArgs{
     * 			Ids: []string{
     * 				"cp-152a626622af00bc****",
     * 			},
     * 			NameRegex: pulumi.StringRef("the_resource_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstConfigCompliancePackId", example.Packs[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cfg.CfgFunctions;
     * import com.pulumi.alicloud.cfg.inputs.GetCompliancePacksArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CfgFunctions.getCompliancePacks(GetCompliancePacksArgs.builder()
     *             .ids("cp-152a626622af00bc****")
     *             .nameRegex("the_resource_name")
     *             .build());
     *         ctx.export("firstConfigCompliancePackId", example.applyValue(getCompliancePacksResult -> getCompliancePacksResult.packs()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:cfg:getCompliancePacks
     *       Arguments:
     *         ids:
     *           - cp-152a626622af00bc****
     *         nameRegex: the_resource_name
     * outputs:
     *   firstConfigCompliancePackId: ${example.packs[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCompliancePacks.
     * @return A collection of values returned by getCompliancePacks.
     */
    public suspend fun getCompliancePacks(argument: GetCompliancePacksPlainArgs): GetCompliancePacksResult =
        getCompliancePacksResultToKotlin(getCompliancePacksPlain(argument.toJava()).await())

    /**
     * @see [getCompliancePacks].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Compliance Pack IDs.
     * @param nameRegex A regex string to filter results by Compliance Pack name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the resource. Valid values `ACTIVE`, `CREATING`.
     * @return A collection of values returned by getCompliancePacks.
     */
    public suspend fun getCompliancePacks(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetCompliancePacksResult {
        val argument = GetCompliancePacksPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getCompliancePacksResultToKotlin(getCompliancePacksPlain(argument.toJava()).await())
    }

    /**
     * @see [getCompliancePacks].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cfg&#46;kotlin&#46;inputs&#46;GetCompliancePacksPlainArgs].
     * @return A collection of values returned by getCompliancePacks.
     */
    public suspend fun getCompliancePacks(argument: suspend GetCompliancePacksPlainArgsBuilder.() -> Unit): GetCompliancePacksResult {
        val builder = GetCompliancePacksPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCompliancePacksResultToKotlin(getCompliancePacksPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Config Configuration Recorders of the current Alibaba Cloud user.
     * > **NOTE:**  Available in 1.99.0+.
     * > **NOTE:** The Cloud Config region only support `cn-shanghai` and `ap-southeast-1`.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.cfg.getConfigurationRecorders({});
     * export const listOfResourceTypes = _this.recorders[0].resourceTypes;
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.cfg.get_configuration_recorders()
     * pulumi.export("listOfResourceTypes", this["recorders"][0]["resourceTypes"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Cfg.GetConfigurationRecorders.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["listOfResourceTypes"] = @this&#46;Recorders[0].ResourceTypes,
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cfg"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cfg.GetConfigurationRecorders(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("listOfResourceTypes", this.Recorders[0].ResourceTypes)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cfg.CfgFunctions;
     * import com.pulumi.alicloud.cfg.inputs.GetConfigurationRecordersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CfgFunctions.getConfigurationRecorders();
     *         ctx.export("listOfResourceTypes", this_.recorders()[0].resourceTypes());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:cfg:getConfigurationRecorders
     *       Arguments: {}
     * outputs:
     *   listOfResourceTypes: ${this.recorders[0].resourceTypes}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getConfigurationRecorders.
     * @return A collection of values returned by getConfigurationRecorders.
     */
    public suspend fun getConfigurationRecorders(argument: GetConfigurationRecordersPlainArgs): GetConfigurationRecordersResult =
        getConfigurationRecordersResultToKotlin(getConfigurationRecordersPlain(argument.toJava()).await())

    /**
     * @see [getConfigurationRecorders].
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getConfigurationRecorders.
     */
    public suspend fun getConfigurationRecorders(outputFile: String? = null): GetConfigurationRecordersResult {
        val argument = GetConfigurationRecordersPlainArgs(
            outputFile = outputFile,
        )
        return getConfigurationRecordersResultToKotlin(getConfigurationRecordersPlain(argument.toJava()).await())
    }

    /**
     * @see [getConfigurationRecorders].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cfg&#46;kotlin&#46;inputs&#46;GetConfigurationRecordersPlainArgs].
     * @return A collection of values returned by getConfigurationRecorders.
     */
    public suspend fun getConfigurationRecorders(argument: suspend GetConfigurationRecordersPlainArgsBuilder.() -> Unit): GetConfigurationRecordersResult {
        val builder = GetConfigurationRecordersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConfigurationRecordersResultToKotlin(getConfigurationRecordersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Config Deliveries of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.171.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cfg.getDeliveries({
     *     ids: ["example_id"],
     * });
     * export const configDeliveryId1 = ids.then(ids => ids.deliveries?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cfg.get_deliveries(ids=["example_id"])
     * pulumi.export("configDeliveryId1", ids.deliveries[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Cfg.GetDeliveries.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["configDeliveryId1"] = ids&#46;Apply(getDeliveriesResult => getDeliveriesResult&#46;Deliveries[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cfg"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cfg.GetDeliveries(ctx, &cfg.GetDeliveriesArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("configDeliveryId1", ids.Deliveries[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cfg.CfgFunctions;
     * import com.pulumi.alicloud.cfg.inputs.GetDeliveriesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CfgFunctions.getDeliveries(GetDeliveriesArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("configDeliveryId1", ids.applyValue(getDeliveriesResult -> getDeliveriesResult.deliveries()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cfg:getDeliveries
     *       Arguments:
     *         ids:
     *           - example_id
     * outputs:
     *   configDeliveryId1: ${ids.deliveries[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDeliveries.
     * @return A collection of values returned by getDeliveries.
     */
    public suspend fun getDeliveries(argument: GetDeliveriesPlainArgs): GetDeliveriesResult =
        getDeliveriesResultToKotlin(getDeliveriesPlain(argument.toJava()).await())

    /**
     * @see [getDeliveries].
     * @param ids A list of Delivery IDs.
     * @param nameRegex A regex string to filter results by delivery channel name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the delivery method. Valid values: `0`: The delivery method is disabled. `1`: The delivery destination is enabled.
     * @return A collection of values returned by getDeliveries.
     */
    public suspend fun getDeliveries(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: Int? = null,
    ): GetDeliveriesResult {
        val argument = GetDeliveriesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getDeliveriesResultToKotlin(getDeliveriesPlain(argument.toJava()).await())
    }

    /**
     * @see [getDeliveries].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cfg&#46;kotlin&#46;inputs&#46;GetDeliveriesPlainArgs].
     * @return A collection of values returned by getDeliveries.
     */
    public suspend fun getDeliveries(argument: suspend GetDeliveriesPlainArgsBuilder.() -> Unit): GetDeliveriesResult {
        val builder = GetDeliveriesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDeliveriesResultToKotlin(getDeliveriesPlain(builtArgument.toJava()).await())
    }

    /**
     * > **DEPRECATED:**  This resource is based on Config's old version OpenAPI, and it has been deprecated from version `1.173.0`.
     * Please use new datasource alicloud.cfg.getDeliveries instead.
     * This data source provides the Config Delivery Channels of the current Alibaba Cloud user.
     * > **NOTE:**  Available in 1.99.0+.
     * > **NOTE:** The Cloud Config region only support `cn-shanghai` and `ap-southeast-1`.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.cfg.getDeliveryChannels({
     *     ids: ["cdc-49a2ad756057********"],
     *     nameRegex: "tftest",
     * });
     * export const firstConfigDeliveryChannelId = example.then(example => example.channels?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.cfg.get_delivery_channels(ids=["cdc-49a2ad756057********"],
     *     name_regex="tftest")
     * pulumi.export("firstConfigDeliveryChannelId", example.channels[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Cfg.GetDeliveryChannels.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "cdc-49a2ad756057********",
     *         },
     *         NameRegex = "tftest",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstConfigDeliveryChannelId"] = example&#46;Apply(getDeliveryChannelsResult => getDeliveryChannelsResult&#46;Channels[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cfg"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := cfg.GetDeliveryChannels(ctx, &cfg.GetDeliveryChannelsArgs{
     * 			Ids: []string{
     * 				"cdc-49a2ad756057********",
     * 			},
     * 			NameRegex: pulumi.StringRef("tftest"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstConfigDeliveryChannelId", example.Channels[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cfg.CfgFunctions;
     * import com.pulumi.alicloud.cfg.inputs.GetDeliveryChannelsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CfgFunctions.getDeliveryChannels(GetDeliveryChannelsArgs.builder()
     *             .ids("cdc-49a2ad756057********")
     *             .nameRegex("tftest")
     *             .build());
     *         ctx.export("firstConfigDeliveryChannelId", example.applyValue(getDeliveryChannelsResult -> getDeliveryChannelsResult.channels()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:cfg:getDeliveryChannels
     *       Arguments:
     *         ids:
     *           - cdc-49a2ad756057********
     *         nameRegex: tftest
     * outputs:
     *   firstConfigDeliveryChannelId: ${example.channels[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDeliveryChannels.
     * @return A collection of values returned by getDeliveryChannels.
     */
    public suspend fun getDeliveryChannels(argument: GetDeliveryChannelsPlainArgs): GetDeliveryChannelsResult =
        getDeliveryChannelsResultToKotlin(getDeliveryChannelsPlain(argument.toJava()).await())

    /**
     * @see [getDeliveryChannels].
     * @param ids A list of Config Delivery Channel IDs.
     * @param nameRegex A regex string to filter results by delivery channel name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the config delivery channel. Valid values `0`: Disable delivery channel, `1`: Enable delivery channel.
     * @return A collection of values returned by getDeliveryChannels.
     */
    public suspend fun getDeliveryChannels(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: Int? = null,
    ): GetDeliveryChannelsResult {
        val argument = GetDeliveryChannelsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getDeliveryChannelsResultToKotlin(getDeliveryChannelsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDeliveryChannels].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cfg&#46;kotlin&#46;inputs&#46;GetDeliveryChannelsPlainArgs].
     * @return A collection of values returned by getDeliveryChannels.
     */
    public suspend fun getDeliveryChannels(argument: suspend GetDeliveryChannelsPlainArgsBuilder.() -> Unit): GetDeliveryChannelsResult {
        val builder = GetDeliveryChannelsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDeliveryChannelsResultToKotlin(getDeliveryChannelsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Config Rules of the current Alibaba Cloud user.
     * > **NOTE:**  Available in 1.99.0+.
     * > **NOTE:** The Cloud Config region only support `cn-shanghai` and `ap-southeast-1`.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.cfg.getRules({
     *     ids: ["cr-ed4bad756057********"],
     *     nameRegex: "tftest",
     * });
     * export const firstConfigRuleId = example.then(example => example.rules?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.cfg.get_rules(ids=["cr-ed4bad756057********"],
     *     name_regex="tftest")
     * pulumi.export("firstConfigRuleId", example.rules[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Cfg.GetRules.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "cr-ed4bad756057********",
     *         },
     *         NameRegex = "tftest",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstConfigRuleId"] = example&#46;Apply(getRulesResult => getRulesResult&#46;Rules[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cfg"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := cfg.GetRules(ctx, &cfg.GetRulesArgs{
     * 			Ids: []string{
     * 				"cr-ed4bad756057********",
     * 			},
     * 			NameRegex: pulumi.StringRef("tftest"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstConfigRuleId", example.Rules[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cfg.CfgFunctions;
     * import com.pulumi.alicloud.cfg.inputs.GetRulesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CfgFunctions.getRules(GetRulesArgs.builder()
     *             .ids("cr-ed4bad756057********")
     *             .nameRegex("tftest")
     *             .build());
     *         ctx.export("firstConfigRuleId", example.applyValue(getRulesResult -> getRulesResult.rules()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:cfg:getRules
     *       Arguments:
     *         ids:
     *           - cr-ed4bad756057********
     *         nameRegex: tftest
     * outputs:
     *   firstConfigRuleId: ${example.rules[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRules.
     * @return A collection of values returned by getRules.
     */
    public suspend fun getRules(argument: GetRulesPlainArgs): GetRulesResult =
        getRulesResultToKotlin(getRulesPlain(argument.toJava()).await())

    /**
     * @see [getRules].
     * @param configRuleState Field `config_rule_state` has been deprecated from provider version 1.124.1. New field `status` instead.
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Config Rule IDs.
     * @param nameRegex A regex string to filter results by rule name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param riskLevel The risk level of Config Rule. Valid values: `1`: Critical ,`2`: Warning , `3`: Info.
     * @param ruleName The name of config rule.
     * @param status The status of the config rule, valid values: `ACTIVE`, `DELETING`, `EVALUATING` and `INACTIVE`.
     * @return A collection of values returned by getRules.
     */
    public suspend fun getRules(
        configRuleState: String? = null,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        riskLevel: Int? = null,
        ruleName: String? = null,
        status: String? = null,
    ): GetRulesResult {
        val argument = GetRulesPlainArgs(
            configRuleState = configRuleState,
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            riskLevel = riskLevel,
            ruleName = ruleName,
            status = status,
        )
        return getRulesResultToKotlin(getRulesPlain(argument.toJava()).await())
    }

    /**
     * @see [getRules].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cfg&#46;kotlin&#46;inputs&#46;GetRulesPlainArgs].
     * @return A collection of values returned by getRules.
     */
    public suspend fun getRules(argument: suspend GetRulesPlainArgsBuilder.() -> Unit): GetRulesResult {
        val builder = GetRulesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRulesResultToKotlin(getRulesPlain(builtArgument.toJava()).await())
    }
}
