@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin

import com.pulumi.alicloud.cfg.CompliancePackArgs.builder
import com.pulumi.alicloud.cfg.kotlin.inputs.CompliancePackConfigRuleArgs
import com.pulumi.alicloud.cfg.kotlin.inputs.CompliancePackConfigRuleArgsBuilder
import com.pulumi.alicloud.cfg.kotlin.inputs.CompliancePackConfigRuleIdArgs
import com.pulumi.alicloud.cfg.kotlin.inputs.CompliancePackConfigRuleIdArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Config Compliance Pack resource.
 * For information about Cloud Config Compliance Pack and how to use it, see [What is Compliance Pack](https://www.alibabacloud.com/help/en/cloud-config/latest/api-config-2020-09-07-createcompliancepack).
 * > **NOTE:** Available since v1.124.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example-config-name";
 * const default = alicloud.getRegions({
 *     current: true,
 * });
 * const rule1 = new alicloud.cfg.Rule("rule1", {
 *     description: name,
 *     sourceOwner: "ALIYUN",
 *     sourceIdentifier: "ram-user-ak-create-date-expired-check",
 *     riskLevel: 1,
 *     maximumExecutionFrequency: "TwentyFour_Hours",
 *     regionIdsScope: _default.then(_default => _default.regions?.[0]?.id),
 *     configRuleTriggerTypes: "ScheduledNotification",
 *     resourceTypesScopes: ["ACS::RAM::User"],
 *     ruleName: "ciscompliancecheck_ram-user-ak-create-date-expired-check",
 *     inputParameters: {
 *         days: "90",
 *     },
 * });
 * const rule2 = new alicloud.cfg.Rule("rule2", {
 *     description: name,
 *     sourceOwner: "ALIYUN",
 *     sourceIdentifier: "adb-cluster-maintain-time-check",
 *     riskLevel: 2,
 *     regionIdsScope: _default.then(_default => _default.regions?.[0]?.id),
 *     configRuleTriggerTypes: "ScheduledNotification",
 *     resourceTypesScopes: ["ACS::ADB::DBCluster"],
 *     ruleName: "governance-evaluation-adb-cluster-maintain-time-check",
 *     inputParameters: {
 *         maintainTimes: "02:00-04:00,06:00-08:00,12:00-13:00",
 *     },
 * });
 * const defaultCompliancePack = new alicloud.cfg.CompliancePack("default", {
 *     compliancePackName: name,
 *     description: "CloudGovernanceCenter evaluation",
 *     riskLevel: 2,
 *     configRuleIds: [
 *         {
 *             configRuleId: rule1.id,
 *         },
 *         {
 *             configRuleId: rule2.id,
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example-config-name"
 * default = alicloud.get_regions(current=True)
 * rule1 = alicloud.cfg.Rule("rule1",
 *     description=name,
 *     source_owner="ALIYUN",
 *     source_identifier="ram-user-ak-create-date-expired-check",
 *     risk_level=1,
 *     maximum_execution_frequency="TwentyFour_Hours",
 *     region_ids_scope=default.regions[0].id,
 *     config_rule_trigger_types="ScheduledNotification",
 *     resource_types_scopes=["ACS::RAM::User"],
 *     rule_name="ciscompliancecheck_ram-user-ak-create-date-expired-check",
 *     input_parameters={
 *         "days": "90",
 *     })
 * rule2 = alicloud.cfg.Rule("rule2",
 *     description=name,
 *     source_owner="ALIYUN",
 *     source_identifier="adb-cluster-maintain-time-check",
 *     risk_level=2,
 *     region_ids_scope=default.regions[0].id,
 *     config_rule_trigger_types="ScheduledNotification",
 *     resource_types_scopes=["ACS::ADB::DBCluster"],
 *     rule_name="governance-evaluation-adb-cluster-maintain-time-check",
 *     input_parameters={
 *         "maintainTimes": "02:00-04:00,06:00-08:00,12:00-13:00",
 *     })
 * default_compliance_pack = alicloud.cfg.CompliancePack("default",
 *     compliance_pack_name=name,
 *     description="CloudGovernanceCenter evaluation",
 *     risk_level=2,
 *     config_rule_ids=[
 *         {
 *             "config_rule_id": rule1.id,
 *         },
 *         {
 *             "config_rule_id": rule2.id,
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example-config-name";
 *     var @default = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var rule1 = new AliCloud.Cfg.Rule("rule1", new()
 *     {
 *         Description = name,
 *         SourceOwner = "ALIYUN",
 *         SourceIdentifier = "ram-user-ak-create-date-expired-check",
 *         RiskLevel = 1,
 *         MaximumExecutionFrequency = "TwentyFour_Hours",
 *         RegionIdsScope = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)),
 *         ConfigRuleTriggerTypes = "ScheduledNotification",
 *         ResourceTypesScopes = new[]
 *         {
 *             "ACS::RAM::User",
 *         },
 *         RuleName = "ciscompliancecheck_ram-user-ak-create-date-expired-check",
 *         InputParameters =
 *         {
 *             { "days", "90" },
 *         },
 *     });
 *     var rule2 = new AliCloud.Cfg.Rule("rule2", new()
 *     {
 *         Description = name,
 *         SourceOwner = "ALIYUN",
 *         SourceIdentifier = "adb-cluster-maintain-time-check",
 *         RiskLevel = 2,
 *         RegionIdsScope = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)),
 *         ConfigRuleTriggerTypes = "ScheduledNotification",
 *         ResourceTypesScopes = new[]
 *         {
 *             "ACS::ADB::DBCluster",
 *         },
 *         RuleName = "governance-evaluation-adb-cluster-maintain-time-check",
 *         InputParameters =
 *         {
 *             { "maintainTimes", "02:00-04:00,06:00-08:00,12:00-13:00" },
 *         },
 *     });
 *     var defaultCompliancePack = new AliCloud.Cfg.CompliancePack("default", new()
 *     {
 *         CompliancePackName = name,
 *         Description = "CloudGovernanceCenter evaluation",
 *         RiskLevel = 2,
 *         ConfigRuleIds = new[]
 *         {
 *             new AliCloud.Cfg.Inputs.CompliancePackConfigRuleIdArgs
 *             {
 *                 ConfigRuleId = rule1.Id,
 *             },
 *             new AliCloud.Cfg.Inputs.CompliancePackConfigRuleIdArgs
 *             {
 *                 ConfigRuleId = rule2.Id,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cfg"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example-config-name"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		rule1, err := cfg.NewRule(ctx, "rule1", &cfg.RuleArgs{
 * 			Description:               pulumi.String(name),
 * 			SourceOwner:               pulumi.String("ALIYUN"),
 * 			SourceIdentifier:          pulumi.String("ram-user-ak-create-date-expired-check"),
 * 			RiskLevel:                 pulumi.Int(1),
 * 			MaximumExecutionFrequency: pulumi.String("TwentyFour_Hours"),
 * 			RegionIdsScope:            pulumi.String(_default.Regions[0].Id),
 * 			ConfigRuleTriggerTypes:    pulumi.String("ScheduledNotification"),
 * 			ResourceTypesScopes: pulumi.StringArray{
 * 				pulumi.String("ACS::RAM::User"),
 * 			},
 * 			RuleName: pulumi.String("ciscompliancecheck_ram-user-ak-create-date-expired-check"),
 * 			InputParameters: pulumi.StringMap{
 * 				"days": pulumi.String("90"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		rule2, err := cfg.NewRule(ctx, "rule2", &cfg.RuleArgs{
 * 			Description:            pulumi.String(name),
 * 			SourceOwner:            pulumi.String("ALIYUN"),
 * 			SourceIdentifier:       pulumi.String("adb-cluster-maintain-time-check"),
 * 			RiskLevel:              pulumi.Int(2),
 * 			RegionIdsScope:         pulumi.String(_default.Regions[0].Id),
 * 			ConfigRuleTriggerTypes: pulumi.String("ScheduledNotification"),
 * 			ResourceTypesScopes: pulumi.StringArray{
 * 				pulumi.String("ACS::ADB::DBCluster"),
 * 			},
 * 			RuleName: pulumi.String("governance-evaluation-adb-cluster-maintain-time-check"),
 * 			InputParameters: pulumi.StringMap{
 * 				"maintainTimes": pulumi.String("02:00-04:00,06:00-08:00,12:00-13:00"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cfg.NewCompliancePack(ctx, "default", &cfg.CompliancePackArgs{
 * 			CompliancePackName: pulumi.String(name),
 * 			Description:        pulumi.String("CloudGovernanceCenter evaluation"),
 * 			RiskLevel:          pulumi.Int(2),
 * 			ConfigRuleIds: cfg.CompliancePackConfigRuleIdArray{
 * 				&cfg.CompliancePackConfigRuleIdArgs{
 * 					ConfigRuleId: rule1.ID(),
 * 				},
 * 				&cfg.CompliancePackConfigRuleIdArgs{
 * 					ConfigRuleId: rule2.ID(),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.cfg.Rule;
 * import com.pulumi.alicloud.cfg.RuleArgs;
 * import com.pulumi.alicloud.cfg.CompliancePack;
 * import com.pulumi.alicloud.cfg.CompliancePackArgs;
 * import com.pulumi.alicloud.cfg.inputs.CompliancePackConfigRuleIdArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example-config-name");
 *         final var default = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         var rule1 = new Rule("rule1", RuleArgs.builder()
 *             .description(name)
 *             .sourceOwner("ALIYUN")
 *             .sourceIdentifier("ram-user-ak-create-date-expired-check")
 *             .riskLevel(1)
 *             .maximumExecutionFrequency("TwentyFour_Hours")
 *             .regionIdsScope(default_.regions()[0].id())
 *             .configRuleTriggerTypes("ScheduledNotification")
 *             .resourceTypesScopes("ACS::RAM::User")
 *             .ruleName("ciscompliancecheck_ram-user-ak-create-date-expired-check")
 *             .inputParameters(Map.of("days", "90"))
 *             .build());
 *         var rule2 = new Rule("rule2", RuleArgs.builder()
 *             .description(name)
 *             .sourceOwner("ALIYUN")
 *             .sourceIdentifier("adb-cluster-maintain-time-check")
 *             .riskLevel(2)
 *             .regionIdsScope(default_.regions()[0].id())
 *             .configRuleTriggerTypes("ScheduledNotification")
 *             .resourceTypesScopes("ACS::ADB::DBCluster")
 *             .ruleName("governance-evaluation-adb-cluster-maintain-time-check")
 *             .inputParameters(Map.of("maintainTimes", "02:00-04:00,06:00-08:00,12:00-13:00"))
 *             .build());
 *         var defaultCompliancePack = new CompliancePack("defaultCompliancePack", CompliancePackArgs.builder()
 *             .compliancePackName(name)
 *             .description("CloudGovernanceCenter evaluation")
 *             .riskLevel("2")
 *             .configRuleIds(
 *                 CompliancePackConfigRuleIdArgs.builder()
 *                     .configRuleId(rule1.id())
 *                     .build(),
 *                 CompliancePackConfigRuleIdArgs.builder()
 *                     .configRuleId(rule2.id())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example-config-name
 * resources:
 *   rule1:
 *     type: alicloud:cfg:Rule
 *     properties:
 *       description: ${name}
 *       sourceOwner: ALIYUN
 *       sourceIdentifier: ram-user-ak-create-date-expired-check
 *       riskLevel: 1
 *       maximumExecutionFrequency: TwentyFour_Hours
 *       regionIdsScope: ${default.regions[0].id}
 *       configRuleTriggerTypes: ScheduledNotification
 *       resourceTypesScopes:
 *         - ACS::RAM::User
 *       ruleName: ciscompliancecheck_ram-user-ak-create-date-expired-check
 *       inputParameters:
 *         days: '90'
 *   rule2:
 *     type: alicloud:cfg:Rule
 *     properties:
 *       description: ${name}
 *       sourceOwner: ALIYUN
 *       sourceIdentifier: adb-cluster-maintain-time-check
 *       riskLevel: 2
 *       regionIdsScope: ${default.regions[0].id}
 *       configRuleTriggerTypes: ScheduledNotification
 *       resourceTypesScopes:
 *         - ACS::ADB::DBCluster
 *       ruleName: governance-evaluation-adb-cluster-maintain-time-check
 *       inputParameters:
 *         maintainTimes: 02:00-04:00,06:00-08:00,12:00-13:00
 *   defaultCompliancePack:
 *     type: alicloud:cfg:CompliancePack
 *     name: default
 *     properties:
 *       compliancePackName: ${name}
 *       description: CloudGovernanceCenter evaluation
 *       riskLevel: '2'
 *       configRuleIds:
 *         - configRuleId: ${rule1.id}
 *         - configRuleId: ${rule2.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Config Compliance Pack can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cfg/compliancePack:CompliancePack example <id>
 * ```
 * @property compliancePackName The Compliance Package Name. **NOTE:** From version 1.146.0, `compliance_pack_name` can be modified.
 * @property compliancePackTemplateId Compliance Package Template Id.
 * @property configRuleIds A list of Config Rule IDs. See `config_rule_ids` below.
 * @property configRules A list of Config Rules. See `config_rules` below. **NOTE:** Field `config_rules` has been deprecated from provider version 1.141.0. New field `config_rule_ids` instead.
 * @property description The Description of compliance pack.
 * @property riskLevel The Risk Level. Valid values:
 */
public data class CompliancePackArgs(
    public val compliancePackName: Output<String>? = null,
    public val compliancePackTemplateId: Output<String>? = null,
    public val configRuleIds: Output<List<CompliancePackConfigRuleIdArgs>>? = null,
    @Deprecated(
        message = """
  Field `config_rules` has been deprecated from provider version 1.141.0. New field
      `config_rule_ids` instead.
  """,
    )
    public val configRules: Output<List<CompliancePackConfigRuleArgs>>? = null,
    public val description: Output<String>? = null,
    public val riskLevel: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cfg.CompliancePackArgs> {
    override fun toJava(): com.pulumi.alicloud.cfg.CompliancePackArgs =
        com.pulumi.alicloud.cfg.CompliancePackArgs.builder()
            .compliancePackName(compliancePackName?.applyValue({ args0 -> args0 }))
            .compliancePackTemplateId(compliancePackTemplateId?.applyValue({ args0 -> args0 }))
            .configRuleIds(
                configRuleIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .configRules(
                configRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .riskLevel(riskLevel?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CompliancePackArgs].
 */
@PulumiTagMarker
public class CompliancePackArgsBuilder internal constructor() {
    private var compliancePackName: Output<String>? = null

    private var compliancePackTemplateId: Output<String>? = null

    private var configRuleIds: Output<List<CompliancePackConfigRuleIdArgs>>? = null

    private var configRules: Output<List<CompliancePackConfigRuleArgs>>? = null

    private var description: Output<String>? = null

    private var riskLevel: Output<Int>? = null

    /**
     * @param value The Compliance Package Name. **NOTE:** From version 1.146.0, `compliance_pack_name` can be modified.
     */
    @JvmName("gddwsnktcmrglfkf")
    public suspend fun compliancePackName(`value`: Output<String>) {
        this.compliancePackName = value
    }

    /**
     * @param value Compliance Package Template Id.
     */
    @JvmName("rcfqkxtnyrqhfcga")
    public suspend fun compliancePackTemplateId(`value`: Output<String>) {
        this.compliancePackTemplateId = value
    }

    /**
     * @param value A list of Config Rule IDs. See `config_rule_ids` below.
     */
    @JvmName("ynpbqllysjiqiywr")
    public suspend fun configRuleIds(`value`: Output<List<CompliancePackConfigRuleIdArgs>>) {
        this.configRuleIds = value
    }

    @JvmName("gjvkbpxvfvgwlurv")
    public suspend fun configRuleIds(vararg values: Output<CompliancePackConfigRuleIdArgs>) {
        this.configRuleIds = Output.all(values.asList())
    }

    /**
     * @param values A list of Config Rule IDs. See `config_rule_ids` below.
     */
    @JvmName("adcrofxmyjdprxgh")
    public suspend fun configRuleIds(values: List<Output<CompliancePackConfigRuleIdArgs>>) {
        this.configRuleIds = Output.all(values)
    }

    /**
     * @param value A list of Config Rules. See `config_rules` below. **NOTE:** Field `config_rules` has been deprecated from provider version 1.141.0. New field `config_rule_ids` instead.
     */
    @Deprecated(
        message = """
  Field `config_rules` has been deprecated from provider version 1.141.0. New field
      `config_rule_ids` instead.
  """,
    )
    @JvmName("cbduorifgtrhecci")
    public suspend fun configRules(`value`: Output<List<CompliancePackConfigRuleArgs>>) {
        this.configRules = value
    }

    @JvmName("pkdvvbhcnecwqohw")
    public suspend fun configRules(vararg values: Output<CompliancePackConfigRuleArgs>) {
        this.configRules = Output.all(values.asList())
    }

    /**
     * @param values A list of Config Rules. See `config_rules` below. **NOTE:** Field `config_rules` has been deprecated from provider version 1.141.0. New field `config_rule_ids` instead.
     */
    @Deprecated(
        message = """
  Field `config_rules` has been deprecated from provider version 1.141.0. New field
      `config_rule_ids` instead.
  """,
    )
    @JvmName("ihkftetpmknuofgf")
    public suspend fun configRules(values: List<Output<CompliancePackConfigRuleArgs>>) {
        this.configRules = Output.all(values)
    }

    /**
     * @param value The Description of compliance pack.
     */
    @JvmName("mwmcdjjyljevnaao")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The Risk Level. Valid values:
     */
    @JvmName("jsluplikwdaexxmk")
    public suspend fun riskLevel(`value`: Output<Int>) {
        this.riskLevel = value
    }

    /**
     * @param value The Compliance Package Name. **NOTE:** From version 1.146.0, `compliance_pack_name` can be modified.
     */
    @JvmName("rorqkjtnhssuqofn")
    public suspend fun compliancePackName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compliancePackName = mapped
    }

    /**
     * @param value Compliance Package Template Id.
     */
    @JvmName("tmawoifbhmdquhqc")
    public suspend fun compliancePackTemplateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compliancePackTemplateId = mapped
    }

    /**
     * @param value A list of Config Rule IDs. See `config_rule_ids` below.
     */
    @JvmName("nogfqsvxcxwnbowl")
    public suspend fun configRuleIds(`value`: List<CompliancePackConfigRuleIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configRuleIds = mapped
    }

    /**
     * @param argument A list of Config Rule IDs. See `config_rule_ids` below.
     */
    @JvmName("qnfpbutoakwragjb")
    public suspend fun configRuleIds(argument: List<suspend CompliancePackConfigRuleIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CompliancePackConfigRuleIdArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configRuleIds = mapped
    }

    /**
     * @param argument A list of Config Rule IDs. See `config_rule_ids` below.
     */
    @JvmName("pmubqnimuwuoitwj")
    public suspend fun configRuleIds(vararg argument: suspend CompliancePackConfigRuleIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CompliancePackConfigRuleIdArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configRuleIds = mapped
    }

    /**
     * @param argument A list of Config Rule IDs. See `config_rule_ids` below.
     */
    @JvmName("xnxoknydpbndajba")
    public suspend fun configRuleIds(argument: suspend CompliancePackConfigRuleIdArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CompliancePackConfigRuleIdArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.configRuleIds = mapped
    }

    /**
     * @param values A list of Config Rule IDs. See `config_rule_ids` below.
     */
    @JvmName("hvjqwmvcswpuaptp")
    public suspend fun configRuleIds(vararg values: CompliancePackConfigRuleIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configRuleIds = mapped
    }

    /**
     * @param value A list of Config Rules. See `config_rules` below. **NOTE:** Field `config_rules` has been deprecated from provider version 1.141.0. New field `config_rule_ids` instead.
     */
    @Deprecated(
        message = """
  Field `config_rules` has been deprecated from provider version 1.141.0. New field
      `config_rule_ids` instead.
  """,
    )
    @JvmName("dhkjilncttkseheb")
    public suspend fun configRules(`value`: List<CompliancePackConfigRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configRules = mapped
    }

    /**
     * @param argument A list of Config Rules. See `config_rules` below. **NOTE:** Field `config_rules` has been deprecated from provider version 1.141.0. New field `config_rule_ids` instead.
     */
    @Deprecated(
        message = """
  Field `config_rules` has been deprecated from provider version 1.141.0. New field
      `config_rule_ids` instead.
  """,
    )
    @JvmName("qvvbnjuxxibwvmsc")
    public suspend fun configRules(argument: List<suspend CompliancePackConfigRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CompliancePackConfigRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configRules = mapped
    }

    /**
     * @param argument A list of Config Rules. See `config_rules` below. **NOTE:** Field `config_rules` has been deprecated from provider version 1.141.0. New field `config_rule_ids` instead.
     */
    @Deprecated(
        message = """
  Field `config_rules` has been deprecated from provider version 1.141.0. New field
      `config_rule_ids` instead.
  """,
    )
    @JvmName("grbxotaehnyvdfft")
    public suspend fun configRules(vararg argument: suspend CompliancePackConfigRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CompliancePackConfigRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configRules = mapped
    }

    /**
     * @param argument A list of Config Rules. See `config_rules` below. **NOTE:** Field `config_rules` has been deprecated from provider version 1.141.0. New field `config_rule_ids` instead.
     */
    @Deprecated(
        message = """
  Field `config_rules` has been deprecated from provider version 1.141.0. New field
      `config_rule_ids` instead.
  """,
    )
    @JvmName("wifnsfieetvmgfmm")
    public suspend fun configRules(argument: suspend CompliancePackConfigRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CompliancePackConfigRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.configRules = mapped
    }

    /**
     * @param values A list of Config Rules. See `config_rules` below. **NOTE:** Field `config_rules` has been deprecated from provider version 1.141.0. New field `config_rule_ids` instead.
     */
    @Deprecated(
        message = """
  Field `config_rules` has been deprecated from provider version 1.141.0. New field
      `config_rule_ids` instead.
  """,
    )
    @JvmName("ghanwgrahaledpoc")
    public suspend fun configRules(vararg values: CompliancePackConfigRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configRules = mapped
    }

    /**
     * @param value The Description of compliance pack.
     */
    @JvmName("loodkbileerkcssf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The Risk Level. Valid values:
     */
    @JvmName("qlugjtxvvdribabe")
    public suspend fun riskLevel(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.riskLevel = mapped
    }

    internal fun build(): CompliancePackArgs = CompliancePackArgs(
        compliancePackName = compliancePackName,
        compliancePackTemplateId = compliancePackTemplateId,
        configRuleIds = configRuleIds,
        configRules = configRules,
        description = description,
        riskLevel = riskLevel,
    )
}
