@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ConfigurationRecorder].
 */
@PulumiTagMarker
public class ConfigurationRecorderResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConfigurationRecorderArgs = ConfigurationRecorderArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConfigurationRecorderArgsBuilder.() -> Unit) {
        val builder = ConfigurationRecorderArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ConfigurationRecorder {
        val builtJavaResource = com.pulumi.alicloud.cfg.ConfigurationRecorder(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ConfigurationRecorder(builtJavaResource)
    }
}

/**
 * Provides a Alicloud Config Configuration Recorder resource. Cloud Config is a specialized service for evaluating resources. Cloud Config tracks configuration changes of your resources and evaluates configuration compliance. Cloud Config can help you evaluate numerous resources and maintain the continuous compliance of your cloud infrastructure.
 * For information about Alicloud Config Configuration Recorder and how to use it, see [What is Configuration Recorder&#46;](https://www.alibabacloud.com/help/en/cloud-config/latest/startconfigurationrecorder)
 * > **NOTE:** Available since v1.99.0.
 * > **NOTE:** The Cloud Config region only support `cn-shanghai` and `ap-southeast-1`.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.cfg.ConfigurationRecorder("example", {resourceTypes: [
 *     "ACS::ECS::Instance",
 *     "ACS::ECS::Disk",
 * ]});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.cfg.ConfigurationRecorder("example", resource_types=[
 *     "ACS::ECS::Instance",
 *     "ACS::ECS::Disk",
 * ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Cfg.ConfigurationRecorder("example", new()
 *     {
 *         ResourceTypes = new[]
 *         {
 *             "ACS::ECS::Instance",
 *             "ACS::ECS::Disk",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cfg"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cfg.NewConfigurationRecorder(ctx, "example", &cfg.ConfigurationRecorderArgs{
 * 			ResourceTypes: pulumi.StringArray{
 * 				pulumi.String("ACS::ECS::Instance"),
 * 				pulumi.String("ACS::ECS::Disk"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cfg.ConfigurationRecorder;
 * import com.pulumi.alicloud.cfg.ConfigurationRecorderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ConfigurationRecorder("example", ConfigurationRecorderArgs.builder()
 *             .resourceTypes(
 *                 "ACS::ECS::Instance",
 *                 "ACS::ECS::Disk")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:cfg:ConfigurationRecorder
 *     properties:
 *       resourceTypes:
 *         - ACS::ECS::Instance
 *         - ACS::ECS::Disk
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Alicloud Config Configuration Recorder can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cfg/configurationRecorder:ConfigurationRecorder example 122378463********
 * ```
 */
public class ConfigurationRecorder internal constructor(
    override val javaResource: com.pulumi.alicloud.cfg.ConfigurationRecorder,
) : KotlinCustomResource(javaResource, ConfigurationRecorderMapper) {
    /**
     * Whether to use the enterprise version configuration audit. Valid values: `true` and `false`. Default value `false`. For enterprise accounts, We recommend you to use the resource alicloud_config_aggregator.
     */
    public val enterpriseEdition: Output<Boolean>
        get() = javaResource.enterpriseEdition().applyValue({ args0 -> args0 })

    /**
     * Enterprise version configuration audit enabled status. Values: `REGISTRABLE`: Not enabled, `BUILDING`: Building and `REGISTERED`: Enabled.
     */
    public val organizationEnableStatus: Output<String>
        get() = javaResource.organizationEnableStatus().applyValue({ args0 -> args0 })

    /**
     * The ID of the Enterprise management account.
     */
    public val organizationMasterId: Output<Int>
        get() = javaResource.organizationMasterId().applyValue({ args0 -> args0 })

    /**
     * A list of resource types to be monitored. [Resource types that support Cloud Config&#46;](https://www.alibabacloud.com/help/en/doc-detail/127411.htm)
     * * If you use an ordinary account, the `resource_types` supports the update operation after the process of creation is completed.
     * * If you use an enterprise account, the `resource_types` does not support updating.
     */
    public val resourceTypes: Output<List<String>>
        get() = javaResource.resourceTypes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Status of resource monitoring. Values: `REGISTRABLE`: Not registered, `BUILDING`: Under construction, `REGISTERED`: Registered and `REBUILDING`: Rebuilding.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object ConfigurationRecorderMapper : ResourceMapper<ConfigurationRecorder> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cfg.ConfigurationRecorder::class == javaResource::class

    override fun map(javaResource: Resource): ConfigurationRecorder =
        ConfigurationRecorder(javaResource as com.pulumi.alicloud.cfg.ConfigurationRecorder)
}

/**
 * @see [ConfigurationRecorder].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConfigurationRecorder].
 */
public suspend fun configurationRecorder(
    name: String,
    block: suspend ConfigurationRecorderResourceBuilder.() -> Unit,
): ConfigurationRecorder {
    val builder = ConfigurationRecorderResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConfigurationRecorder].
 * @param name The _unique_ name of the resulting resource.
 */
public fun configurationRecorder(name: String): ConfigurationRecorder {
    val builder = ConfigurationRecorderResourceBuilder()
    builder.name(name)
    return builder.build()
}
