@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin

import com.pulumi.alicloud.cfg.ConfigurationRecorderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Alicloud Config Configuration Recorder resource. Cloud Config is a specialized service for evaluating resources. Cloud Config tracks configuration changes of your resources and evaluates configuration compliance. Cloud Config can help you evaluate numerous resources and maintain the continuous compliance of your cloud infrastructure.
 * For information about Alicloud Config Configuration Recorder and how to use it, see [What is Configuration Recorder&#46;](https://www.alibabacloud.com/help/en/cloud-config/latest/startconfigurationrecorder)
 * > **NOTE:** Available since v1.99.0.
 * > **NOTE:** The Cloud Config region only support `cn-shanghai` and `ap-southeast-1`.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.cfg.ConfigurationRecorder("example", {resourceTypes: [
 *     "ACS::ECS::Instance",
 *     "ACS::ECS::Disk",
 * ]});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.cfg.ConfigurationRecorder("example", resource_types=[
 *     "ACS::ECS::Instance",
 *     "ACS::ECS::Disk",
 * ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Cfg.ConfigurationRecorder("example", new()
 *     {
 *         ResourceTypes = new[]
 *         {
 *             "ACS::ECS::Instance",
 *             "ACS::ECS::Disk",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cfg"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cfg.NewConfigurationRecorder(ctx, "example", &cfg.ConfigurationRecorderArgs{
 * 			ResourceTypes: pulumi.StringArray{
 * 				pulumi.String("ACS::ECS::Instance"),
 * 				pulumi.String("ACS::ECS::Disk"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cfg.ConfigurationRecorder;
 * import com.pulumi.alicloud.cfg.ConfigurationRecorderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ConfigurationRecorder("example", ConfigurationRecorderArgs.builder()
 *             .resourceTypes(
 *                 "ACS::ECS::Instance",
 *                 "ACS::ECS::Disk")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:cfg:ConfigurationRecorder
 *     properties:
 *       resourceTypes:
 *         - ACS::ECS::Instance
 *         - ACS::ECS::Disk
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Alicloud Config Configuration Recorder can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cfg/configurationRecorder:ConfigurationRecorder example 122378463********
 * ```
 * @property enterpriseEdition Whether to use the enterprise version configuration audit. Valid values: `true` and `false`. Default value `false`. For enterprise accounts, We recommend you to use the resource alicloud_config_aggregator.
 * @property resourceTypes A list of resource types to be monitored. [Resource types that support Cloud Config&#46;](https://www.alibabacloud.com/help/en/doc-detail/127411.htm)
 * * If you use an ordinary account, the `resource_types` supports the update operation after the process of creation is completed.
 * * If you use an enterprise account, the `resource_types` does not support updating.
 */
public data class ConfigurationRecorderArgs(
    public val enterpriseEdition: Output<Boolean>? = null,
    public val resourceTypes: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cfg.ConfigurationRecorderArgs> {
    override fun toJava(): com.pulumi.alicloud.cfg.ConfigurationRecorderArgs =
        com.pulumi.alicloud.cfg.ConfigurationRecorderArgs.builder()
            .enterpriseEdition(enterpriseEdition?.applyValue({ args0 -> args0 }))
            .resourceTypes(resourceTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ConfigurationRecorderArgs].
 */
@PulumiTagMarker
public class ConfigurationRecorderArgsBuilder internal constructor() {
    private var enterpriseEdition: Output<Boolean>? = null

    private var resourceTypes: Output<List<String>>? = null

    /**
     * @param value Whether to use the enterprise version configuration audit. Valid values: `true` and `false`. Default value `false`. For enterprise accounts, We recommend you to use the resource alicloud_config_aggregator.
     */
    @JvmName("brwtufcekbadsdnd")
    public suspend fun enterpriseEdition(`value`: Output<Boolean>) {
        this.enterpriseEdition = value
    }

    /**
     * @param value A list of resource types to be monitored. [Resource types that support Cloud Config&#46;](https://www.alibabacloud.com/help/en/doc-detail/127411.htm)
     * * If you use an ordinary account, the `resource_types` supports the update operation after the process of creation is completed.
     * * If you use an enterprise account, the `resource_types` does not support updating.
     */
    @JvmName("downprcvvdasprsk")
    public suspend fun resourceTypes(`value`: Output<List<String>>) {
        this.resourceTypes = value
    }

    @JvmName("dkbaqshcnmfnxwuu")
    public suspend fun resourceTypes(vararg values: Output<String>) {
        this.resourceTypes = Output.all(values.asList())
    }

    /**
     * @param values A list of resource types to be monitored. [Resource types that support Cloud Config&#46;](https://www.alibabacloud.com/help/en/doc-detail/127411.htm)
     * * If you use an ordinary account, the `resource_types` supports the update operation after the process of creation is completed.
     * * If you use an enterprise account, the `resource_types` does not support updating.
     */
    @JvmName("hmbpteuaenwgnitk")
    public suspend fun resourceTypes(values: List<Output<String>>) {
        this.resourceTypes = Output.all(values)
    }

    /**
     * @param value Whether to use the enterprise version configuration audit. Valid values: `true` and `false`. Default value `false`. For enterprise accounts, We recommend you to use the resource alicloud_config_aggregator.
     */
    @JvmName("guhyvpecqsunqpgu")
    public suspend fun enterpriseEdition(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enterpriseEdition = mapped
    }

    /**
     * @param value A list of resource types to be monitored. [Resource types that support Cloud Config&#46;](https://www.alibabacloud.com/help/en/doc-detail/127411.htm)
     * * If you use an ordinary account, the `resource_types` supports the update operation after the process of creation is completed.
     * * If you use an enterprise account, the `resource_types` does not support updating.
     */
    @JvmName("aubagthyxmggviui")
    public suspend fun resourceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTypes = mapped
    }

    /**
     * @param values A list of resource types to be monitored. [Resource types that support Cloud Config&#46;](https://www.alibabacloud.com/help/en/doc-detail/127411.htm)
     * * If you use an ordinary account, the `resource_types` supports the update operation after the process of creation is completed.
     * * If you use an enterprise account, the `resource_types` does not support updating.
     */
    @JvmName("mqptogyfxlwecqdl")
    public suspend fun resourceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTypes = mapped
    }

    internal fun build(): ConfigurationRecorderArgs = ConfigurationRecorderArgs(
        enterpriseEdition = enterpriseEdition,
        resourceTypes = resourceTypes,
    )
}
