@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Delivery].
 */
@PulumiTagMarker
public class DeliveryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DeliveryArgs = DeliveryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DeliveryArgsBuilder.() -> Unit) {
        val builder = DeliveryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Delivery {
        val builtJavaResource = com.pulumi.alicloud.cfg.Delivery(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Delivery(builtJavaResource)
    }
}

/**
 * Provides a Config Delivery resource.
 * Delivery channel of current account.
 * For information about Config Delivery and how to use it, see [What is Delivery](https://www.alibabacloud.com/help/en/cloud-config/latest/api-config-2020-09-07-createconfigdeliverychannel).
 * > **NOTE:** Available since v1.171.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example-sls";
 * const this = alicloud.getAccount({});
 * const thisGetRegions = alicloud.getRegions({
 *     current: true,
 * });
 * const _default = new alicloud.log.Project("default", {projectName: name});
 * const defaultStore = new alicloud.log.Store("default", {
 *     logstoreName: name,
 *     projectName: _default.projectName,
 * });
 * const defaultDelivery = new alicloud.cfg.Delivery("default", {
 *     configurationItemChangeNotification: true,
 *     nonCompliantNotification: true,
 *     deliveryChannelName: name,
 *     deliveryChannelTargetArn: pulumi.all([thisGetRegions, _this, _default&#46;projectName, defaultStore&#46;logstoreName])&#46;apply(([thisGetRegions, _this, projectName, logstoreName]) => `acs:log:${thisGetRegions&#46;ids?&#46;[0]}:${_this.id}:project/${projectName}/logstore/${logstoreName}`),
 *     deliveryChannelType: "SLS",
 *     description: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example-sls"
 * this = alicloud.get_account()
 * this_get_regions = alicloud.get_regions(current=True)
 * default = alicloud.log.Project("default", project_name=name)
 * default_store = alicloud.log.Store("default",
 *     logstore_name=name,
 *     project_name=default.project_name)
 * default_delivery = alicloud.cfg.Delivery("default",
 *     configuration_item_change_notification=True,
 *     non_compliant_notification=True,
 *     delivery_channel_name=name,
 *     delivery_channel_target_arn=pulumi.Output.all(
 *         project_name=default.project_name,
 *         logstore_name=default_store.logstore_name
 * ).apply(lambda resolved_outputs: f"acs:log:{this_get_regions.ids[0]}:{this&#46;id}:project/{resolved_outputs['project_name']}/logstore/{resolved_outputs['logstore_name']}")
 * ,
 *     delivery_channel_type="SLS",
 *     description=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example-sls";
 *     var @this = AliCloud.GetAccount.Invoke();
 *     var thisGetRegions = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var @default = new AliCloud.Log.Project("default", new()
 *     {
 *         ProjectName = name,
 *     });
 *     var defaultStore = new AliCloud.Log.Store("default", new()
 *     {
 *         LogstoreName = name,
 *         ProjectName = @default.ProjectName,
 *     });
 *     var defaultDelivery = new AliCloud.Cfg.Delivery("default", new()
 *     {
 *         ConfigurationItemChangeNotification = true,
 *         NonCompliantNotification = true,
 *         DeliveryChannelName = name,
 *         DeliveryChannelTargetArn = Output.Tuple(thisGetRegions, @this, @default.ProjectName, defaultStore.LogstoreName).Apply(values =>
 *         {
 *             var thisGetRegions = values.Item1;
 *             var @this = values.Item2;
 *             var projectName = values.Item3;
 *             var logstoreName = values.Item4;
 *             return $"acs:log:{thisGetRegions.Apply(getRegionsResult => getRegionsResult.Ids[0])}:{@this.Apply(getAccountResult => getAccountResult.Id)}:project/{projectName}/logstore/{logstoreName}";
 *         }),
 *         DeliveryChannelType = "SLS",
 *         Description = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cfg"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example-sls"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		this, err := alicloud.GetAccount(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		thisGetRegions, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = log.NewProject(ctx, "default", &log.ProjectArgs{
 * 			ProjectName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultStore, err := log.NewStore(ctx, "default", &log.StoreArgs{
 * 			LogstoreName: pulumi.String(name),
 * 			ProjectName:  _default.ProjectName,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cfg.NewDelivery(ctx, "default", &cfg.DeliveryArgs{
 * 			ConfigurationItemChangeNotification: pulumi.Bool(true),
 * 			NonCompliantNotification:            pulumi.Bool(true),
 * 			DeliveryChannelName:                 pulumi.String(name),
 * 			DeliveryChannelTargetArn: pulumi.All(_default.ProjectName, defaultStore.LogstoreName).ApplyT(func(_args []interface{}) (string, error) {
 * 				projectName := _args[0].(string)
 * 				logstoreName := _args[1].(string)
 * 				return fmt.Sprintf("acs:log:%v:%v:project/%v/logstore/%v", thisGetRegions.Ids[0], this.Id, projectName, logstoreName), nil
 * 			}).(pulumi.StringOutput),
 * 			DeliveryChannelType: pulumi.String("SLS"),
 * 			Description:         pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.log.Project;
 * import com.pulumi.alicloud.log.ProjectArgs;
 * import com.pulumi.alicloud.log.Store;
 * import com.pulumi.alicloud.log.StoreArgs;
 * import com.pulumi.alicloud.cfg.Delivery;
 * import com.pulumi.alicloud.cfg.DeliveryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example-sls");
 *         final var this = AlicloudFunctions.getAccount();
 *         final var thisGetRegions = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         var default_ = new Project("default", ProjectArgs.builder()
 *             .projectName(name)
 *             .build());
 *         var defaultStore = new Store("defaultStore", StoreArgs.builder()
 *             .logstoreName(name)
 *             .projectName(default_.projectName())
 *             .build());
 *         var defaultDelivery = new Delivery("defaultDelivery", DeliveryArgs.builder()
 *             .configurationItemChangeNotification(true)
 *             .nonCompliantNotification(true)
 *             .deliveryChannelName(name)
 *             .deliveryChannelTargetArn(Output.tuple(default_.projectName(), defaultStore.logstoreName()).applyValue(values -> {
 *                 var projectName = values.t1;
 *                 var logstoreName = values.t2;
 *                 return String.format("acs:log:%s:%s:project/%s/logstore/%s", thisGetRegions.applyValue(getRegionsResult -> getRegionsResult.ids()[0]),this_.id(),projectName,logstoreName);
 *             }))
 *             .deliveryChannelType("SLS")
 *             .description(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example-sls
 * resources:
 *   default:
 *     type: alicloud:log:Project
 *     properties:
 *       projectName: ${name}
 *   defaultStore:
 *     type: alicloud:log:Store
 *     name: default
 *     properties:
 *       logstoreName: ${name}
 *       projectName: ${default.projectName}
 *   defaultDelivery:
 *     type: alicloud:cfg:Delivery
 *     name: default
 *     properties:
 *       configurationItemChangeNotification: true
 *       nonCompliantNotification: true
 *       deliveryChannelName: ${name}
 *       deliveryChannelTargetArn: acs:log:${thisGetRegions.ids[0]}:${this.id}:project/${default.projectName}/logstore/${defaultStore.logstoreName}
 *       deliveryChannelType: SLS
 *       description: ${name}
 * variables:
 *   this:
 *     fn::invoke:
 *       Function: alicloud:getAccount
 *       Arguments: {}
 *   thisGetRegions:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Config Delivery can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cfg/delivery:Delivery example <id>
 * ```
 */
public class Delivery internal constructor(
    override val javaResource: com.pulumi.alicloud.cfg.Delivery,
) : KotlinCustomResource(javaResource, DeliveryMapper) {
    /**
     * Indicates whether the specified destination receives resource change logs. If the value of this parameter is true, Cloud Config delivers the resource change logs to OSS, Log Service, or MNS when the configurations of the resources change. Valid values:
     * - true: The specified destination receives resource change logs.
     * - false: The specified destination does not receive resource change logs.
     */
    public val configurationItemChangeNotification: Output<Boolean>?
        get() = javaResource.configurationItemChangeNotification().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * Indicates whether the specified destination receives scheduled resource snapshots. Cloud Config delivers scheduled resource snapshots at 04:00Z and 16:00Z to OSS, MNS, or Log Service every day. The time is displayed in UTC. Valid values:
     * - true: The specified destination receives scheduled resource snapshots.
     * - false: The specified destination does not receive scheduled resource snapshots.
     */
    public val configurationSnapshot: Output<Boolean>?
        get() = javaResource.configurationSnapshot().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The rule that is attached to the delivery channel.
     * This parameter is available when you deliver data of all types to MNS or deliver snapshots to Log Service.
     * If you specify the risk level or resource types for subscription events, this is as follows:
     * The lowest risk level of the events to which you want to subscribe is in the following format: {"filterType":"RuleRiskLevel","value":"1","multiple":false}, The value field indicates the risk level of the events to which you want to subscribe. Valid values: 1, 2, and 3. The value 1 indicates the high risk level, the value 2 indicates the medium risk level, and the value 3 indicates the low risk level.
     * The setting of the resource types of the events to which you want to subscribe is in the following format: {"filterType":"ResourceType","values":["ACS::ACK::Cluster","ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage"],"multiple":true}, The values field indicates the resource types of the events to which you want to subscribe. The value of the field is a JSON array.
     * Examples:[{"filterType":"ResourceType","values":["ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage","ACS::CDN::Domain","ACS::CEN::CenBandwidthPackage","ACS::CEN::CenInstance","ACS::CEN::Flowlog","ACS::DdosCoo::Instance"],"multiple":true}].
     */
    public val deliveryChannelCondition: Output<String>?
        get() = javaResource.deliveryChannelCondition().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the delivery channel.
     */
    public val deliveryChannelName: Output<String>?
        get() = javaResource.deliveryChannelName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the delivery destination.
     * - If the value of the DeliveryChannelType parameter is OSS, the value of this parameter is the ARN of the destination OSS bucket.
     * - If the value of the DeliveryChannelType parameter is MNS, the value of this parameter is the ARN of the destination MNS topic.
     * - If the value of the DeliveryChannelType parameter is SLS, the value of this parameter is the ARN of the destination Log Service Logstore.
     */
    public val deliveryChannelTargetArn: Output<String>
        get() = javaResource.deliveryChannelTargetArn().applyValue({ args0 -> args0 })

    /**
     * The type of the delivery channel. Valid values:
     * - OSS: Object Storage Service (OSS)
     * - MNS: Message Service (MNS)
     * - SLS: Log Service
     */
    public val deliveryChannelType: Output<String>
        get() = javaResource.deliveryChannelType().applyValue({ args0 -> args0 })

    /**
     * The description of the delivery channel.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether the specified destination receives resource non-compliance events. If the value of this parameter is true, Cloud Config delivers resource non-compliance events to Log Service or MNS when resources are evaluated as non-compliant. Valid values:
     * - true: The specified destination receives resource non-compliance events.
     * - false: The specified destination does not receive resource non-compliance events.
     */
    public val nonCompliantNotification: Output<Boolean>?
        get() = javaResource.nonCompliantNotification().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The oss ARN of the delivery channel when the value data oversized limit.  The value must be in one of the following formats:  acs:oss:{RegionId}:{Aliuid}:{bucketName} if your delivery destination is an Object Storage Service (OSS) bucket.
     */
    public val oversizedDataOssTargetArn: Output<String>?
        get() = javaResource.oversizedDataOssTargetArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the delivery channel. Valid values:
     * - 0: The delivery channel is disabled.
     * - 1: The delivery channel is enabled.
     */
    public val status: Output<Int>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object DeliveryMapper : ResourceMapper<Delivery> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cfg.Delivery::class == javaResource::class

    override fun map(javaResource: Resource): Delivery = Delivery(
        javaResource as
            com.pulumi.alicloud.cfg.Delivery,
    )
}

/**
 * @see [Delivery].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Delivery].
 */
public suspend fun delivery(name: String, block: suspend DeliveryResourceBuilder.() -> Unit): Delivery {
    val builder = DeliveryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Delivery].
 * @param name The _unique_ name of the resulting resource.
 */
public fun delivery(name: String): Delivery {
    val builder = DeliveryResourceBuilder()
    builder.name(name)
    return builder.build()
}
