@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DeliveryChannel].
 */
@PulumiTagMarker
public class DeliveryChannelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DeliveryChannelArgs = DeliveryChannelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DeliveryChannelArgsBuilder.() -> Unit) {
        val builder = DeliveryChannelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DeliveryChannel {
        val builtJavaResource = com.pulumi.alicloud.cfg.DeliveryChannel(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DeliveryChannel(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * ## Import
 * Alicloud Config Delivery Channel can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cfg/deliveryChannel:DeliveryChannel example cdc-49a2ad756057********
 * ```
 */
public class DeliveryChannel internal constructor(
    override val javaResource: com.pulumi.alicloud.cfg.DeliveryChannel,
) : KotlinCustomResource(javaResource, DeliveryChannelMapper) {
    /**
     * The Alibaba Cloud Resource Name (ARN) of the role to be assumed by the delivery method.
     */
    public val deliveryChannelAssumeRoleArn: Output<String>
        get() = javaResource.deliveryChannelAssumeRoleArn().applyValue({ args0 -> args0 })

    /**
     * The rule attached to the delivery method. This parameter is applicable only to delivery methods of the MNS type. Please refer to api [PutDeliveryChannel](https://www.alibabacloud.com/help/en/doc-detail/174253.htm) for example format.
     */
    public val deliveryChannelCondition: Output<String>
        get() = javaResource.deliveryChannelCondition().applyValue({ args0 -> args0 })

    /**
     * The name of the delivery channel.
     */
    public val deliveryChannelName: Output<String>
        get() = javaResource.deliveryChannelName().applyValue({ args0 -> args0 })

    /**
     * The ARN of the delivery destination. This parameter is required when you create a delivery method. The value must be in one of the following formats:
     * - `acs:oss:{RegionId}:{Aliuid}:{bucketName}`: if your delivery destination is an Object Storage Service (OSS) bucket.
     * - `acs:mns:{RegionId}:{Aliuid}:/topics/{topicName}`: if your delivery destination is a Message Service (MNS) topic.
     * - `acs:log:{RegionId}:{Aliuid}:project/{projectName}/logstore/{logstoreName}`: if your delivery destination is a Log Service Logstore.
     */
    public val deliveryChannelTargetArn: Output<String>
        get() = javaResource.deliveryChannelTargetArn().applyValue({ args0 -> args0 })

    /**
     * The type of the delivery method. This parameter is required when you create a delivery method. Valid values: `OSS`: Object Storage, `MNS`: Message Service, `SLS`: Log Service.
     */
    public val deliveryChannelType: Output<String>
        get() = javaResource.deliveryChannelType().applyValue({ args0 -> args0 })

    /**
     * The description of the delivery method.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The status of the delivery method. Valid values: `0`: The delivery method is disabled., `1`: The delivery destination is enabled. This is the default value.
     */
    public val status: Output<Int>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object DeliveryChannelMapper : ResourceMapper<DeliveryChannel> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cfg.DeliveryChannel::class == javaResource::class

    override fun map(javaResource: Resource): DeliveryChannel = DeliveryChannel(
        javaResource as
            com.pulumi.alicloud.cfg.DeliveryChannel,
    )
}

/**
 * @see [DeliveryChannel].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DeliveryChannel].
 */
public suspend fun deliveryChannel(
    name: String,
    block: suspend DeliveryChannelResourceBuilder.() -> Unit,
): DeliveryChannel {
    val builder = DeliveryChannelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DeliveryChannel].
 * @param name The _unique_ name of the resulting resource.
 */
public fun deliveryChannel(name: String): DeliveryChannel {
    val builder = DeliveryChannelResourceBuilder()
    builder.name(name)
    return builder.build()
}
