@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin

import com.pulumi.alicloud.cfg.DeliveryChannelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * ## Import
 * Alicloud Config Delivery Channel can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cfg/deliveryChannel:DeliveryChannel example cdc-49a2ad756057********
 * ```
 * @property deliveryChannelAssumeRoleArn The Alibaba Cloud Resource Name (ARN) of the role to be assumed by the delivery method.
 * @property deliveryChannelCondition The rule attached to the delivery method. This parameter is applicable only to delivery methods of the MNS type. Please refer to api [PutDeliveryChannel](https://www.alibabacloud.com/help/en/doc-detail/174253.htm) for example format.
 * @property deliveryChannelName The name of the delivery channel.
 * @property deliveryChannelTargetArn The ARN of the delivery destination. This parameter is required when you create a delivery method. The value must be in one of the following formats:
 * - `acs:oss:{RegionId}:{Aliuid}:{bucketName}`: if your delivery destination is an Object Storage Service (OSS) bucket.
 * - `acs:mns:{RegionId}:{Aliuid}:/topics/{topicName}`: if your delivery destination is a Message Service (MNS) topic.
 * - `acs:log:{RegionId}:{Aliuid}:project/{projectName}/logstore/{logstoreName}`: if your delivery destination is a Log Service Logstore.
 * @property deliveryChannelType The type of the delivery method. This parameter is required when you create a delivery method. Valid values: `OSS`: Object Storage, `MNS`: Message Service, `SLS`: Log Service.
 * @property description The description of the delivery method.
 * @property status The status of the delivery method. Valid values: `0`: The delivery method is disabled., `1`: The delivery destination is enabled. This is the default value.
 */
public data class DeliveryChannelArgs(
    public val deliveryChannelAssumeRoleArn: Output<String>? = null,
    public val deliveryChannelCondition: Output<String>? = null,
    public val deliveryChannelName: Output<String>? = null,
    public val deliveryChannelTargetArn: Output<String>? = null,
    public val deliveryChannelType: Output<String>? = null,
    public val description: Output<String>? = null,
    public val status: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cfg.DeliveryChannelArgs> {
    override fun toJava(): com.pulumi.alicloud.cfg.DeliveryChannelArgs =
        com.pulumi.alicloud.cfg.DeliveryChannelArgs.builder()
            .deliveryChannelAssumeRoleArn(deliveryChannelAssumeRoleArn?.applyValue({ args0 -> args0 }))
            .deliveryChannelCondition(deliveryChannelCondition?.applyValue({ args0 -> args0 }))
            .deliveryChannelName(deliveryChannelName?.applyValue({ args0 -> args0 }))
            .deliveryChannelTargetArn(deliveryChannelTargetArn?.applyValue({ args0 -> args0 }))
            .deliveryChannelType(deliveryChannelType?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeliveryChannelArgs].
 */
@PulumiTagMarker
public class DeliveryChannelArgsBuilder internal constructor() {
    private var deliveryChannelAssumeRoleArn: Output<String>? = null

    private var deliveryChannelCondition: Output<String>? = null

    private var deliveryChannelName: Output<String>? = null

    private var deliveryChannelTargetArn: Output<String>? = null

    private var deliveryChannelType: Output<String>? = null

    private var description: Output<String>? = null

    private var status: Output<Int>? = null

    /**
     * @param value The Alibaba Cloud Resource Name (ARN) of the role to be assumed by the delivery method.
     */
    @JvmName("fhxacglqdmryuelb")
    public suspend fun deliveryChannelAssumeRoleArn(`value`: Output<String>) {
        this.deliveryChannelAssumeRoleArn = value
    }

    /**
     * @param value The rule attached to the delivery method. This parameter is applicable only to delivery methods of the MNS type. Please refer to api [PutDeliveryChannel](https://www.alibabacloud.com/help/en/doc-detail/174253.htm) for example format.
     */
    @JvmName("jgilddudfqhftglm")
    public suspend fun deliveryChannelCondition(`value`: Output<String>) {
        this.deliveryChannelCondition = value
    }

    /**
     * @param value The name of the delivery channel.
     */
    @JvmName("cjdubdkvbnvbtkye")
    public suspend fun deliveryChannelName(`value`: Output<String>) {
        this.deliveryChannelName = value
    }

    /**
     * @param value The ARN of the delivery destination. This parameter is required when you create a delivery method. The value must be in one of the following formats:
     * - `acs:oss:{RegionId}:{Aliuid}:{bucketName}`: if your delivery destination is an Object Storage Service (OSS) bucket.
     * - `acs:mns:{RegionId}:{Aliuid}:/topics/{topicName}`: if your delivery destination is a Message Service (MNS) topic.
     * - `acs:log:{RegionId}:{Aliuid}:project/{projectName}/logstore/{logstoreName}`: if your delivery destination is a Log Service Logstore.
     */
    @JvmName("tauoapomsblpdial")
    public suspend fun deliveryChannelTargetArn(`value`: Output<String>) {
        this.deliveryChannelTargetArn = value
    }

    /**
     * @param value The type of the delivery method. This parameter is required when you create a delivery method. Valid values: `OSS`: Object Storage, `MNS`: Message Service, `SLS`: Log Service.
     */
    @JvmName("pdujqlgsdiisyvnt")
    public suspend fun deliveryChannelType(`value`: Output<String>) {
        this.deliveryChannelType = value
    }

    /**
     * @param value The description of the delivery method.
     */
    @JvmName("jxyolhlyocmlcgsj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The status of the delivery method. Valid values: `0`: The delivery method is disabled., `1`: The delivery destination is enabled. This is the default value.
     */
    @JvmName("ynnnpujdghhxisgl")
    public suspend fun status(`value`: Output<Int>) {
        this.status = value
    }

    /**
     * @param value The Alibaba Cloud Resource Name (ARN) of the role to be assumed by the delivery method.
     */
    @JvmName("inhejivnvycshpjv")
    public suspend fun deliveryChannelAssumeRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryChannelAssumeRoleArn = mapped
    }

    /**
     * @param value The rule attached to the delivery method. This parameter is applicable only to delivery methods of the MNS type. Please refer to api [PutDeliveryChannel](https://www.alibabacloud.com/help/en/doc-detail/174253.htm) for example format.
     */
    @JvmName("mknbxxoccqvtyemb")
    public suspend fun deliveryChannelCondition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryChannelCondition = mapped
    }

    /**
     * @param value The name of the delivery channel.
     */
    @JvmName("btwjoknwsstynyst")
    public suspend fun deliveryChannelName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryChannelName = mapped
    }

    /**
     * @param value The ARN of the delivery destination. This parameter is required when you create a delivery method. The value must be in one of the following formats:
     * - `acs:oss:{RegionId}:{Aliuid}:{bucketName}`: if your delivery destination is an Object Storage Service (OSS) bucket.
     * - `acs:mns:{RegionId}:{Aliuid}:/topics/{topicName}`: if your delivery destination is a Message Service (MNS) topic.
     * - `acs:log:{RegionId}:{Aliuid}:project/{projectName}/logstore/{logstoreName}`: if your delivery destination is a Log Service Logstore.
     */
    @JvmName("qolyemqntvotplrq")
    public suspend fun deliveryChannelTargetArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryChannelTargetArn = mapped
    }

    /**
     * @param value The type of the delivery method. This parameter is required when you create a delivery method. Valid values: `OSS`: Object Storage, `MNS`: Message Service, `SLS`: Log Service.
     */
    @JvmName("aiytamhmeirmmvts")
    public suspend fun deliveryChannelType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryChannelType = mapped
    }

    /**
     * @param value The description of the delivery method.
     */
    @JvmName("biyuhlhwpxvxtjdk")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The status of the delivery method. Valid values: `0`: The delivery method is disabled., `1`: The delivery destination is enabled. This is the default value.
     */
    @JvmName("ogohrrgxfxomktfr")
    public suspend fun status(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): DeliveryChannelArgs = DeliveryChannelArgs(
        deliveryChannelAssumeRoleArn = deliveryChannelAssumeRoleArn,
        deliveryChannelCondition = deliveryChannelCondition,
        deliveryChannelName = deliveryChannelName,
        deliveryChannelTargetArn = deliveryChannelTargetArn,
        deliveryChannelType = deliveryChannelType,
        description = description,
        status = status,
    )
}
