@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin

import com.pulumi.alicloud.cfg.kotlin.outputs.RuleCompliance
import com.pulumi.alicloud.cfg.kotlin.outputs.RuleCompliance.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Rule].
 */
@PulumiTagMarker
public class RuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RuleArgs = RuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RuleArgsBuilder.() -> Unit) {
        val builder = RuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Rule {
        val builtJavaResource = com.pulumi.alicloud.cfg.Rule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Rule(builtJavaResource)
    }
}

/**
 * Provides a Config Rule resource.
 * For information about Config Rule and how to use it, see [What is Rule](https://www.alibabacloud.com/help/en/cloud-config/latest/api-config-2020-09-07-createconfigrule).
 * > **NOTE:** Available since v1.204.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.resourcemanager.getResourceGroups({
 *     status: "OK",
 * });
 * const defaultRule = new alicloud.cfg.Rule("default", {
 *     description: "If the resource matches one of the specified tag key-value pairs, the configuration is considered compliant.",
 *     sourceOwner: "ALIYUN",
 *     sourceIdentifier: "contains-tag",
 *     riskLevel: 1,
 *     tagValueScope: "example-value",
 *     tagKeyScope: "example-key",
 *     excludeResourceIdsScope: "example-resource_id",
 *     regionIdsScope: "cn-hangzhou",
 *     configRuleTriggerTypes: "ConfigurationItemChangeNotification",
 *     resourceGroupIdsScope: _default.then(_default => _default.ids?.[0]),
 *     resourceTypesScopes: ["ACS::RDS::DBInstance"],
 *     ruleName: "contains-tag",
 *     inputParameters: {
 *         key: "example",
 *         value: "example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.resourcemanager.get_resource_groups(status="OK")
 * default_rule = alicloud.cfg.Rule("default",
 *     description="If the resource matches one of the specified tag key-value pairs, the configuration is considered compliant.",
 *     source_owner="ALIYUN",
 *     source_identifier="contains-tag",
 *     risk_level=1,
 *     tag_value_scope="example-value",
 *     tag_key_scope="example-key",
 *     exclude_resource_ids_scope="example-resource_id",
 *     region_ids_scope="cn-hangzhou",
 *     config_rule_trigger_types="ConfigurationItemChangeNotification",
 *     resource_group_ids_scope=default.ids[0],
 *     resource_types_scopes=["ACS::RDS::DBInstance"],
 *     rule_name="contains-tag",
 *     input_parameters={
 *         "key": "example",
 *         "value": "example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke(new()
 *     {
 *         Status = "OK",
 *     });
 *     var defaultRule = new AliCloud.Cfg.Rule("default", new()
 *     {
 *         Description = "If the resource matches one of the specified tag key-value pairs, the configuration is considered compliant.",
 *         SourceOwner = "ALIYUN",
 *         SourceIdentifier = "contains-tag",
 *         RiskLevel = 1,
 *         TagValueScope = "example-value",
 *         TagKeyScope = "example-key",
 *         ExcludeResourceIdsScope = "example-resource_id",
 *         RegionIdsScope = "cn-hangzhou",
 *         ConfigRuleTriggerTypes = "ConfigurationItemChangeNotification",
 *         ResourceGroupIdsScope = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0])),
 *         ResourceTypesScopes = new[]
 *         {
 *             "ACS::RDS::DBInstance",
 *         },
 *         RuleName = "contains-tag",
 *         InputParameters =
 *         {
 *             { "key", "example" },
 *             { "value", "example" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cfg"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, &resourcemanager.GetResourceGroupsArgs{
 * 			Status: pulumi.StringRef("OK"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cfg.NewRule(ctx, "default", &cfg.RuleArgs{
 * 			Description:             pulumi.String("If the resource matches one of the specified tag key-value pairs, the configuration is considered compliant."),
 * 			SourceOwner:             pulumi.String("ALIYUN"),
 * 			SourceIdentifier:        pulumi.String("contains-tag"),
 * 			RiskLevel:               pulumi.Int(1),
 * 			TagValueScope:           pulumi.String("example-value"),
 * 			TagKeyScope:             pulumi.String("example-key"),
 * 			ExcludeResourceIdsScope: pulumi.String("example-resource_id"),
 * 			RegionIdsScope:          pulumi.String("cn-hangzhou"),
 * 			ConfigRuleTriggerTypes:  pulumi.String("ConfigurationItemChangeNotification"),
 * 			ResourceGroupIdsScope:   pulumi.String(_default.Ids[0]),
 * 			ResourceTypesScopes: pulumi.StringArray{
 * 				pulumi.String("ACS::RDS::DBInstance"),
 * 			},
 * 			RuleName: pulumi.String("contains-tag"),
 * 			InputParameters: pulumi.StringMap{
 * 				"key":   pulumi.String("example"),
 * 				"value": pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.cfg.Rule;
 * import com.pulumi.alicloud.cfg.RuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = ResourcemanagerFunctions.getResourceGroups(GetResourceGroupsArgs.builder()
 *             .status("OK")
 *             .build());
 *         var defaultRule = new Rule("defaultRule", RuleArgs.builder()
 *             .description("If the resource matches one of the specified tag key-value pairs, the configuration is considered compliant.")
 *             .sourceOwner("ALIYUN")
 *             .sourceIdentifier("contains-tag")
 *             .riskLevel(1)
 *             .tagValueScope("example-value")
 *             .tagKeyScope("example-key")
 *             .excludeResourceIdsScope("example-resource_id")
 *             .regionIdsScope("cn-hangzhou")
 *             .configRuleTriggerTypes("ConfigurationItemChangeNotification")
 *             .resourceGroupIdsScope(default_.ids()[0])
 *             .resourceTypesScopes("ACS::RDS::DBInstance")
 *             .ruleName("contains-tag")
 *             .inputParameters(Map.ofEntries(
 *                 Map.entry("key", "example"),
 *                 Map.entry("value", "example")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultRule:
 *     type: alicloud:cfg:Rule
 *     name: default
 *     properties:
 *       description: If the resource matches one of the specified tag key-value pairs, the configuration is considered compliant.
 *       sourceOwner: ALIYUN
 *       sourceIdentifier: contains-tag
 *       riskLevel: 1
 *       tagValueScope: example-value
 *       tagKeyScope: example-key
 *       excludeResourceIdsScope: example-resource_id
 *       regionIdsScope: cn-hangzhou
 *       configRuleTriggerTypes: ConfigurationItemChangeNotification
 *       resourceGroupIdsScope: ${default.ids[0]}
 *       resourceTypesScopes:
 *         - ACS::RDS::DBInstance
 *       ruleName: contains-tag
 *       inputParameters:
 *         key: example
 *         value: example
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments:
 *         status: OK
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Config Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cfg/rule:Rule example <id>
 * ```
 */
public class Rule internal constructor(
    override val javaResource: com.pulumi.alicloud.cfg.Rule,
) : KotlinCustomResource(javaResource, RuleMapper) {
    /**
     * The ID of Alicloud account.
     */
    public val accountId: Output<Int>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * compliance information.
     */
    public val compliance: Output<RuleCompliance>
        get() = javaResource.compliance().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Compliance Package ID.
     */
    public val compliancePackId: Output<String>
        get() = javaResource.compliancePackId().applyValue({ args0 -> args0 })

    /**
     * config rule arn.
     */
    public val configRuleArn: Output<String>
        get() = javaResource.configRuleArn().applyValue({ args0 -> args0 })

    /**
     * The ID of the rule.
     */
    public val configRuleId: Output<String>
        get() = javaResource.configRuleId().applyValue({ args0 -> args0 })

    /**
     * The trigger type of the rule. Valid values:  `ConfigurationItemChangeNotification`: The rule is triggered upon configuration changes. `ScheduledNotification`: The rule is triggered as scheduled.
     */
    public val configRuleTriggerTypes: Output<String>
        get() = javaResource.configRuleTriggerTypes().applyValue({ args0 -> args0 })

    /**
     * The timestamp when the rule was created.
     */
    public val createTime: Output<Int>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The description of the rule.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The event source of the rule.
     */
    public val eventSource: Output<String>
        get() = javaResource.eventSource().applyValue({ args0 -> args0 })

    /**
     * The rule monitors excluded resource IDs, multiple of which are separated by commas, only applies to rules created based on managed rules, , custom rule this field is empty.
     */
    public val excludeResourceIdsScope: Output<String>?
        get() = javaResource.excludeResourceIdsScope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The settings of the input parameters for the rule.
     */
    public val inputParameters: Output<Map<String, String>>?
        get() = javaResource.inputParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * The frequency of the compliance evaluations, it is required if the ConfigRuleTriggerTypes value is ScheduledNotification. Valid values:  `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, `TwentyFour_Hours`.
     */
    public val maximumExecutionFrequency: Output<String>
        get() = javaResource.maximumExecutionFrequency().applyValue({ args0 -> args0 })

    /**
     * The timestamp when the rule was last modified.
     */
    public val modifiedTimestamp: Output<Int>
        get() = javaResource.modifiedTimestamp().applyValue({ args0 -> args0 })

    /**
     * The rule monitors region IDs, separated by commas, only applies to rules created based on managed rules.
     */
    public val regionIdsScope: Output<String>?
        get() = javaResource.regionIdsScope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The rule monitors resource group IDs, separated by commas, only applies to rules created based on managed rules.
     */
    public val resourceGroupIdsScope: Output<String>?
        get() = javaResource.resourceGroupIdsScope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The types of the resources to be evaluated against the rule.
     */
    public val resourceTypesScopes: Output<List<String>>
        get() = javaResource.resourceTypesScopes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The risk level of the resources that are not compliant with the rule. Valid values:  `1`: critical `2`: warning `3`: info
     */
    public val riskLevel: Output<Int>
        get() = javaResource.riskLevel().applyValue({ args0 -> args0 })

    /**
     * The name of the rule.
     */
    public val ruleName: Output<String>
        get() = javaResource.ruleName().applyValue({ args0 -> args0 })

    /**
     * Field 'scope_compliance_resource_types' has been deprecated from provider version 1.124.1. New field 'resource_types_scope' instead.
     */
    @Deprecated(
        message = """
  Field 'scope_compliance_resource_types' has been deprecated from provider version 1.124.1. New
      field 'resource_types_scope' instead.
  """,
    )
    public val scopeComplianceResourceTypes: Output<String>
        get() = javaResource.scopeComplianceResourceTypes().applyValue({ args0 -> args0 })

    /**
     * Field 'source_detail_message_type' has been deprecated from provider version 1.124.1. New field 'config_rule_trigger_types' instead.
     */
    @Deprecated(
        message = """
  Field 'source_detail_message_type' has been deprecated from provider version 1.124.1. New field
      'config_rule_trigger_types' instead.
  """,
    )
    public val sourceDetailMessageType: Output<String>
        get() = javaResource.sourceDetailMessageType().applyValue({ args0 -> args0 })

    /**
     * The identifier of the rule.  For a managed rule, the value is the name of the managed rule. For a custom rule, the value is the ARN of the custom rule.
     */
    public val sourceIdentifier: Output<String>
        get() = javaResource.sourceIdentifier().applyValue({ args0 -> args0 })

    /**
     * Field 'source_maximum_execution_frequency' has been deprecated from provider version 1.124.1. New field 'maximum_execution_frequency' instead.
     */
    @Deprecated(
        message = """
  Field 'source_maximum_execution_frequency' has been deprecated from provider version 1.124.1. New
      field 'maximum_execution_frequency' instead.
  """,
    )
    public val sourceMaximumExecutionFrequency: Output<String>
        get() = javaResource.sourceMaximumExecutionFrequency().applyValue({ args0 -> args0 })

    /**
     * Specifies whether you or Alibaba Cloud owns and manages the rule. Valid values:  `CUSTOM_FC`: The rule is a custom rule and you own the rule. `ALIYUN`: The rule is a managed rule and Alibaba Cloud owns the rule
     */
    public val sourceOwner: Output<String>
        get() = javaResource.sourceOwner().applyValue({ args0 -> args0 })

    /**
     * The status of the rule. Valid values: ACTIVE: The rule is monitoring the configurations of target resources. DELETING_RESULTS: The compliance evaluation result returned by the rule is being deleted. EVALUATING: The rule is triggered and is evaluating whether the configurations of target resources are compliant. INACTIVE: The rule is disabled from monitoring the configurations of target resources.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The rule monitors the tag key, only applies to rules created based on managed rules.
     */
    public val tagKeyScope: Output<String>?
        get() = javaResource.tagKeyScope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The rule monitors the tag value, only applies to rules created based on managed rules.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    public val tagValueScope: Output<String>?
        get() = javaResource.tagValueScope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object RuleMapper : ResourceMapper<Rule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cfg.Rule::class == javaResource::class

    override fun map(javaResource: Resource): Rule = Rule(
        javaResource as
            com.pulumi.alicloud.cfg.Rule,
    )
}

/**
 * @see [Rule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Rule].
 */
public suspend fun rule(name: String, block: suspend RuleResourceBuilder.() -> Unit): Rule {
    val builder = RuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Rule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun rule(name: String): Rule {
    val builder = RuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
