@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin

import com.pulumi.alicloud.cfg.RuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Config Rule resource.
 * For information about Config Rule and how to use it, see [What is Rule](https://www.alibabacloud.com/help/en/cloud-config/latest/api-config-2020-09-07-createconfigrule).
 * > **NOTE:** Available since v1.204.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.resourcemanager.getResourceGroups({
 *     status: "OK",
 * });
 * const defaultRule = new alicloud.cfg.Rule("default", {
 *     description: "If the resource matches one of the specified tag key-value pairs, the configuration is considered compliant.",
 *     sourceOwner: "ALIYUN",
 *     sourceIdentifier: "contains-tag",
 *     riskLevel: 1,
 *     tagValueScope: "example-value",
 *     tagKeyScope: "example-key",
 *     excludeResourceIdsScope: "example-resource_id",
 *     regionIdsScope: "cn-hangzhou",
 *     configRuleTriggerTypes: "ConfigurationItemChangeNotification",
 *     resourceGroupIdsScope: _default.then(_default => _default.ids?.[0]),
 *     resourceTypesScopes: ["ACS::RDS::DBInstance"],
 *     ruleName: "contains-tag",
 *     inputParameters: {
 *         key: "example",
 *         value: "example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.resourcemanager.get_resource_groups(status="OK")
 * default_rule = alicloud.cfg.Rule("default",
 *     description="If the resource matches one of the specified tag key-value pairs, the configuration is considered compliant.",
 *     source_owner="ALIYUN",
 *     source_identifier="contains-tag",
 *     risk_level=1,
 *     tag_value_scope="example-value",
 *     tag_key_scope="example-key",
 *     exclude_resource_ids_scope="example-resource_id",
 *     region_ids_scope="cn-hangzhou",
 *     config_rule_trigger_types="ConfigurationItemChangeNotification",
 *     resource_group_ids_scope=default.ids[0],
 *     resource_types_scopes=["ACS::RDS::DBInstance"],
 *     rule_name="contains-tag",
 *     input_parameters={
 *         "key": "example",
 *         "value": "example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke(new()
 *     {
 *         Status = "OK",
 *     });
 *     var defaultRule = new AliCloud.Cfg.Rule("default", new()
 *     {
 *         Description = "If the resource matches one of the specified tag key-value pairs, the configuration is considered compliant.",
 *         SourceOwner = "ALIYUN",
 *         SourceIdentifier = "contains-tag",
 *         RiskLevel = 1,
 *         TagValueScope = "example-value",
 *         TagKeyScope = "example-key",
 *         ExcludeResourceIdsScope = "example-resource_id",
 *         RegionIdsScope = "cn-hangzhou",
 *         ConfigRuleTriggerTypes = "ConfigurationItemChangeNotification",
 *         ResourceGroupIdsScope = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0])),
 *         ResourceTypesScopes = new[]
 *         {
 *             "ACS::RDS::DBInstance",
 *         },
 *         RuleName = "contains-tag",
 *         InputParameters =
 *         {
 *             { "key", "example" },
 *             { "value", "example" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cfg"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, &resourcemanager.GetResourceGroupsArgs{
 * 			Status: pulumi.StringRef("OK"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cfg.NewRule(ctx, "default", &cfg.RuleArgs{
 * 			Description:             pulumi.String("If the resource matches one of the specified tag key-value pairs, the configuration is considered compliant."),
 * 			SourceOwner:             pulumi.String("ALIYUN"),
 * 			SourceIdentifier:        pulumi.String("contains-tag"),
 * 			RiskLevel:               pulumi.Int(1),
 * 			TagValueScope:           pulumi.String("example-value"),
 * 			TagKeyScope:             pulumi.String("example-key"),
 * 			ExcludeResourceIdsScope: pulumi.String("example-resource_id"),
 * 			RegionIdsScope:          pulumi.String("cn-hangzhou"),
 * 			ConfigRuleTriggerTypes:  pulumi.String("ConfigurationItemChangeNotification"),
 * 			ResourceGroupIdsScope:   pulumi.String(_default.Ids[0]),
 * 			ResourceTypesScopes: pulumi.StringArray{
 * 				pulumi.String("ACS::RDS::DBInstance"),
 * 			},
 * 			RuleName: pulumi.String("contains-tag"),
 * 			InputParameters: pulumi.StringMap{
 * 				"key":   pulumi.String("example"),
 * 				"value": pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.cfg.Rule;
 * import com.pulumi.alicloud.cfg.RuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = ResourcemanagerFunctions.getResourceGroups(GetResourceGroupsArgs.builder()
 *             .status("OK")
 *             .build());
 *         var defaultRule = new Rule("defaultRule", RuleArgs.builder()
 *             .description("If the resource matches one of the specified tag key-value pairs, the configuration is considered compliant.")
 *             .sourceOwner("ALIYUN")
 *             .sourceIdentifier("contains-tag")
 *             .riskLevel(1)
 *             .tagValueScope("example-value")
 *             .tagKeyScope("example-key")
 *             .excludeResourceIdsScope("example-resource_id")
 *             .regionIdsScope("cn-hangzhou")
 *             .configRuleTriggerTypes("ConfigurationItemChangeNotification")
 *             .resourceGroupIdsScope(default_.ids()[0])
 *             .resourceTypesScopes("ACS::RDS::DBInstance")
 *             .ruleName("contains-tag")
 *             .inputParameters(Map.ofEntries(
 *                 Map.entry("key", "example"),
 *                 Map.entry("value", "example")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultRule:
 *     type: alicloud:cfg:Rule
 *     name: default
 *     properties:
 *       description: If the resource matches one of the specified tag key-value pairs, the configuration is considered compliant.
 *       sourceOwner: ALIYUN
 *       sourceIdentifier: contains-tag
 *       riskLevel: 1
 *       tagValueScope: example-value
 *       tagKeyScope: example-key
 *       excludeResourceIdsScope: example-resource_id
 *       regionIdsScope: cn-hangzhou
 *       configRuleTriggerTypes: ConfigurationItemChangeNotification
 *       resourceGroupIdsScope: ${default.ids[0]}
 *       resourceTypesScopes:
 *         - ACS::RDS::DBInstance
 *       ruleName: contains-tag
 *       inputParameters:
 *         key: example
 *         value: example
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments:
 *         status: OK
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Config Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cfg/rule:Rule example <id>
 * ```
 * @property configRuleTriggerTypes The trigger type of the rule. Valid values:  `ConfigurationItemChangeNotification`: The rule is triggered upon configuration changes. `ScheduledNotification`: The rule is triggered as scheduled.
 * @property description The description of the rule.
 * @property excludeResourceIdsScope The rule monitors excluded resource IDs, multiple of which are separated by commas, only applies to rules created based on managed rules, , custom rule this field is empty.
 * @property inputParameters The settings of the input parameters for the rule.
 * @property maximumExecutionFrequency The frequency of the compliance evaluations, it is required if the ConfigRuleTriggerTypes value is ScheduledNotification. Valid values:  `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, `TwentyFour_Hours`.
 * @property regionIdsScope The rule monitors region IDs, separated by commas, only applies to rules created based on managed rules.
 * @property resourceGroupIdsScope The rule monitors resource group IDs, separated by commas, only applies to rules created based on managed rules.
 * @property resourceTypesScopes The types of the resources to be evaluated against the rule.
 * @property riskLevel The risk level of the resources that are not compliant with the rule. Valid values:  `1`: critical `2`: warning `3`: info
 * @property ruleName The name of the rule.
 * @property scopeComplianceResourceTypes Field 'scope_compliance_resource_types' has been deprecated from provider version 1.124.1. New field 'resource_types_scope' instead.
 * @property sourceDetailMessageType Field 'source_detail_message_type' has been deprecated from provider version 1.124.1. New field 'config_rule_trigger_types' instead.
 * @property sourceIdentifier The identifier of the rule.  For a managed rule, the value is the name of the managed rule. For a custom rule, the value is the ARN of the custom rule.
 * @property sourceMaximumExecutionFrequency Field 'source_maximum_execution_frequency' has been deprecated from provider version 1.124.1. New field 'maximum_execution_frequency' instead.
 * @property sourceOwner Specifies whether you or Alibaba Cloud owns and manages the rule. Valid values:  `CUSTOM_FC`: The rule is a custom rule and you own the rule. `ALIYUN`: The rule is a managed rule and Alibaba Cloud owns the rule
 * @property status The status of the rule. Valid values: ACTIVE: The rule is monitoring the configurations of target resources. DELETING_RESULTS: The compliance evaluation result returned by the rule is being deleted. EVALUATING: The rule is triggered and is evaluating whether the configurations of target resources are compliant. INACTIVE: The rule is disabled from monitoring the configurations of target resources.
 * @property tagKeyScope The rule monitors the tag key, only applies to rules created based on managed rules.
 * @property tagValueScope The rule monitors the tag value, only applies to rules created based on managed rules.
 * The following arguments will be discarded. Please use new fields as soon as possible:
 */
public data class RuleArgs(
    public val configRuleTriggerTypes: Output<String>? = null,
    public val description: Output<String>? = null,
    public val excludeResourceIdsScope: Output<String>? = null,
    public val inputParameters: Output<Map<String, String>>? = null,
    public val maximumExecutionFrequency: Output<String>? = null,
    public val regionIdsScope: Output<String>? = null,
    public val resourceGroupIdsScope: Output<String>? = null,
    public val resourceTypesScopes: Output<List<String>>? = null,
    public val riskLevel: Output<Int>? = null,
    public val ruleName: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'scope_compliance_resource_types' has been deprecated from provider version 1.124.1. New
      field 'resource_types_scope' instead.
  """,
    )
    public val scopeComplianceResourceTypes: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'source_detail_message_type' has been deprecated from provider version 1.124.1. New field
      'config_rule_trigger_types' instead.
  """,
    )
    public val sourceDetailMessageType: Output<String>? = null,
    public val sourceIdentifier: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'source_maximum_execution_frequency' has been deprecated from provider version 1.124.1. New
      field 'maximum_execution_frequency' instead.
  """,
    )
    public val sourceMaximumExecutionFrequency: Output<String>? = null,
    public val sourceOwner: Output<String>? = null,
    public val status: Output<String>? = null,
    public val tagKeyScope: Output<String>? = null,
    public val tagValueScope: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cfg.RuleArgs> {
    override fun toJava(): com.pulumi.alicloud.cfg.RuleArgs =
        com.pulumi.alicloud.cfg.RuleArgs.builder()
            .configRuleTriggerTypes(configRuleTriggerTypes?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .excludeResourceIdsScope(excludeResourceIdsScope?.applyValue({ args0 -> args0 }))
            .inputParameters(
                inputParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .maximumExecutionFrequency(maximumExecutionFrequency?.applyValue({ args0 -> args0 }))
            .regionIdsScope(regionIdsScope?.applyValue({ args0 -> args0 }))
            .resourceGroupIdsScope(resourceGroupIdsScope?.applyValue({ args0 -> args0 }))
            .resourceTypesScopes(resourceTypesScopes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .riskLevel(riskLevel?.applyValue({ args0 -> args0 }))
            .ruleName(ruleName?.applyValue({ args0 -> args0 }))
            .scopeComplianceResourceTypes(scopeComplianceResourceTypes?.applyValue({ args0 -> args0 }))
            .sourceDetailMessageType(sourceDetailMessageType?.applyValue({ args0 -> args0 }))
            .sourceIdentifier(sourceIdentifier?.applyValue({ args0 -> args0 }))
            .sourceMaximumExecutionFrequency(sourceMaximumExecutionFrequency?.applyValue({ args0 -> args0 }))
            .sourceOwner(sourceOwner?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .tagKeyScope(tagKeyScope?.applyValue({ args0 -> args0 }))
            .tagValueScope(tagValueScope?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleArgs].
 */
@PulumiTagMarker
public class RuleArgsBuilder internal constructor() {
    private var configRuleTriggerTypes: Output<String>? = null

    private var description: Output<String>? = null

    private var excludeResourceIdsScope: Output<String>? = null

    private var inputParameters: Output<Map<String, String>>? = null

    private var maximumExecutionFrequency: Output<String>? = null

    private var regionIdsScope: Output<String>? = null

    private var resourceGroupIdsScope: Output<String>? = null

    private var resourceTypesScopes: Output<List<String>>? = null

    private var riskLevel: Output<Int>? = null

    private var ruleName: Output<String>? = null

    private var scopeComplianceResourceTypes: Output<String>? = null

    private var sourceDetailMessageType: Output<String>? = null

    private var sourceIdentifier: Output<String>? = null

    private var sourceMaximumExecutionFrequency: Output<String>? = null

    private var sourceOwner: Output<String>? = null

    private var status: Output<String>? = null

    private var tagKeyScope: Output<String>? = null

    private var tagValueScope: Output<String>? = null

    /**
     * @param value The trigger type of the rule. Valid values:  `ConfigurationItemChangeNotification`: The rule is triggered upon configuration changes. `ScheduledNotification`: The rule is triggered as scheduled.
     */
    @JvmName("mjqptnawrhdmsiqg")
    public suspend fun configRuleTriggerTypes(`value`: Output<String>) {
        this.configRuleTriggerTypes = value
    }

    /**
     * @param value The description of the rule.
     */
    @JvmName("ghdtxuimapdmqwlp")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The rule monitors excluded resource IDs, multiple of which are separated by commas, only applies to rules created based on managed rules, , custom rule this field is empty.
     */
    @JvmName("srfvhlsjmjepqpqs")
    public suspend fun excludeResourceIdsScope(`value`: Output<String>) {
        this.excludeResourceIdsScope = value
    }

    /**
     * @param value The settings of the input parameters for the rule.
     */
    @JvmName("kcujluaawymcsyyn")
    public suspend fun inputParameters(`value`: Output<Map<String, String>>) {
        this.inputParameters = value
    }

    /**
     * @param value The frequency of the compliance evaluations, it is required if the ConfigRuleTriggerTypes value is ScheduledNotification. Valid values:  `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, `TwentyFour_Hours`.
     */
    @JvmName("mitvkukgyuvgvhvx")
    public suspend fun maximumExecutionFrequency(`value`: Output<String>) {
        this.maximumExecutionFrequency = value
    }

    /**
     * @param value The rule monitors region IDs, separated by commas, only applies to rules created based on managed rules.
     */
    @JvmName("kesntvciqxmidlfp")
    public suspend fun regionIdsScope(`value`: Output<String>) {
        this.regionIdsScope = value
    }

    /**
     * @param value The rule monitors resource group IDs, separated by commas, only applies to rules created based on managed rules.
     */
    @JvmName("voaeswawvaysecei")
    public suspend fun resourceGroupIdsScope(`value`: Output<String>) {
        this.resourceGroupIdsScope = value
    }

    /**
     * @param value The types of the resources to be evaluated against the rule.
     */
    @JvmName("jawhhpidpbmunbcr")
    public suspend fun resourceTypesScopes(`value`: Output<List<String>>) {
        this.resourceTypesScopes = value
    }

    @JvmName("pkvvtbfjpvvaxoat")
    public suspend fun resourceTypesScopes(vararg values: Output<String>) {
        this.resourceTypesScopes = Output.all(values.asList())
    }

    /**
     * @param values The types of the resources to be evaluated against the rule.
     */
    @JvmName("rxgpnclijunihgpn")
    public suspend fun resourceTypesScopes(values: List<Output<String>>) {
        this.resourceTypesScopes = Output.all(values)
    }

    /**
     * @param value The risk level of the resources that are not compliant with the rule. Valid values:  `1`: critical `2`: warning `3`: info
     */
    @JvmName("klncytwdclniauog")
    public suspend fun riskLevel(`value`: Output<Int>) {
        this.riskLevel = value
    }

    /**
     * @param value The name of the rule.
     */
    @JvmName("bnqdxvouwikuxqft")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value Field 'scope_compliance_resource_types' has been deprecated from provider version 1.124.1. New field 'resource_types_scope' instead.
     */
    @Deprecated(
        message = """
  Field 'scope_compliance_resource_types' has been deprecated from provider version 1.124.1. New
      field 'resource_types_scope' instead.
  """,
    )
    @JvmName("ausbktlbdqmboonr")
    public suspend fun scopeComplianceResourceTypes(`value`: Output<String>) {
        this.scopeComplianceResourceTypes = value
    }

    /**
     * @param value Field 'source_detail_message_type' has been deprecated from provider version 1.124.1. New field 'config_rule_trigger_types' instead.
     */
    @Deprecated(
        message = """
  Field 'source_detail_message_type' has been deprecated from provider version 1.124.1. New field
      'config_rule_trigger_types' instead.
  """,
    )
    @JvmName("aqjxmrsymbnkgxof")
    public suspend fun sourceDetailMessageType(`value`: Output<String>) {
        this.sourceDetailMessageType = value
    }

    /**
     * @param value The identifier of the rule.  For a managed rule, the value is the name of the managed rule. For a custom rule, the value is the ARN of the custom rule.
     */
    @JvmName("xennlhghdigvtble")
    public suspend fun sourceIdentifier(`value`: Output<String>) {
        this.sourceIdentifier = value
    }

    /**
     * @param value Field 'source_maximum_execution_frequency' has been deprecated from provider version 1.124.1. New field 'maximum_execution_frequency' instead.
     */
    @Deprecated(
        message = """
  Field 'source_maximum_execution_frequency' has been deprecated from provider version 1.124.1. New
      field 'maximum_execution_frequency' instead.
  """,
    )
    @JvmName("uojnrrqqstxpaprk")
    public suspend fun sourceMaximumExecutionFrequency(`value`: Output<String>) {
        this.sourceMaximumExecutionFrequency = value
    }

    /**
     * @param value Specifies whether you or Alibaba Cloud owns and manages the rule. Valid values:  `CUSTOM_FC`: The rule is a custom rule and you own the rule. `ALIYUN`: The rule is a managed rule and Alibaba Cloud owns the rule
     */
    @JvmName("jshprrgqsaajhcpo")
    public suspend fun sourceOwner(`value`: Output<String>) {
        this.sourceOwner = value
    }

    /**
     * @param value The status of the rule. Valid values: ACTIVE: The rule is monitoring the configurations of target resources. DELETING_RESULTS: The compliance evaluation result returned by the rule is being deleted. EVALUATING: The rule is triggered and is evaluating whether the configurations of target resources are compliant. INACTIVE: The rule is disabled from monitoring the configurations of target resources.
     */
    @JvmName("uanmfqxcfusibxeo")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The rule monitors the tag key, only applies to rules created based on managed rules.
     */
    @JvmName("lxvcegiyhcbuurmo")
    public suspend fun tagKeyScope(`value`: Output<String>) {
        this.tagKeyScope = value
    }

    /**
     * @param value The rule monitors the tag value, only applies to rules created based on managed rules.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("gbvheyrfxyfiliaw")
    public suspend fun tagValueScope(`value`: Output<String>) {
        this.tagValueScope = value
    }

    /**
     * @param value The trigger type of the rule. Valid values:  `ConfigurationItemChangeNotification`: The rule is triggered upon configuration changes. `ScheduledNotification`: The rule is triggered as scheduled.
     */
    @JvmName("mvgamwfeeojvxies")
    public suspend fun configRuleTriggerTypes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configRuleTriggerTypes = mapped
    }

    /**
     * @param value The description of the rule.
     */
    @JvmName("lcgshlhxkrcitaay")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The rule monitors excluded resource IDs, multiple of which are separated by commas, only applies to rules created based on managed rules, , custom rule this field is empty.
     */
    @JvmName("tvhmmooddygidyxb")
    public suspend fun excludeResourceIdsScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludeResourceIdsScope = mapped
    }

    /**
     * @param value The settings of the input parameters for the rule.
     */
    @JvmName("lubohperffjojvuf")
    public suspend fun inputParameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputParameters = mapped
    }

    /**
     * @param values The settings of the input parameters for the rule.
     */
    @JvmName("ckngyopbwxlyousv")
    public fun inputParameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputParameters = mapped
    }

    /**
     * @param value The frequency of the compliance evaluations, it is required if the ConfigRuleTriggerTypes value is ScheduledNotification. Valid values:  `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, `TwentyFour_Hours`.
     */
    @JvmName("aulcqqunapyuaymu")
    public suspend fun maximumExecutionFrequency(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumExecutionFrequency = mapped
    }

    /**
     * @param value The rule monitors region IDs, separated by commas, only applies to rules created based on managed rules.
     */
    @JvmName("hbqdkyghncjxcmbf")
    public suspend fun regionIdsScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionIdsScope = mapped
    }

    /**
     * @param value The rule monitors resource group IDs, separated by commas, only applies to rules created based on managed rules.
     */
    @JvmName("hbghvntfnhxawqor")
    public suspend fun resourceGroupIdsScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupIdsScope = mapped
    }

    /**
     * @param value The types of the resources to be evaluated against the rule.
     */
    @JvmName("jjwbgnijldtbfbyj")
    public suspend fun resourceTypesScopes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTypesScopes = mapped
    }

    /**
     * @param values The types of the resources to be evaluated against the rule.
     */
    @JvmName("calkwtxrxwaqsnlb")
    public suspend fun resourceTypesScopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTypesScopes = mapped
    }

    /**
     * @param value The risk level of the resources that are not compliant with the rule. Valid values:  `1`: critical `2`: warning `3`: info
     */
    @JvmName("webqhqvbkowudlfe")
    public suspend fun riskLevel(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.riskLevel = mapped
    }

    /**
     * @param value The name of the rule.
     */
    @JvmName("phaebclhbclhstvd")
    public suspend fun ruleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    /**
     * @param value Field 'scope_compliance_resource_types' has been deprecated from provider version 1.124.1. New field 'resource_types_scope' instead.
     */
    @Deprecated(
        message = """
  Field 'scope_compliance_resource_types' has been deprecated from provider version 1.124.1. New
      field 'resource_types_scope' instead.
  """,
    )
    @JvmName("avtnrenguefkwjpv")
    public suspend fun scopeComplianceResourceTypes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopeComplianceResourceTypes = mapped
    }

    /**
     * @param value Field 'source_detail_message_type' has been deprecated from provider version 1.124.1. New field 'config_rule_trigger_types' instead.
     */
    @Deprecated(
        message = """
  Field 'source_detail_message_type' has been deprecated from provider version 1.124.1. New field
      'config_rule_trigger_types' instead.
  """,
    )
    @JvmName("wpevlelxgwisopxf")
    public suspend fun sourceDetailMessageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceDetailMessageType = mapped
    }

    /**
     * @param value The identifier of the rule.  For a managed rule, the value is the name of the managed rule. For a custom rule, the value is the ARN of the custom rule.
     */
    @JvmName("ugwcmwrfowsxabfv")
    public suspend fun sourceIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIdentifier = mapped
    }

    /**
     * @param value Field 'source_maximum_execution_frequency' has been deprecated from provider version 1.124.1. New field 'maximum_execution_frequency' instead.
     */
    @Deprecated(
        message = """
  Field 'source_maximum_execution_frequency' has been deprecated from provider version 1.124.1. New
      field 'maximum_execution_frequency' instead.
  """,
    )
    @JvmName("tvypfscurfejcciu")
    public suspend fun sourceMaximumExecutionFrequency(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceMaximumExecutionFrequency = mapped
    }

    /**
     * @param value Specifies whether you or Alibaba Cloud owns and manages the rule. Valid values:  `CUSTOM_FC`: The rule is a custom rule and you own the rule. `ALIYUN`: The rule is a managed rule and Alibaba Cloud owns the rule
     */
    @JvmName("yiltyjpqqcfcwafe")
    public suspend fun sourceOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceOwner = mapped
    }

    /**
     * @param value The status of the rule. Valid values: ACTIVE: The rule is monitoring the configurations of target resources. DELETING_RESULTS: The compliance evaluation result returned by the rule is being deleted. EVALUATING: The rule is triggered and is evaluating whether the configurations of target resources are compliant. INACTIVE: The rule is disabled from monitoring the configurations of target resources.
     */
    @JvmName("twbopovrvahydqap")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The rule monitors the tag key, only applies to rules created based on managed rules.
     */
    @JvmName("punssfyirgsmdtva")
    public suspend fun tagKeyScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagKeyScope = mapped
    }

    /**
     * @param value The rule monitors the tag value, only applies to rules created based on managed rules.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("otftitstayutkrxg")
    public suspend fun tagValueScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagValueScope = mapped
    }

    internal fun build(): RuleArgs = RuleArgs(
        configRuleTriggerTypes = configRuleTriggerTypes,
        description = description,
        excludeResourceIdsScope = excludeResourceIdsScope,
        inputParameters = inputParameters,
        maximumExecutionFrequency = maximumExecutionFrequency,
        regionIdsScope = regionIdsScope,
        resourceGroupIdsScope = resourceGroupIdsScope,
        resourceTypesScopes = resourceTypesScopes,
        riskLevel = riskLevel,
        ruleName = ruleName,
        scopeComplianceResourceTypes = scopeComplianceResourceTypes,
        sourceDetailMessageType = sourceDetailMessageType,
        sourceIdentifier = sourceIdentifier,
        sourceMaximumExecutionFrequency = sourceMaximumExecutionFrequency,
        sourceOwner = sourceOwner,
        status = status,
        tagKeyScope = tagKeyScope,
        tagValueScope = tagValueScope,
    )
}
