@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin.inputs

import com.pulumi.alicloud.cfg.inputs.AggregateCompliancePackConfigRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property configRuleParameters A list of parameter rules. See `config_rule_parameters` below.
 * @property managedRuleIdentifier The Managed Rule Identifier.
 */
public data class AggregateCompliancePackConfigRuleArgs(
    public val configRuleParameters: Output<List<AggregateCompliancePackConfigRuleConfigRuleParameterArgs>>? = null,
    public val managedRuleIdentifier: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.cfg.inputs.AggregateCompliancePackConfigRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.cfg.inputs.AggregateCompliancePackConfigRuleArgs =
        com.pulumi.alicloud.cfg.inputs.AggregateCompliancePackConfigRuleArgs.builder()
            .configRuleParameters(
                configRuleParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .managedRuleIdentifier(managedRuleIdentifier.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AggregateCompliancePackConfigRuleArgs].
 */
@PulumiTagMarker
public class AggregateCompliancePackConfigRuleArgsBuilder internal constructor() {
    private var configRuleParameters:
        Output<List<AggregateCompliancePackConfigRuleConfigRuleParameterArgs>>? = null

    private var managedRuleIdentifier: Output<String>? = null

    /**
     * @param value A list of parameter rules. See `config_rule_parameters` below.
     */
    @JvmName("xmivdufbpocpplmi")
    public suspend fun configRuleParameters(`value`: Output<List<AggregateCompliancePackConfigRuleConfigRuleParameterArgs>>) {
        this.configRuleParameters = value
    }

    @JvmName("heutcaaikyoucmdc")
    public suspend fun configRuleParameters(vararg values: Output<AggregateCompliancePackConfigRuleConfigRuleParameterArgs>) {
        this.configRuleParameters = Output.all(values.asList())
    }

    /**
     * @param values A list of parameter rules. See `config_rule_parameters` below.
     */
    @JvmName("bupxoofqkpthikal")
    public suspend fun configRuleParameters(values: List<Output<AggregateCompliancePackConfigRuleConfigRuleParameterArgs>>) {
        this.configRuleParameters = Output.all(values)
    }

    /**
     * @param value The Managed Rule Identifier.
     */
    @JvmName("dagexiwrlqdaxncg")
    public suspend fun managedRuleIdentifier(`value`: Output<String>) {
        this.managedRuleIdentifier = value
    }

    /**
     * @param value A list of parameter rules. See `config_rule_parameters` below.
     */
    @JvmName("deeathtfujxdpnqg")
    public suspend fun configRuleParameters(`value`: List<AggregateCompliancePackConfigRuleConfigRuleParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configRuleParameters = mapped
    }

    /**
     * @param argument A list of parameter rules. See `config_rule_parameters` below.
     */
    @JvmName("hqfuonlkabyvsjeb")
    public suspend fun configRuleParameters(argument: List<suspend AggregateCompliancePackConfigRuleConfigRuleParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AggregateCompliancePackConfigRuleConfigRuleParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configRuleParameters = mapped
    }

    /**
     * @param argument A list of parameter rules. See `config_rule_parameters` below.
     */
    @JvmName("plnmjfnopxvbbdcp")
    public suspend fun configRuleParameters(vararg argument: suspend AggregateCompliancePackConfigRuleConfigRuleParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AggregateCompliancePackConfigRuleConfigRuleParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configRuleParameters = mapped
    }

    /**
     * @param argument A list of parameter rules. See `config_rule_parameters` below.
     */
    @JvmName("eptexbpvpaywgxbf")
    public suspend fun configRuleParameters(argument: suspend AggregateCompliancePackConfigRuleConfigRuleParameterArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                AggregateCompliancePackConfigRuleConfigRuleParameterArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.configRuleParameters = mapped
    }

    /**
     * @param values A list of parameter rules. See `config_rule_parameters` below.
     */
    @JvmName("njxmmqmenawwjmdt")
    public suspend fun configRuleParameters(vararg values: AggregateCompliancePackConfigRuleConfigRuleParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configRuleParameters = mapped
    }

    /**
     * @param value The Managed Rule Identifier.
     */
    @JvmName("caaeddvgvllyitjq")
    public suspend fun managedRuleIdentifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managedRuleIdentifier = mapped
    }

    internal fun build(): AggregateCompliancePackConfigRuleArgs =
        AggregateCompliancePackConfigRuleArgs(
            configRuleParameters = configRuleParameters,
            managedRuleIdentifier = managedRuleIdentifier ?: throw
                PulumiNullFieldException("managedRuleIdentifier"),
        )
}
