@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin.inputs

import com.pulumi.alicloud.cfg.inputs.AggregateCompliancePackConfigRuleIdArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configRuleId The rule ID of Aggregate Config Rule.
 */
public data class AggregateCompliancePackConfigRuleIdArgs(
    public val configRuleId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cfg.inputs.AggregateCompliancePackConfigRuleIdArgs> {
    override fun toJava(): com.pulumi.alicloud.cfg.inputs.AggregateCompliancePackConfigRuleIdArgs =
        com.pulumi.alicloud.cfg.inputs.AggregateCompliancePackConfigRuleIdArgs.builder()
            .configRuleId(configRuleId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AggregateCompliancePackConfigRuleIdArgs].
 */
@PulumiTagMarker
public class AggregateCompliancePackConfigRuleIdArgsBuilder internal constructor() {
    private var configRuleId: Output<String>? = null

    /**
     * @param value The rule ID of Aggregate Config Rule.
     */
    @JvmName("qynqusprdbitqiba")
    public suspend fun configRuleId(`value`: Output<String>) {
        this.configRuleId = value
    }

    /**
     * @param value The rule ID of Aggregate Config Rule.
     */
    @JvmName("opaxrjxudgfvofme")
    public suspend fun configRuleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configRuleId = mapped
    }

    internal fun build(): AggregateCompliancePackConfigRuleIdArgs =
        AggregateCompliancePackConfigRuleIdArgs(
            configRuleId = configRuleId,
        )
}
