@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin.inputs

import com.pulumi.alicloud.cfg.inputs.AggregatorAggregatorAccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountId Aggregator account Uid.
 * @property accountName Aggregator account name.
 * @property accountType Aggregator account source type. Valid values: `ResourceDirectory`.
 */
public data class AggregatorAggregatorAccountArgs(
    public val accountId: Output<String>,
    public val accountName: Output<String>,
    public val accountType: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.cfg.inputs.AggregatorAggregatorAccountArgs> {
    override fun toJava(): com.pulumi.alicloud.cfg.inputs.AggregatorAggregatorAccountArgs =
        com.pulumi.alicloud.cfg.inputs.AggregatorAggregatorAccountArgs.builder()
            .accountId(accountId.applyValue({ args0 -> args0 }))
            .accountName(accountName.applyValue({ args0 -> args0 }))
            .accountType(accountType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AggregatorAggregatorAccountArgs].
 */
@PulumiTagMarker
public class AggregatorAggregatorAccountArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var accountName: Output<String>? = null

    private var accountType: Output<String>? = null

    /**
     * @param value Aggregator account Uid.
     */
    @JvmName("bdkffcacigxbwrpj")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value Aggregator account name.
     */
    @JvmName("hmylnveahuipfqic")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Aggregator account source type. Valid values: `ResourceDirectory`.
     */
    @JvmName("kphuecskcmgglvia")
    public suspend fun accountType(`value`: Output<String>) {
        this.accountType = value
    }

    /**
     * @param value Aggregator account Uid.
     */
    @JvmName("ochsmpjcwvkbnwdn")
    public suspend fun accountId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value Aggregator account name.
     */
    @JvmName("lxvwjvilxqrmjrpp")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Aggregator account source type. Valid values: `ResourceDirectory`.
     */
    @JvmName("tcfnrgejakxuerio")
    public suspend fun accountType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountType = mapped
    }

    internal fun build(): AggregatorAggregatorAccountArgs = AggregatorAggregatorAccountArgs(
        accountId = accountId ?: throw PulumiNullFieldException("accountId"),
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        accountType = accountType ?: throw PulumiNullFieldException("accountType"),
    )
}
