@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin.inputs

import com.pulumi.alicloud.cfg.inputs.CompliancePackConfigRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property configRuleParameters A list of Config Rule Parameters. See `config_rule_parameters` below.
 * @property managedRuleIdentifier The Managed Rule Identifier.
 */
public data class CompliancePackConfigRuleArgs(
    public val configRuleParameters: Output<List<CompliancePackConfigRuleConfigRuleParameterArgs>>? =
        null,
    public val managedRuleIdentifier: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.cfg.inputs.CompliancePackConfigRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.cfg.inputs.CompliancePackConfigRuleArgs =
        com.pulumi.alicloud.cfg.inputs.CompliancePackConfigRuleArgs.builder()
            .configRuleParameters(
                configRuleParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .managedRuleIdentifier(managedRuleIdentifier.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CompliancePackConfigRuleArgs].
 */
@PulumiTagMarker
public class CompliancePackConfigRuleArgsBuilder internal constructor() {
    private var configRuleParameters: Output<List<CompliancePackConfigRuleConfigRuleParameterArgs>>? =
        null

    private var managedRuleIdentifier: Output<String>? = null

    /**
     * @param value A list of Config Rule Parameters. See `config_rule_parameters` below.
     */
    @JvmName("iotiqpstugdywkwn")
    public suspend fun configRuleParameters(`value`: Output<List<CompliancePackConfigRuleConfigRuleParameterArgs>>) {
        this.configRuleParameters = value
    }

    @JvmName("hqwfxaawtlygpkyh")
    public suspend fun configRuleParameters(vararg values: Output<CompliancePackConfigRuleConfigRuleParameterArgs>) {
        this.configRuleParameters = Output.all(values.asList())
    }

    /**
     * @param values A list of Config Rule Parameters. See `config_rule_parameters` below.
     */
    @JvmName("adtvophuohobwjdo")
    public suspend fun configRuleParameters(values: List<Output<CompliancePackConfigRuleConfigRuleParameterArgs>>) {
        this.configRuleParameters = Output.all(values)
    }

    /**
     * @param value The Managed Rule Identifier.
     */
    @JvmName("mwrtwftwramikusu")
    public suspend fun managedRuleIdentifier(`value`: Output<String>) {
        this.managedRuleIdentifier = value
    }

    /**
     * @param value A list of Config Rule Parameters. See `config_rule_parameters` below.
     */
    @JvmName("rbvthjkdfdmagywo")
    public suspend fun configRuleParameters(`value`: List<CompliancePackConfigRuleConfigRuleParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configRuleParameters = mapped
    }

    /**
     * @param argument A list of Config Rule Parameters. See `config_rule_parameters` below.
     */
    @JvmName("dulehwegvbsxblrb")
    public suspend fun configRuleParameters(argument: List<suspend CompliancePackConfigRuleConfigRuleParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CompliancePackConfigRuleConfigRuleParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.configRuleParameters = mapped
    }

    /**
     * @param argument A list of Config Rule Parameters. See `config_rule_parameters` below.
     */
    @JvmName("xgleljeesfshmeea")
    public suspend fun configRuleParameters(vararg argument: suspend CompliancePackConfigRuleConfigRuleParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CompliancePackConfigRuleConfigRuleParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.configRuleParameters = mapped
    }

    /**
     * @param argument A list of Config Rule Parameters. See `config_rule_parameters` below.
     */
    @JvmName("auvlhnynlxxpikfk")
    public suspend fun configRuleParameters(argument: suspend CompliancePackConfigRuleConfigRuleParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CompliancePackConfigRuleConfigRuleParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.configRuleParameters = mapped
    }

    /**
     * @param values A list of Config Rule Parameters. See `config_rule_parameters` below.
     */
    @JvmName("ovlijgtfnxcbgjhh")
    public suspend fun configRuleParameters(vararg values: CompliancePackConfigRuleConfigRuleParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configRuleParameters = mapped
    }

    /**
     * @param value The Managed Rule Identifier.
     */
    @JvmName("bcphlqqqtsrjlmne")
    public suspend fun managedRuleIdentifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managedRuleIdentifier = mapped
    }

    internal fun build(): CompliancePackConfigRuleArgs = CompliancePackConfigRuleArgs(
        configRuleParameters = configRuleParameters,
        managedRuleIdentifier = managedRuleIdentifier ?: throw
            PulumiNullFieldException("managedRuleIdentifier"),
    )
}
