@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin.inputs

import com.pulumi.alicloud.cfg.inputs.CompliancePackConfigRuleConfigRuleParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property parameterName The parameter name.
 * @property parameterValue The parameter value.
 */
public data class CompliancePackConfigRuleConfigRuleParameterArgs(
    public val parameterName: Output<String>? = null,
    public val parameterValue: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.cfg.inputs.CompliancePackConfigRuleConfigRuleParameterArgs> {
    override fun toJava(): com.pulumi.alicloud.cfg.inputs.CompliancePackConfigRuleConfigRuleParameterArgs =
        com.pulumi.alicloud.cfg.inputs.CompliancePackConfigRuleConfigRuleParameterArgs.builder()
            .parameterName(parameterName?.applyValue({ args0 -> args0 }))
            .parameterValue(parameterValue?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CompliancePackConfigRuleConfigRuleParameterArgs].
 */
@PulumiTagMarker
public class CompliancePackConfigRuleConfigRuleParameterArgsBuilder internal constructor() {
    private var parameterName: Output<String>? = null

    private var parameterValue: Output<String>? = null

    /**
     * @param value The parameter name.
     */
    @JvmName("vgguaylcvdyuhbuv")
    public suspend fun parameterName(`value`: Output<String>) {
        this.parameterName = value
    }

    /**
     * @param value The parameter value.
     */
    @JvmName("ujmfoblrvemyyreo")
    public suspend fun parameterValue(`value`: Output<String>) {
        this.parameterValue = value
    }

    /**
     * @param value The parameter name.
     */
    @JvmName("urjdkaqugkprmupp")
    public suspend fun parameterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameterName = mapped
    }

    /**
     * @param value The parameter value.
     */
    @JvmName("bacfdfantjyrauxs")
    public suspend fun parameterValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameterValue = mapped
    }

    internal fun build(): CompliancePackConfigRuleConfigRuleParameterArgs =
        CompliancePackConfigRuleConfigRuleParameterArgs(
            parameterName = parameterName,
            parameterValue = parameterValue,
        )
}
