@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin.inputs

import com.pulumi.alicloud.cfg.inputs.GetAggregateCompliancePacksPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAggregateCompliancePacks.
 * @property aggregatorId The ID of aggregator.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of Aggregate Compliance Pack IDs.
 * @property nameRegex A regex string to filter results by Aggregate Compliance Pack name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the resource. Valid values `ACTIVE`, `CREATING`, `INACTIVE`.
 */
public data class GetAggregateCompliancePacksPlainArgs(
    public val aggregatorId: String,
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cfg.inputs.GetAggregateCompliancePacksPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cfg.inputs.GetAggregateCompliancePacksPlainArgs =
        com.pulumi.alicloud.cfg.inputs.GetAggregateCompliancePacksPlainArgs.builder()
            .aggregatorId(aggregatorId.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAggregateCompliancePacksPlainArgs].
 */
@PulumiTagMarker
public class GetAggregateCompliancePacksPlainArgsBuilder internal constructor() {
    private var aggregatorId: String? = null

    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value The ID of aggregator.
     */
    @JvmName("diaaqdkmbrcidiym")
    public suspend fun aggregatorId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.aggregatorId = mapped
    }

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("iigkerrlnrgfykuc")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Aggregate Compliance Pack IDs.
     */
    @JvmName("abfogvkwtvwlbnnc")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Aggregate Compliance Pack IDs.
     */
    @JvmName("emvjiipuackxbcqw")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Aggregate Compliance Pack name.
     */
    @JvmName("modvtfqnfcxmeydw")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("yfnmywmaqmmcwlhi")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the resource. Valid values `ACTIVE`, `CREATING`, `INACTIVE`.
     */
    @JvmName("rhcewjegsgcxjdfi")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetAggregateCompliancePacksPlainArgs = GetAggregateCompliancePacksPlainArgs(
        aggregatorId = aggregatorId ?: throw PulumiNullFieldException("aggregatorId"),
        enableDetails = enableDetails,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
