@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin.inputs

import com.pulumi.alicloud.cfg.inputs.GetAggregateConfigRulesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAggregateConfigRules.
 * @property aggregateConfigRuleName The config rule name.
 * @property aggregatorId The ID of aggregator.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of Aggregate Config Rule IDs.
 * @property nameRegex A regex string to filter results by Aggregate Config Rule name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property riskLevel Optional, ForceNew) The Risk Level. Valid values `1`: critical, `2`: warning, `3`: info.
 * @property status The state of the config rule, valid values: `ACTIVE`, `DELETING`, `EVALUATING` and `INACTIVE`.
 */
public data class GetAggregateConfigRulesPlainArgs(
    public val aggregateConfigRuleName: String? = null,
    public val aggregatorId: String,
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val riskLevel: Int? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cfg.inputs.GetAggregateConfigRulesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cfg.inputs.GetAggregateConfigRulesPlainArgs =
        com.pulumi.alicloud.cfg.inputs.GetAggregateConfigRulesPlainArgs.builder()
            .aggregateConfigRuleName(aggregateConfigRuleName?.let({ args0 -> args0 }))
            .aggregatorId(aggregatorId.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .riskLevel(riskLevel?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAggregateConfigRulesPlainArgs].
 */
@PulumiTagMarker
public class GetAggregateConfigRulesPlainArgsBuilder internal constructor() {
    private var aggregateConfigRuleName: String? = null

    private var aggregatorId: String? = null

    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var riskLevel: Int? = null

    private var status: String? = null

    /**
     * @param value The config rule name.
     */
    @JvmName("fpewhyxgwfdnohqe")
    public suspend fun aggregateConfigRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.aggregateConfigRuleName = mapped
    }

    /**
     * @param value The ID of aggregator.
     */
    @JvmName("wrackyybxfshdnuk")
    public suspend fun aggregatorId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.aggregatorId = mapped
    }

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("fpfgefdeblwnsxvi")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Aggregate Config Rule IDs.
     */
    @JvmName("sisldrxnlanhlpbb")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Aggregate Config Rule IDs.
     */
    @JvmName("hqfenoqjtkaqjrmo")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Aggregate Config Rule name.
     */
    @JvmName("athvowaeedjaalcj")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ngenjhqxmrvnjvuy")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Optional, ForceNew) The Risk Level. Valid values `1`: critical, `2`: warning, `3`: info.
     */
    @JvmName("dokoiwtyoagadiaq")
    public suspend fun riskLevel(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.riskLevel = mapped
    }

    /**
     * @param value The state of the config rule, valid values: `ACTIVE`, `DELETING`, `EVALUATING` and `INACTIVE`.
     */
    @JvmName("yihtflvajpnapyow")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetAggregateConfigRulesPlainArgs = GetAggregateConfigRulesPlainArgs(
        aggregateConfigRuleName = aggregateConfigRuleName,
        aggregatorId = aggregatorId ?: throw PulumiNullFieldException("aggregatorId"),
        enableDetails = enableDetails,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        riskLevel = riskLevel,
        status = status,
    )
}
