@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin.inputs

import com.pulumi.alicloud.cfg.inputs.GetAggregateDeliveriesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAggregateDeliveries.
 * @property aggregatorId The ID of the Aggregator.
 * @property ids A list of Aggregate Delivery IDs.
 * @property nameRegex
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the delivery method. Valid values: `0`: The delivery method is disabled. `1`: The delivery destination is enabled.
 */
public data class GetAggregateDeliveriesPlainArgs(
    public val aggregatorId: String,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: Int? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cfg.inputs.GetAggregateDeliveriesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cfg.inputs.GetAggregateDeliveriesPlainArgs =
        com.pulumi.alicloud.cfg.inputs.GetAggregateDeliveriesPlainArgs.builder()
            .aggregatorId(aggregatorId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAggregateDeliveriesPlainArgs].
 */
@PulumiTagMarker
public class GetAggregateDeliveriesPlainArgsBuilder internal constructor() {
    private var aggregatorId: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: Int? = null

    /**
     * @param value The ID of the Aggregator.
     */
    @JvmName("sreaocmuhpswlnwa")
    public suspend fun aggregatorId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.aggregatorId = mapped
    }

    /**
     * @param value A list of Aggregate Delivery IDs.
     */
    @JvmName("bmiblffwkyeoaquk")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Aggregate Delivery IDs.
     */
    @JvmName("qrbolowwtkfayxhy")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value
     */
    @JvmName("dxsbkgedccxmfyll")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("myjakctibkryruam")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the delivery method. Valid values: `0`: The delivery method is disabled. `1`: The delivery destination is enabled.
     */
    @JvmName("mouvupvhigbodqkt")
    public suspend fun status(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetAggregateDeliveriesPlainArgs = GetAggregateDeliveriesPlainArgs(
        aggregatorId = aggregatorId ?: throw PulumiNullFieldException("aggregatorId"),
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
