@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin.inputs

import com.pulumi.alicloud.cfg.inputs.GetConfigurationRecordersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getConfigurationRecorders.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetConfigurationRecordersPlainArgs(
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cfg.inputs.GetConfigurationRecordersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cfg.inputs.GetConfigurationRecordersPlainArgs =
        com.pulumi.alicloud.cfg.inputs.GetConfigurationRecordersPlainArgs.builder()
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConfigurationRecordersPlainArgs].
 */
@PulumiTagMarker
public class GetConfigurationRecordersPlainArgsBuilder internal constructor() {
    private var outputFile: String? = null

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("onsbumgtrcvplhsd")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetConfigurationRecordersPlainArgs = GetConfigurationRecordersPlainArgs(
        outputFile = outputFile,
    )
}
