@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin.inputs

import com.pulumi.alicloud.cfg.inputs.GetDeliveriesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDeliveries.
 * @property ids A list of Delivery IDs.
 * @property nameRegex A regex string to filter results by delivery channel name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the delivery method. Valid values: `0`: The delivery method is disabled. `1`: The delivery destination is enabled.
 */
public data class GetDeliveriesPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: Int? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cfg.inputs.GetDeliveriesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cfg.inputs.GetDeliveriesPlainArgs =
        com.pulumi.alicloud.cfg.inputs.GetDeliveriesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDeliveriesPlainArgs].
 */
@PulumiTagMarker
public class GetDeliveriesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: Int? = null

    /**
     * @param value A list of Delivery IDs.
     */
    @JvmName("iocwobitsxppfedx")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Delivery IDs.
     */
    @JvmName("bowbydiqwlwgmpwq")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by delivery channel name.
     */
    @JvmName("rvpxlyrcylpydvki")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("lbcngtmftemdftut")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the delivery method. Valid values: `0`: The delivery method is disabled. `1`: The delivery destination is enabled.
     */
    @JvmName("rdtjgpqswkrsiknt")
    public suspend fun status(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetDeliveriesPlainArgs = GetDeliveriesPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
