@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin.inputs

import com.pulumi.alicloud.cfg.inputs.GetDeliveryChannelsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDeliveryChannels.
 * @property ids A list of Config Delivery Channel IDs.
 * @property nameRegex A regex string to filter results by delivery channel name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the config delivery channel. Valid values `0`: Disable delivery channel, `1`: Enable delivery channel.
 */
public data class GetDeliveryChannelsPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: Int? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cfg.inputs.GetDeliveryChannelsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cfg.inputs.GetDeliveryChannelsPlainArgs =
        com.pulumi.alicloud.cfg.inputs.GetDeliveryChannelsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDeliveryChannelsPlainArgs].
 */
@PulumiTagMarker
public class GetDeliveryChannelsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: Int? = null

    /**
     * @param value A list of Config Delivery Channel IDs.
     */
    @JvmName("fvxhadiipmrmcsym")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Config Delivery Channel IDs.
     */
    @JvmName("frqrlohvwkilmnxe")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by delivery channel name.
     */
    @JvmName("vmlonejepfttewqf")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ageutkfpqtojftaf")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the config delivery channel. Valid values `0`: Disable delivery channel, `1`: Enable delivery channel.
     */
    @JvmName("qnxigtajjkoqwhrq")
    public suspend fun status(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetDeliveryChannelsPlainArgs = GetDeliveryChannelsPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
