@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin.inputs

import com.pulumi.alicloud.cfg.inputs.GetRulesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRules.
 * @property configRuleState Field `config_rule_state` has been deprecated from provider version 1.124.1. New field `status` instead.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of Config Rule IDs.
 * @property nameRegex A regex string to filter results by rule name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property riskLevel The risk level of Config Rule. Valid values: `1`: Critical ,`2`: Warning , `3`: Info.
 * @property ruleName The name of config rule.
 * @property status The status of the config rule, valid values: `ACTIVE`, `DELETING`, `EVALUATING` and `INACTIVE`.
 */
public data class GetRulesPlainArgs(
    @Deprecated(
        message = """
  Field 'config_rule_state' has been deprecated from provider version 1.124.1. New field 'status'
      instead.
  """,
    )
    public val configRuleState: String? = null,
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val riskLevel: Int? = null,
    public val ruleName: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cfg.inputs.GetRulesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cfg.inputs.GetRulesPlainArgs =
        com.pulumi.alicloud.cfg.inputs.GetRulesPlainArgs.builder()
            .configRuleState(configRuleState?.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .riskLevel(riskLevel?.let({ args0 -> args0 }))
            .ruleName(ruleName?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRulesPlainArgs].
 */
@PulumiTagMarker
public class GetRulesPlainArgsBuilder internal constructor() {
    private var configRuleState: String? = null

    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var riskLevel: Int? = null

    private var ruleName: String? = null

    private var status: String? = null

    /**
     * @param value Field `config_rule_state` has been deprecated from provider version 1.124.1. New field `status` instead.
     */
    @Deprecated(
        message = """
  Field 'config_rule_state' has been deprecated from provider version 1.124.1. New field 'status'
      instead.
  """,
    )
    @JvmName("giccomgnelpdlmal")
    public suspend fun configRuleState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.configRuleState = mapped
    }

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("vsbsidykxcceonhn")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Config Rule IDs.
     */
    @JvmName("cwxysyroojhxevbw")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Config Rule IDs.
     */
    @JvmName("anlbhvqahhlpxjww")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by rule name.
     */
    @JvmName("yuxledqixiwprhba")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("dhyhfsoehujsjiee")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The risk level of Config Rule. Valid values: `1`: Critical ,`2`: Warning , `3`: Info.
     */
    @JvmName("qdjrfwvxsorqxdaf")
    public suspend fun riskLevel(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.riskLevel = mapped
    }

    /**
     * @param value The name of config rule.
     */
    @JvmName("xcspljaqnphbggsw")
    public suspend fun ruleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ruleName = mapped
    }

    /**
     * @param value The status of the config rule, valid values: `ACTIVE`, `DELETING`, `EVALUATING` and `INACTIVE`.
     */
    @JvmName("ysiqklhwuffdtgye")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetRulesPlainArgs = GetRulesPlainArgs(
        configRuleState = configRuleState,
        enableDetails = enableDetails,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        riskLevel = riskLevel,
        ruleName = ruleName,
        status = status,
    )
}
