@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accountId Aggregator account Uid.
 * @property accountName Aggregator account name.
 * @property accountType Aggregator account source type. Valid values: `ResourceDirectory`.
 */
public data class AggregatorAggregatorAccount(
    public val accountId: String,
    public val accountName: String,
    public val accountType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cfg.outputs.AggregatorAggregatorAccount): AggregatorAggregatorAccount = AggregatorAggregatorAccount(
            accountId = javaType.accountId(),
            accountName = javaType.accountName(),
            accountType = javaType.accountType(),
        )
    }
}
