@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property configRuleParameters A list of Config Rule Parameters. See `config_rule_parameters` below.
 * @property managedRuleIdentifier The Managed Rule Identifier.
 */
public data class CompliancePackConfigRule(
    public val configRuleParameters: List<CompliancePackConfigRuleConfigRuleParameter>? = null,
    public val managedRuleIdentifier: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cfg.outputs.CompliancePackConfigRule): CompliancePackConfigRule = CompliancePackConfigRule(
            configRuleParameters = javaType.configRuleParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cfg.kotlin.outputs.CompliancePackConfigRuleConfigRuleParameter.Companion.toKotlin(args0)
                })
            }),
            managedRuleIdentifier = javaType.managedRuleIdentifier(),
        )
    }
}
