@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property accountId The Aliyun User Id.
 * @property aggregateCompliancePackName The Aggregate Compliance Package Name.
 * @property aggregatorCompliancePackId The Aggregate Compliance Package Id.
 * @property compliancePackTemplateId The template ID of the Compliance Package.
 * @property configRules A list of The Aggregate Compliance Package Rules.
 * @property description The description of aggregate compliance pack.
 * @property id The ID of the Aggregate Compliance Pack.
 * @property riskLevel The Risk Level.
 * @property status The status of the resource. Valid values `ACTIVE`, `CREATING`, `INACTIVE`.
 */
public data class GetAggregateCompliancePacksPack(
    public val accountId: String,
    public val aggregateCompliancePackName: String,
    public val aggregatorCompliancePackId: String,
    public val compliancePackTemplateId: String,
    public val configRules: List<GetAggregateCompliancePacksPackConfigRule>,
    public val description: String,
    public val id: String,
    public val riskLevel: Int,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cfg.outputs.GetAggregateCompliancePacksPack): GetAggregateCompliancePacksPack = GetAggregateCompliancePacksPack(
            accountId = javaType.accountId(),
            aggregateCompliancePackName = javaType.aggregateCompliancePackName(),
            aggregatorCompliancePackId = javaType.aggregatorCompliancePackId(),
            compliancePackTemplateId = javaType.compliancePackTemplateId(),
            configRules = javaType.configRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cfg.kotlin.outputs.GetAggregateCompliancePacksPackConfigRule.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description(),
            id = javaType.id(),
            riskLevel = javaType.riskLevel(),
            status = javaType.status(),
        )
    }
}
