@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAggregateConfigRules.
 * @property aggregateConfigRuleName The name of the rule.
 * @property aggregatorId The ID of Aggregator.
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names A list of Aggregate Config Rule names.
 * @property outputFile
 * @property riskLevel The risk level of the resources that are not compliant with the rule. Valid values: `1`: critical, `2`: warning, `3`: info.
 * @property rules A list of Config Aggregate Config Rules. Each element contains the following attributes:
 * @property status The status of the rule.
 */
public data class GetAggregateConfigRulesResult(
    public val aggregateConfigRuleName: String? = null,
    public val aggregatorId: String,
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val riskLevel: Int? = null,
    public val rules: List<GetAggregateConfigRulesRule>,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cfg.outputs.GetAggregateConfigRulesResult): GetAggregateConfigRulesResult = GetAggregateConfigRulesResult(
            aggregateConfigRuleName = javaType.aggregateConfigRuleName().map({ args0 -> args0 }).orElse(null),
            aggregatorId = javaType.aggregatorId(),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            riskLevel = javaType.riskLevel().map({ args0 -> args0 }).orElse(null),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cfg.kotlin.outputs.GetAggregateConfigRulesRule.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
