@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property accountId The Aliyun User ID.
 * @property aggregateConfigRuleName The config rule name.
 * @property aggregatorId The ID of aggregator.
 * @property compliancePackId The ID of Compliance Package.
 * @property compliances The Compliance information.
 * @property configRuleArn The config rule arn.
 * @property configRuleId The ID of the rule.
 * @property configRuleTriggerTypes The trigger types of config rules.
 * @property description The description of the rule.
 * @property eventSource Event source of the Config Rule.
 * @property excludeResourceIdsScope The id of the resources to be evaluated against the rule.
 * @property id The ID of the Aggregate Config Rule.
 * @property inputParameters The settings of the input parameters for the rule.
 * @property maximumExecutionFrequency The frequency of the compliance evaluations.
 * @property modifiedTimestamp The timestamp when the rule was last modified.
 * @property regionIdsScope The scope of resource region ids.
 * @property resourceGroupIdsScope The scope of resource group ids.
 * @property resourceTypesScopes
 * @property riskLevel Optional, ForceNew) The Risk Level. Valid values `1`: critical, `2`: warning, `3`: info.
 * @property sourceIdentifier The identifier of the managed rule or the arn of the custom function.
 * @property sourceOwner The source owner of the Config Rule.
 * @property status The state of the config rule, valid values: `ACTIVE`, `DELETING`, `EVALUATING` and `INACTIVE`.
 * @property tagKeyScope The scope of tay key.
 * @property tagValueScope The scope of tay value.
 */
public data class GetAggregateConfigRulesRule(
    public val accountId: String,
    public val aggregateConfigRuleName: String,
    public val aggregatorId: String,
    public val compliancePackId: String,
    public val compliances: List<GetAggregateConfigRulesRuleCompliance>,
    public val configRuleArn: String,
    public val configRuleId: String,
    public val configRuleTriggerTypes: String,
    public val description: String,
    public val eventSource: String,
    public val excludeResourceIdsScope: String,
    public val id: String,
    public val inputParameters: Map<String, String>,
    public val maximumExecutionFrequency: String,
    public val modifiedTimestamp: String,
    public val regionIdsScope: String,
    public val resourceGroupIdsScope: String,
    public val resourceTypesScopes: List<String>,
    public val riskLevel: Int,
    public val sourceIdentifier: String,
    public val sourceOwner: String,
    public val status: String,
    public val tagKeyScope: String,
    public val tagValueScope: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cfg.outputs.GetAggregateConfigRulesRule): GetAggregateConfigRulesRule = GetAggregateConfigRulesRule(
            accountId = javaType.accountId(),
            aggregateConfigRuleName = javaType.aggregateConfigRuleName(),
            aggregatorId = javaType.aggregatorId(),
            compliancePackId = javaType.compliancePackId(),
            compliances = javaType.compliances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cfg.kotlin.outputs.GetAggregateConfigRulesRuleCompliance.Companion.toKotlin(args0)
                })
            }),
            configRuleArn = javaType.configRuleArn(),
            configRuleId = javaType.configRuleId(),
            configRuleTriggerTypes = javaType.configRuleTriggerTypes(),
            description = javaType.description(),
            eventSource = javaType.eventSource(),
            excludeResourceIdsScope = javaType.excludeResourceIdsScope(),
            id = javaType.id(),
            inputParameters = javaType.inputParameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            maximumExecutionFrequency = javaType.maximumExecutionFrequency(),
            modifiedTimestamp = javaType.modifiedTimestamp(),
            regionIdsScope = javaType.regionIdsScope(),
            resourceGroupIdsScope = javaType.resourceGroupIdsScope(),
            resourceTypesScopes = javaType.resourceTypesScopes().map({ args0 -> args0 }),
            riskLevel = javaType.riskLevel(),
            sourceIdentifier = javaType.sourceIdentifier(),
            sourceOwner = javaType.sourceOwner(),
            status = javaType.status(),
            tagKeyScope = javaType.tagKeyScope(),
            tagValueScope = javaType.tagValueScope(),
        )
    }
}
