@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accountId The Aliyun User Id.
 * @property aggregatorId The ID of the Aggregator.
 * @property configurationItemChangeNotification Open or close delivery configuration change history.
 * @property configurationSnapshot Open or close timed snapshot of shipping resources.
 * @property deliveryChannelAssumeRoleArn The Alibaba Cloud Resource Name (ARN) of the role to be assumed by the delivery method.
 * @property deliveryChannelCondition The rule attached to the delivery method.
 * @property deliveryChannelId The ID of the delivery method.
 * @property deliveryChannelName The name of the delivery method.
 * @property deliveryChannelTargetArn The ARN of the delivery destination.
 * @property deliveryChannelType The type of the delivery method.
 * @property description The description of the delivery method.
 * @property id The ID of the Aggregate Delivery.
 * @property nonCompliantNotification Open or close non-compliance events of delivery resources.
 * @property oversizedDataOssTargetArn The oss ARN of the delivery channel when the value data oversized limit.
 * @property status The status of the delivery method. Valid values: `0`: The delivery method is disabled. `1`: The delivery destination is enabled.
 */
public data class GetAggregateDeliveriesDelivery(
    public val accountId: String,
    public val aggregatorId: String,
    public val configurationItemChangeNotification: Boolean,
    public val configurationSnapshot: Boolean,
    public val deliveryChannelAssumeRoleArn: String,
    public val deliveryChannelCondition: String,
    public val deliveryChannelId: String,
    public val deliveryChannelName: String,
    public val deliveryChannelTargetArn: String,
    public val deliveryChannelType: String,
    public val description: String,
    public val id: String,
    public val nonCompliantNotification: Boolean,
    public val oversizedDataOssTargetArn: String,
    public val status: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cfg.outputs.GetAggregateDeliveriesDelivery): GetAggregateDeliveriesDelivery = GetAggregateDeliveriesDelivery(
            accountId = javaType.accountId(),
            aggregatorId = javaType.aggregatorId(),
            configurationItemChangeNotification = javaType.configurationItemChangeNotification(),
            configurationSnapshot = javaType.configurationSnapshot(),
            deliveryChannelAssumeRoleArn = javaType.deliveryChannelAssumeRoleArn(),
            deliveryChannelCondition = javaType.deliveryChannelCondition(),
            deliveryChannelId = javaType.deliveryChannelId(),
            deliveryChannelName = javaType.deliveryChannelName(),
            deliveryChannelTargetArn = javaType.deliveryChannelTargetArn(),
            deliveryChannelType = javaType.deliveryChannelType(),
            description = javaType.description(),
            id = javaType.id(),
            nonCompliantNotification = javaType.nonCompliantNotification(),
            oversizedDataOssTargetArn = javaType.oversizedDataOssTargetArn(),
            status = javaType.status(),
        )
    }
}
