@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property accountId Aggregator account uid.
 * @property aggregatorAccounts Account information in aggregator.
 * @property aggregatorId The id of aggregator.
 * @property aggregatorName The name of aggregator.
 * @property aggregatorType The type of aggregator.
 * @property description The description of aggregator.
 * @property id The id of the aggregator.
 * @property status The status of the resource. Valid Values:  `0`: creating `1`: normal `2`: deleting.
 */
public data class GetAggregatorsAggregator(
    public val accountId: String,
    public val aggregatorAccounts: List<GetAggregatorsAggregatorAggregatorAccount>,
    public val aggregatorId: String,
    public val aggregatorName: String,
    public val aggregatorType: String,
    public val description: String,
    public val id: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cfg.outputs.GetAggregatorsAggregator): GetAggregatorsAggregator = GetAggregatorsAggregator(
            accountId = javaType.accountId(),
            aggregatorAccounts = javaType.aggregatorAccounts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cfg.kotlin.outputs.GetAggregatorsAggregatorAggregatorAccount.Companion.toKotlin(args0)
                })
            }),
            aggregatorId = javaType.aggregatorId(),
            aggregatorName = javaType.aggregatorName(),
            aggregatorType = javaType.aggregatorType(),
            description = javaType.description(),
            id = javaType.id(),
            status = javaType.status(),
        )
    }
}
