@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property accountId The Aliyun User Id.
 * @property compliancePackId The Compliance Package ID.
 * @property compliancePackName The Compliance Package Name.
 * @property compliancePackTemplateId The template ID of the Compliance Package.
 * @property configRules A list of The Compliance Package Rules.
 * @property description The description of compliance pack.
 * @property id The ID of the Compliance Pack.
 * @property riskLevel The Ris Level.
 * @property status The status of the resource. Valid values `ACTIVE`, `CREATING`.
 */
public data class GetCompliancePacksPack(
    public val accountId: String,
    public val compliancePackId: String,
    public val compliancePackName: String,
    public val compliancePackTemplateId: String,
    public val configRules: List<GetCompliancePacksPackConfigRule>,
    public val description: String,
    public val id: String,
    public val riskLevel: Int,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cfg.outputs.GetCompliancePacksPack): GetCompliancePacksPack = GetCompliancePacksPack(
            accountId = javaType.accountId(),
            compliancePackId = javaType.compliancePackId(),
            compliancePackName = javaType.compliancePackName(),
            compliancePackTemplateId = javaType.compliancePackTemplateId(),
            configRules = javaType.configRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cfg.kotlin.outputs.GetCompliancePacksPackConfigRule.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description(),
            id = javaType.id(),
            riskLevel = javaType.riskLevel(),
            status = javaType.status(),
        )
    }
}
