@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property configRuleId The ID of the rule.
 * @property configRuleParameters A list of parameter rules.
 * @property managedRuleIdentifier Managed Rule Identifier.
 */
public data class GetCompliancePacksPackConfigRule(
    public val configRuleId: String,
    public val configRuleParameters: List<GetCompliancePacksPackConfigRuleConfigRuleParameter>,
    public val managedRuleIdentifier: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cfg.outputs.GetCompliancePacksPackConfigRule): GetCompliancePacksPackConfigRule = GetCompliancePacksPackConfigRule(
            configRuleId = javaType.configRuleId(),
            configRuleParameters = javaType.configRuleParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cfg.kotlin.outputs.GetCompliancePacksPackConfigRuleConfigRuleParameter.Companion.toKotlin(args0)
                })
            }),
            managedRuleIdentifier = javaType.managedRuleIdentifier(),
        )
    }
}
