@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property accountId The ID of the Alicloud account.
 * @property id The ID of the Config Configuration Recorder. Value as the `account_id`.
 * @property organizationEnableStatus Enterprise version configuration audit enabled status.
 * @property organizationMasterId The ID of the Enterprise management account.
 * @property resourceTypes A list of resource types to be monitored.
 * @property status Status of resource monitoring.
 */
public data class GetConfigurationRecordersRecorder(
    public val accountId: String,
    public val id: String,
    public val organizationEnableStatus: String,
    public val organizationMasterId: Int,
    public val resourceTypes: List<String>,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cfg.outputs.GetConfigurationRecordersRecorder): GetConfigurationRecordersRecorder = GetConfigurationRecordersRecorder(
            accountId = javaType.accountId(),
            id = javaType.id(),
            organizationEnableStatus = javaType.organizationEnableStatus(),
            organizationMasterId = javaType.organizationMasterId(),
            resourceTypes = javaType.resourceTypes().map({ args0 -> args0 }),
            status = javaType.status(),
        )
    }
}
