@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getConfigurationRecorders.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property outputFile
 * @property recorders A list of Config Configuration Recorders. Each element contains the following attributes:
 */
public data class GetConfigurationRecordersResult(
    public val id: String,
    public val outputFile: String? = null,
    public val recorders: List<GetConfigurationRecordersRecorder>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cfg.outputs.GetConfigurationRecordersResult): GetConfigurationRecordersResult = GetConfigurationRecordersResult(
            id = javaType.id(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            recorders = javaType.recorders().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cfg.kotlin.outputs.GetConfigurationRecordersRecorder.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
