@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deliveryChannelAssumeRoleArn The Alibaba Cloud Resource Name (ARN) of the role assumed by delivery method.
 * @property deliveryChannelCondition The rule attached to the delivery method. This parameter is applicable only to delivery methods of the Message Service (MNS) type.
 * @property deliveryChannelId The ID of the delivery channel.
 * @property deliveryChannelName The name of the delivery channel.
 * @property deliveryChannelTargetArn The ARN of the delivery destination.
 * @property deliveryChannelType The type of the delivery channel.
 * @property description The description of the delivery channel.
 * @property id The ID of the Config Delivery Channel.
 * @property status The status of the config delivery channel. Valid values `0`: Disable delivery channel, `1`: Enable delivery channel.
 */
public data class GetDeliveryChannelsChannel(
    public val deliveryChannelAssumeRoleArn: String,
    public val deliveryChannelCondition: String,
    public val deliveryChannelId: String,
    public val deliveryChannelName: String,
    public val deliveryChannelTargetArn: String,
    public val deliveryChannelType: String,
    public val description: String,
    public val id: String,
    public val status: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cfg.outputs.GetDeliveryChannelsChannel): GetDeliveryChannelsChannel = GetDeliveryChannelsChannel(
            deliveryChannelAssumeRoleArn = javaType.deliveryChannelAssumeRoleArn(),
            deliveryChannelCondition = javaType.deliveryChannelCondition(),
            deliveryChannelId = javaType.deliveryChannelId(),
            deliveryChannelName = javaType.deliveryChannelName(),
            deliveryChannelTargetArn = javaType.deliveryChannelTargetArn(),
            deliveryChannelType = javaType.deliveryChannelType(),
            description = javaType.description(),
            id = javaType.id(),
            status = javaType.status(),
        )
    }
}
