@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin.outputs

import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRules.
 * @property configRuleState The state of the Config Rule.
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Config Rule IDs.
 * @property nameRegex
 * @property names A list of Config Rule names.
 * @property outputFile
 * @property riskLevel The risk level of the Config Rule.
 * @property ruleName The name of the Config Rule.
 * @property rules A list of Config Rules. Each element contains the following attributes:
 * @property status (Available in 1.124.1+) The status of config rule.
 */
public data class GetRulesResult(
    @Deprecated(
        message = """
  Field 'config_rule_state' has been deprecated from provider version 1.124.1. New field 'status'
      instead.
  """,
    )
    public val configRuleState: String? = null,
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val riskLevel: Int? = null,
    public val ruleName: String? = null,
    public val rules: List<GetRulesRule>,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cfg.outputs.GetRulesResult): GetRulesResult =
            GetRulesResult(
                configRuleState = javaType.configRuleState().map({ args0 -> args0 }).orElse(null),
                enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                ids = javaType.ids().map({ args0 -> args0 }),
                nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
                names = javaType.names().map({ args0 -> args0 }),
                outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
                riskLevel = javaType.riskLevel().map({ args0 -> args0 }).orElse(null),
                ruleName = javaType.ruleName().map({ args0 -> args0 }).orElse(null),
                rules = javaType.rules().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.cfg.kotlin.outputs.GetRulesRule.Companion.toKotlin(args0)
                    })
                }),
                status = javaType.status().map({ args0 -> args0 }).orElse(null),
            )
    }
}
