@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property accountId The ID of the Alicloud account.
 * @property compliancePackId
 * @property compliances The information about the compliance evaluations based on the rule.
 * @property configRuleArn The ARN of the Config Rule.
 * @property configRuleId The ID of the Config Rule.
 * @property configRuleState Field `config_rule_state` has been deprecated from provider version 1.124.1. New field `status` instead.
 * @property configRuleTriggerTypes (Available in 1.124.1+) A list of trigger types of config rule.
 * @property description The description of the Config Rule.
 * @property eventSource Event source of the Config Rule.
 * @property excludeResourceIdsScope (Available in 1.124.1+) The scope of exclude of resource ids.
 * @property id The ID of the Config Rule.
 * @property inputParameters The input parameters of the Config Rule.
 * @property maximumExecutionFrequency (Available in 1.124.1+) The frequency of maximum execution.
 * @property modifiedTimestamp the timestamp of the Config Rule modified.
 * @property regionIdsScope (Available in 1.124.1+) The scope of region ids.
 * @property resourceGroupIdsScope (Available in 1.124.1+) The scope of resource group ids.
 * @property resourceTypesScopes (Available in 1.124.1+) The scope of resource types.
 * @property riskLevel The risk level of Config Rule. Valid values: `1`: Critical ,`2`: Warning , `3`: Info.
 * @property ruleName The name of config rule.
 * @property scopeComplianceResourceTypes The types of the resources to be evaluated against the rule.
 * @property sourceDetailMessageType Rule trigger mechanism.
 * @property sourceIdentifier The identifier of the managed rule or the arn of the custom function.
 * @property sourceMaximumExecutionFrequency Rule execution cycle.
 * @property sourceOwner The source owner of the Config Rule.
 * @property status The status of the config rule, valid values: `ACTIVE`, `DELETING`, `EVALUATING` and `INACTIVE`.
 * @property tagKeyScope (Available in 1.124.1+) The scope of tag key.
 * @property tagValueScope (Available in 1.124.1+) The scope of tag value.
 */
public data class GetRulesRule(
    public val accountId: String,
    public val compliancePackId: String,
    public val compliances: List<GetRulesRuleCompliance>,
    public val configRuleArn: String,
    public val configRuleId: String,
    public val configRuleState: String,
    public val configRuleTriggerTypes: String,
    public val description: String,
    public val eventSource: String,
    public val excludeResourceIdsScope: String,
    public val id: String,
    public val inputParameters: Map<String, String>,
    public val maximumExecutionFrequency: String,
    public val modifiedTimestamp: String,
    public val regionIdsScope: String,
    public val resourceGroupIdsScope: String,
    public val resourceTypesScopes: List<String>,
    public val riskLevel: Int,
    public val ruleName: String,
    public val scopeComplianceResourceTypes: List<String>,
    public val sourceDetailMessageType: String,
    public val sourceIdentifier: String,
    public val sourceMaximumExecutionFrequency: String,
    public val sourceOwner: String,
    public val status: String,
    public val tagKeyScope: String,
    public val tagValueScope: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cfg.outputs.GetRulesRule): GetRulesRule =
            GetRulesRule(
                accountId = javaType.accountId(),
                compliancePackId = javaType.compliancePackId(),
                compliances = javaType.compliances().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.cfg.kotlin.outputs.GetRulesRuleCompliance.Companion.toKotlin(args0)
                    })
                }),
                configRuleArn = javaType.configRuleArn(),
                configRuleId = javaType.configRuleId(),
                configRuleState = javaType.configRuleState(),
                configRuleTriggerTypes = javaType.configRuleTriggerTypes(),
                description = javaType.description(),
                eventSource = javaType.eventSource(),
                excludeResourceIdsScope = javaType.excludeResourceIdsScope(),
                id = javaType.id(),
                inputParameters = javaType.inputParameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                maximumExecutionFrequency = javaType.maximumExecutionFrequency(),
                modifiedTimestamp = javaType.modifiedTimestamp(),
                regionIdsScope = javaType.regionIdsScope(),
                resourceGroupIdsScope = javaType.resourceGroupIdsScope(),
                resourceTypesScopes = javaType.resourceTypesScopes().map({ args0 -> args0 }),
                riskLevel = javaType.riskLevel(),
                ruleName = javaType.ruleName(),
                scopeComplianceResourceTypes = javaType.scopeComplianceResourceTypes().map({ args0 -> args0 }),
                sourceDetailMessageType = javaType.sourceDetailMessageType(),
                sourceIdentifier = javaType.sourceIdentifier(),
                sourceMaximumExecutionFrequency = javaType.sourceMaximumExecutionFrequency(),
                sourceOwner = javaType.sourceOwner(),
                status = javaType.status(),
                tagKeyScope = javaType.tagKeyScope(),
                tagValueScope = javaType.tagValueScope(),
            )
    }
}
