@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property complianceType The compliance evaluation result of the target resources.
 * @property count The number of resources with the specified compliance evaluation result.
 */
public data class GetRulesRuleCompliance(
    public val complianceType: String,
    public val count: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cfg.outputs.GetRulesRuleCompliance): GetRulesRuleCompliance = GetRulesRuleCompliance(
            complianceType = javaType.complianceType(),
            count = javaType.count(),
        )
    }
}
