@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property complianceType The type of compliance. Valid values: `COMPLIANT`, `NON_COMPLIANT`, `NOT_APPLICABLE`, `INSUFFICIENT_DATA`.
 * @property count The count of compliance.
 */
public data class RuleCompliance(
    public val complianceType: String? = null,
    public val count: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cfg.outputs.RuleCompliance): RuleCompliance =
            RuleCompliance(
                complianceType = javaType.complianceType().map({ args0 -> args0 }).orElse(null),
                count = javaType.count().map({ args0 -> args0 }).orElse(null),
            )
    }
}
