@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.chatbot.kotlin

import com.pulumi.alicloud.chatbot.ChatbotFunctions.getAgentsPlain
import com.pulumi.alicloud.chatbot.kotlin.inputs.GetAgentsPlainArgs
import com.pulumi.alicloud.chatbot.kotlin.inputs.GetAgentsPlainArgsBuilder
import com.pulumi.alicloud.chatbot.kotlin.outputs.GetAgentsResult
import com.pulumi.alicloud.chatbot.kotlin.outputs.GetAgentsResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object ChatbotFunctions {
    /**
     * This data source provides the Chatbot Agents of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.203.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const nameRegex = alicloud.chatbot.getAgents({
     *     nameRegex: "^my-Agent",
     * });
     * export const alicloudChatbotAgentsId1 = nameRegex.then(nameRegex => nameRegex.agents?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * name_regex = alicloud.chatbot.get_agents(name_regex="^my-Agent")
     * pulumi.export("alicloudChatbotAgentsId1", name_regex.agents[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var nameRegex = AliCloud.Chatbot.GetAgents.Invoke(new()
     *     {
     *         NameRegex = "^my-Agent",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudChatbotAgentsId1"] = nameRegex&#46;Apply(getAgentsResult => getAgentsResult&#46;Agents[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/chatbot"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		nameRegex, err := chatbot.GetAgents(ctx, &chatbot.GetAgentsArgs{
     * 			NameRegex: pulumi.StringRef("^my-Agent"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudChatbotAgentsId1", nameRegex.Agents[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.chatbot.ChatbotFunctions;
     * import com.pulumi.alicloud.chatbot.inputs.GetAgentsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var nameRegex = ChatbotFunctions.getAgents(GetAgentsArgs.builder()
     *             .nameRegex("^my-Agent")
     *             .build());
     *         ctx.export("alicloudChatbotAgentsId1", nameRegex.applyValue(getAgentsResult -> getAgentsResult.agents()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:chatbot:getAgents
     *       Arguments:
     *         nameRegex: ^my-Agent
     * outputs:
     *   alicloudChatbotAgentsId1: ${nameRegex.agents[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAgents.
     * @return A collection of values returned by getAgents.
     */
    public suspend fun getAgents(argument: GetAgentsPlainArgs): GetAgentsResult =
        toKotlin(getAgentsPlain(argument.toJava()).await())

    /**
     * @see [getAgents].
     * @param agentName The name of the agent.
     * @param nameRegex A regex string to filter resulting chatbot agents by name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @return A collection of values returned by getAgents.
     */
    public suspend fun getAgents(
        agentName: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
    ): GetAgentsResult {
        val argument = GetAgentsPlainArgs(
            agentName = agentName,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
        )
        return toKotlin(getAgentsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAgents].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;chatbot&#46;kotlin&#46;inputs&#46;GetAgentsPlainArgs].
     * @return A collection of values returned by getAgents.
     */
    public suspend fun getAgents(argument: suspend GetAgentsPlainArgsBuilder.() -> Unit): GetAgentsResult {
        val builder = GetAgentsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getAgentsPlain(builtArgument.toJava()).await())
    }
}
