@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.chatbot.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [PublishTask].
 */
@PulumiTagMarker
public class PublishTaskResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PublishTaskArgs = PublishTaskArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PublishTaskArgsBuilder.() -> Unit) {
        val builder = PublishTaskArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PublishTask {
        val builtJavaResource = com.pulumi.alicloud.chatbot.PublishTask(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PublishTask(builtJavaResource)
    }
}

/**
 * Provides a Chatbot Publish Task resource.
 * For information about Chatbot Publish Task and how to use it, see [What is Publish Task](https://help.aliyun.com/document_detail/433996.html).
 * > **NOTE:** Available since v1.203.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.chatbot.getAgents({});
 * const defaultPublishTask = new alicloud.chatbot.PublishTask("default", {
 *     bizType: "faq",
 *     agentKey: _default.then(_default => _default.agents?.[0]?.agentKey),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.chatbot.get_agents()
 * default_publish_task = alicloud.chatbot.PublishTask("default",
 *     biz_type="faq",
 *     agent_key=default.agents[0].agent_key)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.Chatbot.GetAgents.Invoke();
 *     var defaultPublishTask = new AliCloud.Chatbot.PublishTask("default", new()
 *     {
 *         BizType = "faq",
 *         AgentKey = @default.Apply(@default => @default.Apply(getAgentsResult => getAgentsResult.Agents[0]?.AgentKey)),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/chatbot"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := chatbot.GetAgents(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = chatbot.NewPublishTask(ctx, "default", &chatbot.PublishTaskArgs{
 * 			BizType:  pulumi.String("faq"),
 * 			AgentKey: pulumi.String(_default.Agents[0].AgentKey),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.chatbot.ChatbotFunctions;
 * import com.pulumi.alicloud.chatbot.inputs.GetAgentsArgs;
 * import com.pulumi.alicloud.chatbot.PublishTask;
 * import com.pulumi.alicloud.chatbot.PublishTaskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = ChatbotFunctions.getAgents();
 *         var defaultPublishTask = new PublishTask("defaultPublishTask", PublishTaskArgs.builder()
 *             .bizType("faq")
 *             .agentKey(default_.agents()[0].agentKey())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultPublishTask:
 *     type: alicloud:chatbot:PublishTask
 *     name: default
 *     properties:
 *       bizType: faq
 *       agentKey: ${default.agents[0].agentKey}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:chatbot:getAgents
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Chatbot Publish Task can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:chatbot/publishTask:PublishTask example <id>
 * ```
 */
public class PublishTask internal constructor(
    override val javaResource: com.pulumi.alicloud.chatbot.PublishTask,
) : KotlinCustomResource(javaResource, PublishTaskMapper) {
    /**
     * The business space key. If you do not set it, the default business space is accessed. The key value is obtained on the business management page of the primary account.
     */
    public val agentKey: Output<String>
        get() = javaResource.agentKey().applyValue({ args0 -> args0 })

    /**
     * The type of the publishing unit. Please use the CreateInstancePublishTask API to publish the robot.
     */
    public val bizType: Output<String>
        get() = javaResource.bizType().applyValue({ args0 -> args0 })

    /**
     * UTC time of task creation
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Additional release information. Currently supported: If the BizType is faq, enter the category Id in this field to indicate that only the knowledge under these categories is published.
     */
    public val dataIdLists: Output<List<String>>?
        get() = javaResource.dataIdLists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * UTC time for task modification
     */
    public val modifyTime: Output<String>
        get() = javaResource.modifyTime().applyValue({ args0 -> args0 })

    /**
     * The status of the task.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object PublishTaskMapper : ResourceMapper<PublishTask> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.chatbot.PublishTask::class == javaResource::class

    override fun map(javaResource: Resource): PublishTask = PublishTask(
        javaResource as
            com.pulumi.alicloud.chatbot.PublishTask,
    )
}

/**
 * @see [PublishTask].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PublishTask].
 */
public suspend fun publishTask(name: String, block: suspend PublishTaskResourceBuilder.() -> Unit): PublishTask {
    val builder = PublishTaskResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PublishTask].
 * @param name The _unique_ name of the resulting resource.
 */
public fun publishTask(name: String): PublishTask {
    val builder = PublishTaskResourceBuilder()
    builder.name(name)
    return builder.build()
}
