@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.chatbot.kotlin

import com.pulumi.alicloud.chatbot.PublishTaskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Chatbot Publish Task resource.
 * For information about Chatbot Publish Task and how to use it, see [What is Publish Task](https://help.aliyun.com/document_detail/433996.html).
 * > **NOTE:** Available since v1.203.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.chatbot.getAgents({});
 * const defaultPublishTask = new alicloud.chatbot.PublishTask("default", {
 *     bizType: "faq",
 *     agentKey: _default.then(_default => _default.agents?.[0]?.agentKey),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.chatbot.get_agents()
 * default_publish_task = alicloud.chatbot.PublishTask("default",
 *     biz_type="faq",
 *     agent_key=default.agents[0].agent_key)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.Chatbot.GetAgents.Invoke();
 *     var defaultPublishTask = new AliCloud.Chatbot.PublishTask("default", new()
 *     {
 *         BizType = "faq",
 *         AgentKey = @default.Apply(@default => @default.Apply(getAgentsResult => getAgentsResult.Agents[0]?.AgentKey)),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/chatbot"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := chatbot.GetAgents(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = chatbot.NewPublishTask(ctx, "default", &chatbot.PublishTaskArgs{
 * 			BizType:  pulumi.String("faq"),
 * 			AgentKey: pulumi.String(_default.Agents[0].AgentKey),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.chatbot.ChatbotFunctions;
 * import com.pulumi.alicloud.chatbot.inputs.GetAgentsArgs;
 * import com.pulumi.alicloud.chatbot.PublishTask;
 * import com.pulumi.alicloud.chatbot.PublishTaskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = ChatbotFunctions.getAgents();
 *         var defaultPublishTask = new PublishTask("defaultPublishTask", PublishTaskArgs.builder()
 *             .bizType("faq")
 *             .agentKey(default_.agents()[0].agentKey())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultPublishTask:
 *     type: alicloud:chatbot:PublishTask
 *     name: default
 *     properties:
 *       bizType: faq
 *       agentKey: ${default.agents[0].agentKey}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:chatbot:getAgents
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Chatbot Publish Task can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:chatbot/publishTask:PublishTask example <id>
 * ```
 * @property agentKey The business space key. If you do not set it, the default business space is accessed. The key value is obtained on the business management page of the primary account.
 * @property bizType The type of the publishing unit. Please use the CreateInstancePublishTask API to publish the robot.
 * @property dataIdLists Additional release information. Currently supported: If the BizType is faq, enter the category Id in this field to indicate that only the knowledge under these categories is published.
 */
public data class PublishTaskArgs(
    public val agentKey: Output<String>? = null,
    public val bizType: Output<String>? = null,
    public val dataIdLists: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.chatbot.PublishTaskArgs> {
    override fun toJava(): com.pulumi.alicloud.chatbot.PublishTaskArgs =
        com.pulumi.alicloud.chatbot.PublishTaskArgs.builder()
            .agentKey(agentKey?.applyValue({ args0 -> args0 }))
            .bizType(bizType?.applyValue({ args0 -> args0 }))
            .dataIdLists(dataIdLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PublishTaskArgs].
 */
@PulumiTagMarker
public class PublishTaskArgsBuilder internal constructor() {
    private var agentKey: Output<String>? = null

    private var bizType: Output<String>? = null

    private var dataIdLists: Output<List<String>>? = null

    /**
     * @param value The business space key. If you do not set it, the default business space is accessed. The key value is obtained on the business management page of the primary account.
     */
    @JvmName("mntyrlqfyrbuoxwb")
    public suspend fun agentKey(`value`: Output<String>) {
        this.agentKey = value
    }

    /**
     * @param value The type of the publishing unit. Please use the CreateInstancePublishTask API to publish the robot.
     */
    @JvmName("fqdqtfkfqgsnkngx")
    public suspend fun bizType(`value`: Output<String>) {
        this.bizType = value
    }

    /**
     * @param value Additional release information. Currently supported: If the BizType is faq, enter the category Id in this field to indicate that only the knowledge under these categories is published.
     */
    @JvmName("kcvefmnjnjfnspdl")
    public suspend fun dataIdLists(`value`: Output<List<String>>) {
        this.dataIdLists = value
    }

    @JvmName("rcqgqxssphcjjnek")
    public suspend fun dataIdLists(vararg values: Output<String>) {
        this.dataIdLists = Output.all(values.asList())
    }

    /**
     * @param values Additional release information. Currently supported: If the BizType is faq, enter the category Id in this field to indicate that only the knowledge under these categories is published.
     */
    @JvmName("fxweftofuvrlgvpf")
    public suspend fun dataIdLists(values: List<Output<String>>) {
        this.dataIdLists = Output.all(values)
    }

    /**
     * @param value The business space key. If you do not set it, the default business space is accessed. The key value is obtained on the business management page of the primary account.
     */
    @JvmName("nciibahqoydvxypg")
    public suspend fun agentKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentKey = mapped
    }

    /**
     * @param value The type of the publishing unit. Please use the CreateInstancePublishTask API to publish the robot.
     */
    @JvmName("yplykqptntudwblb")
    public suspend fun bizType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bizType = mapped
    }

    /**
     * @param value Additional release information. Currently supported: If the BizType is faq, enter the category Id in this field to indicate that only the knowledge under these categories is published.
     */
    @JvmName("ihvfiejmmfaycjrp")
    public suspend fun dataIdLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataIdLists = mapped
    }

    /**
     * @param values Additional release information. Currently supported: If the BizType is faq, enter the category Id in this field to indicate that only the knowledge under these categories is published.
     */
    @JvmName("adqfwpqustaqhdii")
    public suspend fun dataIdLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataIdLists = mapped
    }

    internal fun build(): PublishTaskArgs = PublishTaskArgs(
        agentKey = agentKey,
        bizType = bizType,
        dataIdLists = dataIdLists,
    )
}
