@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.chatbot.kotlin.inputs

import com.pulumi.alicloud.chatbot.inputs.GetAgentsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAgents.
 * @property agentName The name of the agent.
 * @property nameRegex A regex string to filter resulting chatbot agents by name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 */
public data class GetAgentsPlainArgs(
    public val agentName: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
) : ConvertibleToJava<com.pulumi.alicloud.chatbot.inputs.GetAgentsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.chatbot.inputs.GetAgentsPlainArgs =
        com.pulumi.alicloud.chatbot.inputs.GetAgentsPlainArgs.builder()
            .agentName(agentName?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAgentsPlainArgs].
 */
@PulumiTagMarker
public class GetAgentsPlainArgsBuilder internal constructor() {
    private var agentName: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    /**
     * @param value The name of the agent.
     */
    @JvmName("uktkubdmokkkwoxt")
    public suspend fun agentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.agentName = mapped
    }

    /**
     * @param value A regex string to filter resulting chatbot agents by name.
     */
    @JvmName("ikqpsnljmsekilau")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ujkqsrbeydrcinvo")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("xavxixcryfwuufsh")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("ewxktlwktjsrnuwg")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    internal fun build(): GetAgentsPlainArgs = GetAgentsPlainArgs(
        agentName = agentName,
        nameRegex = nameRegex,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
    )
}
