@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.chatbot.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property agentId The agent id.
 * @property agentKey Service space signature, which is used when PAAS interface specifies the service space.
 * @property agentName The name of the agent.
 * @property id ID of the agent.
 */
public data class GetAgentsAgent(
    public val agentId: String,
    public val agentKey: String,
    public val agentName: String,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.chatbot.outputs.GetAgentsAgent): GetAgentsAgent = GetAgentsAgent(
            agentId = javaType.agentId(),
            agentKey = javaType.agentKey(),
            agentName = javaType.agentName(),
            id = javaType.id(),
        )
    }
}
