@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.chatbot.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAgents.
 * @property agentName The agent Name.
 * @property agents A list of availability zones. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names A list of chatbot agents names.
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 */
public data class GetAgentsResult(
    public val agentName: String,
    public val agents: List<GetAgentsAgent>,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.chatbot.outputs.GetAgentsResult): GetAgentsResult = GetAgentsResult(
            agentName = javaType.agentName(),
            agents = javaType.agents().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.chatbot.kotlin.outputs.GetAgentsAgent.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
