@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.clickhouse.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Account].
 */
@PulumiTagMarker
public class AccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccountArgs = AccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccountArgsBuilder.() -> Unit) {
        val builder = AccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Account {
        val builtJavaResource = com.pulumi.alicloud.clickhouse.Account(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Account(builtJavaResource)
    }
}

/**
 * Provides a Click House Account resource.
 * For information about Click House Account and how to use it, see [What is Account](https://www.alibabacloud.com/help/zh/clickhouse/latest/api-clickhouse-2019-11-11-createaccount).
 * > **NOTE:** Available since v1.134.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const type = config.get("type") || "Normal";
 * const default = alicloud.clickhouse.getRegions({
 *     current: true,
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.0.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.regions?.[0]?&#46;zoneIds?&#46;[0]?.zoneId),
 * });
 * const defaultDbCluster = new alicloud.clickhouse.DbCluster("default", {
 *     dbClusterVersion: "22.8.5.29",
 *     category: "Basic",
 *     dbClusterClass: "S8",
 *     dbClusterNetworkType: "vpc",
 *     dbNodeGroupCount: 1,
 *     paymentType: "PayAsYouGo",
 *     dbNodeStorage: "500",
 *     storageType: "cloud_essd",
 *     vswitchId: defaultSwitch.id,
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultAccount = new alicloud.clickhouse.Account("default", {
 *     dbClusterId: defaultDbCluster.id,
 *     accountDescription: "tf-example-description",
 *     accountName: "examplename",
 *     accountPassword: "Example1234",
 *     type: type,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * type = config.get("type")
 * if type is None:
 *     type = "Normal"
 * default = alicloud.clickhouse.get_regions(current=True)
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="10.4.0.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default.regions[0]&#46;zone_ids[0].zone_id)
 * default_db_cluster = alicloud.clickhouse.DbCluster("default",
 *     db_cluster_version="22.8.5.29",
 *     category="Basic",
 *     db_cluster_class="S8",
 *     db_cluster_network_type="vpc",
 *     db_node_group_count=1,
 *     payment_type="PayAsYouGo",
 *     db_node_storage="500",
 *     storage_type="cloud_essd",
 *     vswitch_id=default_switch.id,
 *     vpc_id=default_network.id)
 * default_account = alicloud.clickhouse.Account("default",
 *     db_cluster_id=default_db_cluster.id,
 *     account_description="tf-example-description",
 *     account_name="examplename",
 *     account_password="Example1234",
 *     type=type)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var type = config.Get("type") ?? "Normal";
 *     var @default = AliCloud.ClickHouse.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.0.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?&#46;ZoneIds[0]?.ZoneId)),
 *     });
 *     var defaultDbCluster = new AliCloud.ClickHouse.DbCluster("default", new()
 *     {
 *         DbClusterVersion = "22.8.5.29",
 *         Category = "Basic",
 *         DbClusterClass = "S8",
 *         DbClusterNetworkType = "vpc",
 *         DbNodeGroupCount = 1,
 *         PaymentType = "PayAsYouGo",
 *         DbNodeStorage = "500",
 *         StorageType = "cloud_essd",
 *         VswitchId = defaultSwitch.Id,
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultAccount = new AliCloud.ClickHouse.Account("default", new()
 *     {
 *         DbClusterId = defaultDbCluster.Id,
 *         AccountDescription = "tf-example-description",
 *         AccountName = "examplename",
 *         AccountPassword = "Example1234",
 *         Type = type,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/clickhouse"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_type := "Normal"
 * 		if param := cfg.Get("type"); param != "" {
 * 			_type = param
 * 		}
 * 		_default, err := clickhouse.GetRegions(ctx, &clickhouse.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.0.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(_default.Regions[0]&#46;ZoneIds[0].ZoneId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultDbCluster, err := clickhouse.NewDbCluster(ctx, "default", &clickhouse.DbClusterArgs{
 * 			DbClusterVersion:     pulumi.String("22.8.5.29"),
 * 			Category:             pulumi.String("Basic"),
 * 			DbClusterClass:       pulumi.String("S8"),
 * 			DbClusterNetworkType: pulumi.String("vpc"),
 * 			DbNodeGroupCount:     pulumi.Int(1),
 * 			PaymentType:          pulumi.String("PayAsYouGo"),
 * 			DbNodeStorage:        pulumi.String("500"),
 * 			StorageType:          pulumi.String("cloud_essd"),
 * 			VswitchId:            defaultSwitch.ID(),
 * 			VpcId:                defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = clickhouse.NewAccount(ctx, "default", &clickhouse.AccountArgs{
 * 			DbClusterId:        defaultDbCluster.ID(),
 * 			AccountDescription: pulumi.String("tf-example-description"),
 * 			AccountName:        pulumi.String("examplename"),
 * 			AccountPassword:    pulumi.String("Example1234"),
 * 			Type:               pulumi.String(_type),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.clickhouse.ClickhouseFunctions;
 * import com.pulumi.alicloud.clickhouse.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.clickhouse.DbCluster;
 * import com.pulumi.alicloud.clickhouse.DbClusterArgs;
 * import com.pulumi.alicloud.clickhouse.Account;
 * import com.pulumi.alicloud.clickhouse.AccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var type = config.get("type").orElse("Normal");
 *         final var default = ClickhouseFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.0.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.regions()[0]&#46;zoneIds()[0].zoneId())
 *             .build());
 *         var defaultDbCluster = new DbCluster("defaultDbCluster", DbClusterArgs.builder()
 *             .dbClusterVersion("22.8.5.29")
 *             .category("Basic")
 *             .dbClusterClass("S8")
 *             .dbClusterNetworkType("vpc")
 *             .dbNodeGroupCount("1")
 *             .paymentType("PayAsYouGo")
 *             .dbNodeStorage("500")
 *             .storageType("cloud_essd")
 *             .vswitchId(defaultSwitch.id())
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultAccount = new Account("defaultAccount", AccountArgs.builder()
 *             .dbClusterId(defaultDbCluster.id())
 *             .accountDescription("tf-example-description")
 *             .accountName("examplename")
 *             .accountPassword("Example1234")
 *             .type(type)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 *   type:
 *     type: string
 *     default: Normal
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.4.0.0/24
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${default.regions[0]&#46;zoneIds[0].zoneId}
 *   defaultDbCluster:
 *     type: alicloud:clickhouse:DbCluster
 *     name: default
 *     properties:
 *       dbClusterVersion: 22.8.5.29
 *       category: Basic
 *       dbClusterClass: S8
 *       dbClusterNetworkType: vpc
 *       dbNodeGroupCount: '1'
 *       paymentType: PayAsYouGo
 *       dbNodeStorage: '500'
 *       storageType: cloud_essd
 *       vswitchId: ${defaultSwitch.id}
 *       vpcId: ${defaultNetwork.id}
 *   defaultAccount:
 *     type: alicloud:clickhouse:Account
 *     name: default
 *     properties:
 *       dbClusterId: ${defaultDbCluster.id}
 *       accountDescription: tf-example-description
 *       accountName: examplename
 *       accountPassword: Example1234
 *       type: ${type}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:clickhouse:getRegions
 *       Arguments:
 *         current: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Click House Account can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:clickhouse/account:Account example <db_cluster_id>:<account_name>
 * ```
 */
public class Account internal constructor(
    override val javaResource: com.pulumi.alicloud.clickhouse.Account,
) : KotlinCustomResource(javaResource, AccountMapper) {
    /**
     * In Chinese, English letter. May contain Chinese and English characters, lowercase letters, numbers, and underscores (_), the dash (-). Cannot start with http:// and https:// at the beginning. Length is from 2 to 256 characters.
     */
    public val accountDescription: Output<String>?
        get() = javaResource.accountDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Account name: lowercase letters, numbers, underscores, lowercase letter; length no more than 16 characters.
     */
    public val accountName: Output<String>
        get() = javaResource.accountName().applyValue({ args0 -> args0 })

    /**
     * The account password: uppercase letters, lowercase letters, lowercase letters, numbers, and special characters (special character! #$%^& author (s):_+-=) in a length of 8-32 bit.
     */
    public val accountPassword: Output<String>
        get() = javaResource.accountPassword().applyValue({ args0 -> args0 })

    /**
     * The list of databases to which you want to grant permissions. Separate databases with commas (,).
     */
    public val allowDatabases: Output<String>
        get() = javaResource.allowDatabases().applyValue({ args0 -> args0 })

    /**
     * The list of dictionaries to which you want to grant permissions. Separate dictionaries with commas (,).
     */
    public val allowDictionaries: Output<String>
        get() = javaResource.allowDictionaries().applyValue({ args0 -> args0 })

    /**
     * The db cluster id.
     */
    public val dbClusterId: Output<String>
        get() = javaResource.dbClusterId().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to grant DDL permissions to the database account. Valid values: `true` and `false`.
     */
    public val ddlAuthority: Output<Boolean>
        get() = javaResource.ddlAuthority().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to grant DML permissions to the database account. Valid values: `all` and `readOnly,modify`.
     */
    public val dmlAuthority: Output<String>
        get() = javaResource.dmlAuthority().applyValue({ args0 -> args0 })

    /**
     * The status of the resource. Valid Status: `Creating`,`Available`,`Deleting`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The list of all databases. Separate databases with commas (,). Field 'total_databases' has been deprecated from provider version 1.223.1.
     */
    @Deprecated(
        message = """
  Field 'total_databases' has been deprecated from version 1.223.1 and it will be removed in the
      future version.
  """,
    )
    public val totalDatabases: Output<String>
        get() = javaResource.totalDatabases().applyValue({ args0 -> args0 })

    /**
     * The list of all dictionaries. Separate dictionaries with commas (,). Field 'total_dictionaries' has been deprecated from provider version 1.223.1.
     */
    @Deprecated(
        message = """
  Field 'total_dictionaries' has been deprecated from version 1.223.1 and it will be removed in the
      future version.
  """,
    )
    public val totalDictionaries: Output<String>
        get() = javaResource.totalDictionaries().applyValue({ args0 -> args0 })

    /**
     * The type of the database account. Valid values: `Normal` or `Super`.
     */
    public val type: Output<String>?
        get() = javaResource.type().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object AccountMapper : ResourceMapper<Account> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.clickhouse.Account::class == javaResource::class

    override fun map(javaResource: Resource): Account = Account(
        javaResource as
            com.pulumi.alicloud.clickhouse.Account,
    )
}

/**
 * @see [Account].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Account].
 */
public suspend fun account(name: String, block: suspend AccountResourceBuilder.() -> Unit): Account {
    val builder = AccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Account].
 * @param name The _unique_ name of the resulting resource.
 */
public fun account(name: String): Account {
    val builder = AccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
